/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class ObjectNamePatternHelper
/*     */ {
/*     */   public static boolean patternMatch(ObjectName test, ObjectName pattern)
/*     */   {
/*  53 */     if (pattern.equals("*:*")) {
/*  54 */       return true;
/*     */     }
/*  56 */     if (patternMatch(test.getDomain(), pattern.getDomain()))
/*     */     {
/*  58 */       PropertyPattern propertyPattern = new PropertyPattern(pattern);
/*  59 */       return propertyPattern.patternMatch(test);
/*     */     }
/*  61 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean patternMatch(String test, String pattern)
/*     */   {
/*  72 */     if (pattern.equals("*"))
/*  73 */       return true;
/*  74 */     return patternMatch(test.toCharArray(), 0, pattern.toCharArray(), 0);
/*     */   }
/*     */ 
/*     */   public static boolean patternMatch(char[] test, int tpos, char[] pattern, int ppos)
/*     */   {
/*  92 */     int tlen = test.length;
/*  93 */     int plen = pattern.length;
/*     */ 
/*  95 */     while (ppos < plen)
/*     */     {
/*  97 */       char c = pattern[(ppos++)];
/*  98 */       if ('?' == c)
/*     */       {
/* 102 */         if (tpos++ == tlen)
/* 103 */           return false;
/*     */       }
/* 105 */       else if ('*' == c)
/*     */       {
/* 107 */         if (ppos == plen) {
/* 108 */           return true;
/*     */         }
/*     */ 
/* 111 */         if (tpos == tlen) {
/* 112 */           return false;
/*     */         }
/*     */ 
/*     */         do
/*     */         {
/* 118 */           if (patternMatch(test, tpos, pattern, ppos)) {
/* 119 */             return true;
/*     */           }
/* 121 */           tpos++; } while (tpos < tlen);
/*     */       }
/* 123 */       else if ((tpos == tlen) || (c != test[(tpos++)])) {
/* 124 */         return false;
/*     */       }
/*     */     }
/* 127 */     return tpos == tlen;
/*     */   }
/*     */ 
/*     */   public static class PropertyPattern
/*     */   {
/*     */     boolean isPropertyPattern;
/*     */     Object[] propertyKeys;
/*     */     Object[] propertyValues;
/*     */     String canonicalKeyPropertyString;
/*     */ 
/*     */     public PropertyPattern(ObjectName pattern)
/*     */     {
/* 162 */       this.isPropertyPattern = pattern.isPropertyPattern();
/* 163 */       if (this.isPropertyPattern)
/*     */       {
/* 165 */         Hashtable patternKPList = pattern.getKeyPropertyList();
/* 166 */         int length = patternKPList.size();
/* 167 */         this.propertyKeys = new Object[length];
/* 168 */         this.propertyValues = new Object[length];
/*     */ 
/* 170 */         int i = 0;
/* 171 */         for (Iterator iterator = patternKPList.entrySet().iterator(); iterator.hasNext(); i++)
/*     */         {
/* 173 */           Map.Entry entry = (Map.Entry)iterator.next();
/* 174 */           this.propertyKeys[i] = entry.getKey();
/* 175 */           this.propertyValues[i] = entry.getValue();
/*     */         }
/*     */       }
/*     */       else {
/* 179 */         this.canonicalKeyPropertyString = pattern.getCanonicalKeyPropertyListString();
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean patternMatch(ObjectName name)
/*     */     {
/* 189 */       if (this.isPropertyPattern)
/*     */       {
/* 192 */         if (this.propertyKeys.length == 0) {
/* 193 */           return true;
/*     */         }
/* 195 */         Hashtable kplist = name.getKeyPropertyList();
/*     */ 
/* 197 */         for (int i = 0; i < this.propertyKeys.length; i++)
/*     */         {
/* 199 */           if (!this.propertyValues[i].equals(kplist.get(this.propertyKeys[i])))
/* 200 */             return false;
/*     */         }
/* 202 */         return true;
/*     */       }
/*     */ 
/* 205 */       return this.canonicalKeyPropertyString.equals(name.getCanonicalKeyPropertyListString());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.ObjectNamePatternHelper
 * JD-Core Version:    0.6.0
 */