/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import java.util.regex.PatternSyntaxException;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class ObjectNameMatch
/*     */ {
/*     */   public static boolean match(ObjectName n0, ObjectName n1)
/*     */   {
/*  46 */     boolean match = n0.equals(n1);
/*  47 */     if (match == true) {
/*  48 */       return true;
/*     */     }
/*     */ 
/*  51 */     String d0 = n0.getDomain();
/*  52 */     String d1 = n1.getDomain();
/*  53 */     int star0 = d0.indexOf('*');
/*  54 */     int star1 = d1.indexOf('*');
/*     */ 
/*  56 */     if (star0 >= 0)
/*     */     {
/*  58 */       if (star1 >= 0)
/*     */       {
/*  60 */         match = d0.equals(d1);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/*  66 */           Pattern domainRE = Pattern.compile(d0);
/*  67 */           Matcher m = domainRE.matcher(d1);
/*  68 */           match = m.matches();
/*     */         }
/*     */         catch (PatternSyntaxException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*  75 */     else if (star1 >= 0)
/*     */     {
/*  77 */       if (star0 >= 0)
/*     */       {
/*  79 */         match = d0.equals(d1);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/*  85 */           Pattern domainRE = Pattern.compile(d1);
/*  86 */           Matcher m = domainRE.matcher(d0);
/*  87 */           match = m.matches();
/*     */         }
/*     */         catch (PatternSyntaxException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  96 */       match = d0.equals(d1);
/*     */     }
/*     */ 
/*  99 */     if (!match) {
/* 100 */       return false;
/*     */     }
/*     */ 
/* 103 */     if (n0.isPropertyPattern())
/*     */     {
/* 105 */       Hashtable props0 = n0.getKeyPropertyList();
/* 106 */       Hashtable props1 = n1.getKeyPropertyList();
/* 107 */       Iterator iter = props0.keySet().iterator();
/* 108 */       while ((match == true) && (iter.hasNext()))
/*     */       {
/* 110 */         String key = (String)iter.next();
/* 111 */         String value = (String)props0.get(key);
/* 112 */         match &= value.equals(props1.get(key));
/*     */       }
/*     */     }
/* 115 */     else if (n1.isPropertyPattern())
/*     */     {
/* 117 */       Hashtable props0 = n0.getKeyPropertyList();
/* 118 */       Hashtable props1 = n1.getKeyPropertyList();
/* 119 */       Iterator iter = props1.keySet().iterator();
/* 120 */       while (iter.hasNext())
/*     */       {
/* 122 */         String key = (String)iter.next();
/* 123 */         String value = (String)props1.get(key);
/* 124 */         match &= value.equals(props0.get(key));
/*     */       }
/*     */     }
/*     */ 
/* 128 */     return match;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.ObjectNameMatch
 * JD-Core Version:    0.6.0
 */