/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ 
/*     */ public final class MetaDataUtil
/*     */ {
/*  40 */   public static final String BOOLEAN_TYPE_NAME = Boolean.TYPE.getName();
/*  41 */   public static final String BYTE_TYPE_NAME = Byte.TYPE.getName();
/*  42 */   public static final String CHAR_TYPE_NAME = Character.TYPE.getName();
/*  43 */   public static final String DOUBLE_TYPE_NAME = Double.TYPE.getName();
/*  44 */   public static final String FLOAT_TYPE_NAME = Float.TYPE.getName();
/*  45 */   public static final String INT_TYPE_NAME = Integer.TYPE.getName();
/*  46 */   public static final String LONG_TYPE_NAME = Long.TYPE.getName();
/*  47 */   public static final String SHORT_TYPE_NAME = Short.TYPE.getName();
/*  48 */   public static final String VOID_TYPE_NAME = Void.TYPE.getName();
/*     */ 
/*  50 */   private static final HashSet reserved = new HashSet();
/*     */ 
/*     */   public static final boolean isValidJavaIdentifier(String string)
/*     */   {
/* 119 */     if ((string == null) || (string.length() == 0)) {
/* 120 */       return false;
/*     */     }
/* 122 */     char[] chars = string.toCharArray();
/*     */ 
/* 125 */     if (!Character.isJavaIdentifierStart(chars[0])) {
/* 126 */       return false;
/*     */     }
/*     */ 
/* 129 */     for (int i = 1; i < chars.length; i++)
/*     */     {
/* 131 */       if (!Character.isJavaIdentifierPart(chars[i])) {
/* 132 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 136 */     return !reserved.contains(string);
/*     */   }
/*     */ 
/*     */   public static final boolean isValidJavaType(String string)
/*     */   {
/* 151 */     if ((string == null) || (string.length() == 0)) {
/* 152 */       return false;
/*     */     }
/*     */ 
/* 155 */     if (string.charAt(0) == '[')
/*     */     {
/* 157 */       String baseClassName = getBaseClassName(string);
/*     */ 
/* 159 */       if (baseClassName == null) {
/* 160 */         return false;
/*     */       }
/* 162 */       string = baseClassName;
/*     */     }
/*     */ 
/* 166 */     if (isPrimitive(string)) {
/* 167 */       return true;
/*     */     }
/* 169 */     char[] chars = string.toCharArray();
/*     */ 
/* 171 */     int start = 0;
/*     */ 
/* 173 */     for (int i = 0; i < chars.length; i++)
/*     */     {
/* 176 */       if (chars[i] != '.') {
/*     */         continue;
/*     */       }
/* 179 */       if (i == start) {
/* 180 */         return false;
/*     */       }
/*     */ 
/* 183 */       if (!isValidJavaIdentifier(string.substring(start, i))) {
/* 184 */         return false;
/*     */       }
/* 186 */       start = i + 1;
/*     */     }
/*     */ 
/* 193 */     return (start >= chars.length) || (isValidJavaIdentifier(string.substring(start, chars.length)));
/*     */   }
/*     */ 
/*     */   public static String getBaseClassName(String className)
/*     */   {
/* 212 */     int length = className.length();
/* 213 */     int last = length - 1;
/* 214 */     int i = 0;
/*     */ 
/* 217 */     while ((i < length) && (className.charAt(i) == '[')) {
/* 218 */       i++;
/*     */     }
/*     */ 
/* 221 */     if (i > 0)
/*     */     {
/* 224 */       char type = className.charAt(i);
/*     */ 
/* 226 */       if ((type == 'B') || (type == 'C') || (type == 'D') || (type == 'F') || (type == 'I') || (type == 'J') || (type == 'S') || (type == 'Z') || (type == 'V'))
/*     */       {
/* 229 */         if (i != last)
/* 230 */           return null;
/* 231 */         return className.substring(last, length);
/*     */       }
/*     */ 
/* 234 */       if ((className.charAt(i) != 'L') || (i >= last - 1) || (className.charAt(last) != ';'))
/*     */       {
/* 237 */         return null;
/*     */       }
/*     */ 
/* 240 */       return className.substring(i + 1, last);
/*     */     }
/*     */ 
/* 244 */     return className;
/*     */   }
/*     */ 
/*     */   public static boolean isPrimitive(String string)
/*     */   {
/* 255 */     if (string.equals(INT_TYPE_NAME))
/* 256 */       return true;
/* 257 */     if (string.equals(LONG_TYPE_NAME))
/* 258 */       return true;
/* 259 */     if (string.equals(BOOLEAN_TYPE_NAME))
/* 260 */       return true;
/* 261 */     if (string.equals(BYTE_TYPE_NAME))
/* 262 */       return true;
/* 263 */     if (string.equals(CHAR_TYPE_NAME))
/* 264 */       return true;
/* 265 */     if (string.equals(SHORT_TYPE_NAME))
/* 266 */       return true;
/* 267 */     if (string.equals(FLOAT_TYPE_NAME))
/* 268 */       return true;
/* 269 */     if (string.equals(DOUBLE_TYPE_NAME)) {
/* 270 */       return true;
/*     */     }
/* 272 */     return string.equals(VOID_TYPE_NAME);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  54 */     reserved.add("assert");
/*  55 */     reserved.add("abstract");
/*  56 */     reserved.add("boolean");
/*  57 */     reserved.add("break");
/*  58 */     reserved.add("byte");
/*  59 */     reserved.add("case");
/*  60 */     reserved.add("catch");
/*  61 */     reserved.add("char");
/*  62 */     reserved.add("class");
/*  63 */     reserved.add("const");
/*  64 */     reserved.add("continue");
/*  65 */     reserved.add("default");
/*  66 */     reserved.add("do");
/*  67 */     reserved.add("double");
/*  68 */     reserved.add("else");
/*  69 */     reserved.add("extends");
/*  70 */     reserved.add("false");
/*  71 */     reserved.add("final");
/*  72 */     reserved.add("finally");
/*  73 */     reserved.add("float");
/*  74 */     reserved.add("for");
/*  75 */     reserved.add("goto");
/*  76 */     reserved.add("if");
/*  77 */     reserved.add("implements");
/*  78 */     reserved.add("import");
/*  79 */     reserved.add("instanceof");
/*  80 */     reserved.add("int");
/*  81 */     reserved.add("interface");
/*  82 */     reserved.add("long");
/*  83 */     reserved.add("native");
/*  84 */     reserved.add("new");
/*  85 */     reserved.add("null");
/*  86 */     reserved.add("package");
/*  87 */     reserved.add("private");
/*  88 */     reserved.add("protected");
/*  89 */     reserved.add("public");
/*  90 */     reserved.add("return");
/*  91 */     reserved.add("short");
/*  92 */     reserved.add("static");
/*  93 */     reserved.add("strictfp");
/*  94 */     reserved.add("super");
/*  95 */     reserved.add("switch");
/*  96 */     reserved.add("synchronized");
/*  97 */     reserved.add("this");
/*  98 */     reserved.add("throw");
/*  99 */     reserved.add("throws");
/* 100 */     reserved.add("transient");
/* 101 */     reserved.add("true");
/* 102 */     reserved.add("try");
/* 103 */     reserved.add("void");
/* 104 */     reserved.add("volatile");
/* 105 */     reserved.add("while");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MetaDataUtil
 * JD-Core Version:    0.6.0
 */