/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ final class MBeanTyperInvoker
/*     */   implements InvocationHandler
/*     */ {
/*     */   private final MBeanServer server;
/*     */   private final ObjectName mbean;
/*  42 */   private final Map signatureCache = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   MBeanTyperInvoker(MBeanServer server, ObjectName mbean)
/*     */   {
/*  46 */     this.server = server;
/*  47 */     this.mbean = mbean;
/*     */   }
/*     */ 
/*     */   private boolean isJMXAttribute(Method m)
/*     */   {
/*  52 */     String name = m.getName();
/*  53 */     return name.startsWith("get");
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  60 */     if (MBeanTyper.DEBUG)
/*     */     {
/*  62 */       System.err.println("  ++ method=" + method.getName() + ",args=" + args);
/*     */     }
/*     */     try
/*     */     {
/*  66 */       if (method.getDeclaringClass() == Object.class)
/*     */       {
/*  68 */         String name = method.getName();
/*  69 */         if (name.equals("hashCode"))
/*     */         {
/*  71 */           return new Integer(hashCode());
/*     */         }
/*  73 */         if (name.equals("toString"))
/*     */         {
/*  75 */           return toString();
/*     */         }
/*  77 */         if (name.equals("equals"))
/*     */         {
/*  81 */           return new Boolean(equals(args[0]));
/*     */         }
/*     */       }
/*  84 */       else if ((isJMXAttribute(method)) && ((args == null) || (args.length <= 0)))
/*     */       {
/*  86 */         String name = method.getName().substring(3);
/*  87 */         return this.server.getAttribute(this.mbean, name);
/*     */       }
/*     */ 
/*  90 */       String[] sig = (String[])(String[])this.signatureCache.get(method);
/*  91 */       if (sig == null)
/*     */       {
/*  96 */         Class[] _args = method.getParameterTypes();
/*  97 */         if ((_args != null) && (_args.length > 0))
/*     */         {
/*  99 */           sig = new String[_args.length];
/* 100 */           for (int c = 0; c < sig.length; c++)
/*     */           {
/* 102 */             if (_args[c] == null)
/*     */               continue;
/* 104 */             sig[c] = _args[c].getName();
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 110 */           sig = new String[0];
/*     */         }
/* 112 */         this.signatureCache.put(method, sig);
/*     */       }
/* 114 */       return this.server.invoke(this.mbean, method.getName(), args, sig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 118 */       if (MBeanTyper.DEBUG)
/*     */       {
/* 120 */         t.printStackTrace();
/*     */       }
/* 122 */       if ((t instanceof UndeclaredThrowableException))
/*     */       {
/* 124 */         UndeclaredThrowableException ut = (UndeclaredThrowableException)t;
/* 125 */         throw ut.getUndeclaredThrowable();
/*     */       }
/* 127 */       if ((t instanceof InvocationTargetException))
/*     */       {
/* 129 */         InvocationTargetException it = (InvocationTargetException)t;
/* 130 */         throw it.getTargetException();
/*     */       }
/* 132 */       if ((t instanceof MBeanException))
/*     */       {
/* 134 */         MBeanException me = (MBeanException)t;
/* 135 */         throw me.getTargetException();
/*     */       }
/*     */     }
/*     */ 
/* 139 */     throw t;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MBeanTyperInvoker
 * JD-Core Version:    0.6.0
 */