/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ 
/*     */ public class MBeanServerLocator
/*     */ {
/*  46 */   private static MBeanServer instance = null;
/*     */ 
/*     */   public static void setJBoss(MBeanServer server)
/*     */   {
/*  65 */     synchronized (MBeanServerLocator.class)
/*     */     {
/*  67 */       instance = server;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static MBeanServer locate(String agentID)
/*     */   {
/*  79 */     MBeanServer server = (MBeanServer)MBeanServerFactory.findMBeanServer(agentID).iterator().next();
/*     */ 
/*  82 */     return server;
/*     */   }
/*     */ 
/*     */   public static MBeanServer locate()
/*     */   {
/*  92 */     return locate(null);
/*     */   }
/*     */ 
/*     */   public static MBeanServer locateJBoss()
/*     */   {
/* 107 */     synchronized (MBeanServerLocator.class)
/*     */     {
/* 109 */       if (instance != null)
/*     */       {
/* 111 */         return instance;
/*     */       }
/*     */     }
/* 114 */     for (Iterator i = MBeanServerFactory.findMBeanServer(null).iterator(); i.hasNext(); )
/*     */     {
/* 116 */       MBeanServer server = (MBeanServer)i.next();
/* 117 */       if (server.getDefaultDomain().equals("jboss"))
/*     */       {
/* 119 */         return server;
/*     */       }
/*     */     }
/* 122 */     throw new IllegalStateException("No 'jboss' MBeanServer found!");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MBeanServerLocator
 * JD-Core Version:    0.6.0
 */