/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.ArrayList;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InstanceAlreadyExistsException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanRegistrationException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ 
/*     */ public class MBeanProxy
/*     */ {
/*     */   public static Object get(Class intrface, ObjectName name, String agentID)
/*     */     throws MBeanProxyCreationException
/*     */   {
/*  62 */     return get(intrface, name, (MBeanServer)MBeanServerFactory.findMBeanServer(agentID).get(0));
/*     */   }
/*     */ 
/*     */   public static Object get(Class intrface, ObjectName name, MBeanServer server)
/*     */     throws MBeanProxyCreationException
/*     */   {
/*  78 */     return get(new Class[] { intrface, ProxyContext.class, DynamicMBean.class }, name, server);
/*     */   }
/*     */ 
/*     */   public static Object get(ObjectName name, MBeanServer server)
/*     */     throws MBeanProxyCreationException
/*     */   {
/*  85 */     return get(new Class[] { ProxyContext.class, DynamicMBean.class }, name, server);
/*     */   }
/*     */ 
/*     */   private static Object get(Class[] interfaces, ObjectName name, MBeanServer server) throws MBeanProxyCreationException
/*     */   {
/*  90 */     return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, new JMXInvocationHandler(server, name));
/*     */   }
/*     */ 
/*     */   public static Object create(Class instance, Class intrface, ObjectName name, String agentID)
/*     */     throws MBeanProxyCreationException
/*     */   {
/* 110 */     return create(instance, intrface, name, (MBeanServer)MBeanServerFactory.findMBeanServer(agentID).get(0));
/*     */   }
/*     */ 
/*     */   public static Object create(Class instance, Class intrface, ObjectName name, MBeanServer server)
/*     */     throws MBeanProxyCreationException
/*     */   {
/*     */     try
/*     */     {
/* 127 */       server.createMBean(instance.getName(), name);
/* 128 */       return get(intrface, name, server);
/*     */     }
/*     */     catch (ReflectionException e) {
/* 131 */       throw new MBeanProxyCreationException("Creating the MBean failed: " + e.toString());
/*     */     }
/*     */     catch (InstanceAlreadyExistsException e) {
/* 134 */       throw new MBeanProxyCreationException("Instance already exists: " + name);
/*     */     }
/*     */     catch (MBeanRegistrationException e) {
/* 137 */       throw new MBeanProxyCreationException("Error registering the MBean to the server: " + e.toString());
/*     */     }
/*     */     catch (MBeanException e) {
/* 140 */       throw new MBeanProxyCreationException(e.toString());
/*     */     } catch (NotCompliantMBeanException e) {
/*     */     }
/* 143 */     throw new MBeanProxyCreationException("Not a compliant MBean " + instance.getClass().getName() + ": " + e.toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MBeanProxy
 * JD-Core Version:    0.6.0
 */