/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.InputStream;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.loading.ClassLoaderRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.MBeanElement;
/*     */ import org.jboss.mx.server.ObjectInputStreamWithClassLoader;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class MBeanInstaller
/*     */ {
/*     */   public static final String VERSIONS = "versions";
/*     */   public static final String DATE = "date";
/* 112 */   private static final Logger log = Logger.getLogger(MBeanInstaller.class);
/*     */   private MBeanServer server;
/*     */   private ClassLoader ctxClassLoader;
/*     */   private ObjectName loaderName;
/*     */   private ObjectName registryName;
/*     */ 
/*     */   public MBeanInstaller(MBeanServer server, ClassLoader ctxClassLoader, ObjectName loaderName)
/*     */     throws Exception
/*     */   {
/* 174 */     this.server = server;
/* 175 */     this.ctxClassLoader = ctxClassLoader;
/* 176 */     this.loaderName = loaderName;
/* 177 */     this.registryName = new ObjectName("JMImplementation:type=MBeanRegistry");
/*     */   }
/*     */ 
/*     */   public ObjectInstance installMBean(MBeanElement element)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException
/*     */   {
/* 196 */     log.debug("Installing MBean: " + element);
/*     */ 
/* 198 */     ObjectInstance instance = null;
/* 199 */     ObjectName elementName = getElementName(element);
/*     */ 
/* 201 */     if ((element.getVersions().isEmpty()) || (!this.server.isRegistered(elementName)))
/*     */     {
/* 203 */       if (element.getCode() != null)
/* 204 */         instance = createMBean(element);
/* 205 */       else if (element.getObject() != null)
/* 206 */         instance = deserialize(element);
/*     */       else
/* 208 */         throw new MBeanException(new IllegalArgumentException("No code or object tag"));
/*     */     }
/*     */     else {
/* 211 */       instance = updateMBean(element);
/*     */     }
/* 213 */     return instance;
/*     */   }
/*     */ 
/*     */   public ObjectInstance createMBean(MBeanElement element)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException
/*     */   {
/* 222 */     log.debug("Creating MBean.. ");
/*     */ 
/* 224 */     ObjectName elementName = getElementName(element);
/*     */ 
/* 228 */     Map valueMap = createValueMap(element);
/*     */ 
/* 236 */     String[] classes = element.getConstructorTypes();
/* 237 */     String[] paramStrings = element.getConstructorValues();
/* 238 */     Object[] params = new Object[paramStrings.length];
/* 239 */     for (int i = 0; i < paramStrings.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 243 */         Class typeClass = this.server.getClassLoaderRepository().loadClass(classes[i]);
/* 244 */         PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 245 */         if (editor == null) {
/* 246 */           throw new IllegalArgumentException("No property editor for type=" + typeClass);
/*     */         }
/* 248 */         editor.setAsText(paramStrings[i]);
/* 249 */         params[i] = editor.getValue();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 253 */         throw new MBeanException(e);
/*     */       }
/*     */     }
/* 256 */     Object instance = this.server.instantiate(element.getCode(), this.loaderName, params, classes);
/*     */ 
/* 264 */     return registerMBean(instance, elementName, valueMap);
/*     */   }
/*     */ 
/*     */   public ObjectInstance deserialize(MBeanElement element)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException
/*     */   {
/* 272 */     InputStream is = null;
/* 273 */     Object instance = null;
/*     */     try
/*     */     {
/* 276 */       is = this.ctxClassLoader.getResourceAsStream(element.getObject());
/* 277 */       if (is == null)
/* 278 */         throw new IllegalArgumentException("Object not found " + element.getObject());
/* 279 */       ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(is, this.ctxClassLoader);
/* 280 */       instance = ois.readObject();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 284 */       throw new MBeanException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 288 */       if (is != null)
/*     */       {
/*     */         try
/*     */         {
/* 292 */           is.close();
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/* 299 */     ObjectName elementName = getElementName(element);
/*     */ 
/* 303 */     Map valueMap = createValueMap(element);
/* 304 */     return registerMBean(instance, elementName, valueMap);
/*     */   }
/*     */ 
/*     */   public ObjectInstance updateMBean(MBeanElement element)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException
/*     */   {
/* 313 */     log.debug("updating MBean... ");
/*     */ 
/* 315 */     ObjectName elementName = getElementName(element);
/*     */ 
/* 318 */     MLetVersion preVersion = new MLetVersion(getVersions(elementName));
/* 319 */     MLetVersion newVersion = new MLetVersion(element.getVersions());
/*     */ 
/* 321 */     log.debug("Installed version : " + preVersion);
/* 322 */     log.debug("Loaded version    : " + newVersion);
/*     */ 
/* 326 */     if ((!preVersion.isNull()) && (!newVersion.isNull()) && (preVersion.compareTo(newVersion) < 0))
/*     */     {
/* 329 */       if (this.server.isRegistered(elementName))
/*     */       {
/* 331 */         unregisterMBean(elementName);
/*     */ 
/* 333 */         log.debug("Unregistering previous version " + preVersion);
/*     */       }
/*     */ 
/* 336 */       log.debug("Installing newer version " + newVersion);
/*     */ 
/* 339 */       return createMBean(element);
/*     */     }
/*     */ 
/* 342 */     return this.server.getObjectInstance(elementName);
/*     */   }
/*     */ 
/*     */   private ObjectName getElementName(MBeanElement element)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 351 */     return element.getName() != null ? new ObjectName(element.getName()) : null;
/*     */   }
/*     */ 
/*     */   private Map createValueMap(MBeanElement element)
/*     */   {
/* 356 */     HashMap valueMap = new HashMap();
/*     */ 
/* 360 */     if ((element.getVersions() != null) && (!element.getVersions().isEmpty())) {
/* 361 */       valueMap.put("versions", element.getVersions());
/*     */     }
/*     */ 
/* 364 */     valueMap.put("date", new Date(System.currentTimeMillis()));
/*     */ 
/* 367 */     valueMap.put("org.jboss.mx.classloader", this.ctxClassLoader);
/*     */ 
/* 369 */     return valueMap;
/*     */   }
/*     */ 
/*     */   private List getVersions(ObjectName name)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException
/*     */   {
/* 375 */     if (!this.server.isRegistered(name)) {
/* 376 */       return null;
/*     */     }
/* 378 */     return (List)getValue(name, "versions");
/*     */   }
/*     */ 
/*     */   private Object getValue(ObjectName name, String key)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException
/*     */   {
/* 385 */     Object value = this.server.invoke(this.registryName, "getValue", new Object[] { name, key }, new String[] { ObjectName.class.getName(), String.class.getName() });
/*     */ 
/* 399 */     return value;
/*     */   }
/*     */ 
/*     */   private ObjectInstance registerMBean(Object object, ObjectName name, Map valueMap)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException
/*     */   {
/* 405 */     if (object == null)
/*     */     {
/* 407 */       throw new ReflectionException(new IllegalArgumentException("Attempting to register a null object"));
/*     */     }
/*     */ 
/* 412 */     return (ObjectInstance)this.server.invoke(this.registryName, "registerMBean", new Object[] { object, name, valueMap }, new String[] { Object.class.getName(), ObjectName.class.getName(), Map.class.getName() });
/*     */   }
/*     */ 
/*     */   private void unregisterMBean(ObjectName name)
/*     */     throws MBeanException, ReflectionException, InstanceNotFoundException
/*     */   {
/* 432 */     this.server.invoke(this.registryName, "unregisterMBean", new Object[] { name }, new String[] { ObjectName.class.getName() });
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 120 */     Class c = PropertyEditors.class;
/* 121 */     if (c == null)
/* 122 */       throw new UnreachableStatementException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.MBeanInstaller
 * JD-Core Version:    0.6.0
 */