/*    */ package org.jboss.mx.util;
/*    */ 
/*    */ import javax.management.JMException;
/*    */ import javax.management.JMRuntimeException;
/*    */ import javax.management.MBeanException;
/*    */ import javax.management.ReflectionException;
/*    */ import javax.management.RuntimeErrorException;
/*    */ import javax.management.RuntimeMBeanException;
/*    */ import javax.management.RuntimeOperationsException;
/*    */ 
/*    */ public class JMXExceptionDecoder
/*    */ {
/*    */   public static Throwable decode(Throwable t)
/*    */   {
/* 42 */     Throwable result = t;
/*    */     while (true)
/*    */     {
/* 46 */       if ((result instanceof MBeanException)) {
/* 47 */         result = ((MBeanException)result).getTargetException(); continue;
/* 48 */       }if ((result instanceof ReflectionException)) {
/* 49 */         result = ((ReflectionException)result).getTargetException(); continue;
/* 50 */       }if ((result instanceof RuntimeOperationsException)) {
/* 51 */         result = ((RuntimeOperationsException)result).getTargetException(); continue;
/* 52 */       }if ((result instanceof RuntimeMBeanException)) {
/* 53 */         result = ((RuntimeMBeanException)result).getTargetException(); continue;
/* 54 */       }if (!(result instanceof RuntimeErrorException)) break;
/* 55 */       result = ((RuntimeErrorException)result).getTargetError();
/*    */     }
/*    */ 
/* 61 */     return result;
/*    */   }
/*    */ 
/*    */   public static Throwable decodeToJMXException(Throwable ex)
/*    */   {
/* 73 */     Throwable jmxEx = ex;
/* 74 */     Throwable lastJmxEx = ex;
/* 75 */     while (((jmxEx instanceof JMException)) || ((jmxEx instanceof JMRuntimeException)))
/*    */     {
/* 77 */       lastJmxEx = jmxEx;
/* 78 */       jmxEx = decode(jmxEx);
/* 79 */       if (jmxEx == lastJmxEx) {
/* 80 */         break;
/*    */       }
/*    */     }
/* 83 */     return lastJmxEx;
/*    */   }
/*    */ 
/*    */   public static void rethrow(Exception e)
/*    */     throws Exception
/*    */   {
/* 94 */     Throwable t = decode(e);
/* 95 */     if ((t instanceof Exception)) {
/* 96 */       throw ((Exception)t);
/*    */     }
/* 98 */     throw ((Error)t);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.JMXExceptionDecoder
 * JD-Core Version:    0.6.0
 */