/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationFilter;
/*     */ import org.jboss.util.collection.CollectionsFactory;
/*     */ 
/*     */ public class JBossNotificationFilterSupport
/*     */   implements NotificationFilter, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 6442164418782871672L;
/*     */   private List enabledTypes;
/*     */ 
/*     */   public JBossNotificationFilterSupport()
/*     */   {
/*  79 */     this.enabledTypes = CollectionsFactory.createCopyOnWriteList();
/*     */   }
/*     */ 
/*     */   public void disableAllTypes()
/*     */   {
/*  89 */     synchronized (this)
/*     */     {
/*  91 */       this.enabledTypes.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void disableType(String type)
/*     */   {
/* 102 */     synchronized (this)
/*     */     {
/* 105 */       this.enabledTypes.remove(type);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void enableType(String type)
/*     */     throws IllegalArgumentException
/*     */   {
/* 117 */     if (type == null)
/*     */     {
/* 119 */       throw new IllegalArgumentException("null notification type");
/*     */     }
/* 121 */     synchronized (this)
/*     */     {
/* 123 */       if (!this.enabledTypes.contains(type))
/*     */       {
/* 125 */         this.enabledTypes.add(type);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Vector getEnabledTypes()
/*     */   {
/* 140 */     return new Vector(this.enabledTypes);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 148 */     StringBuffer sb = new StringBuffer(100);
/*     */ 
/* 150 */     sb.append(getClass().getName()).append(':');
/* 151 */     sb.append(" enabledTypes=").append(getEnabledTypes());
/*     */ 
/* 153 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public boolean isNotificationEnabled(Notification notification)
/*     */   {
/* 167 */     if (notification == null)
/*     */     {
/* 169 */       throw new IllegalArgumentException("null notification");
/*     */     }
/*     */ 
/* 172 */     String notificationType = notification.getType();
/* 173 */     for (Iterator i = this.enabledTypes.iterator(); i.hasNext(); )
/*     */     {
/* 175 */       String type = (String)i.next();
/* 176 */       if (notificationType.startsWith(type))
/*     */       {
/* 178 */         return true;
/*     */       }
/*     */     }
/* 181 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.JBossNotificationFilterSupport
 * JD-Core Version:    0.6.0
 */