/*    */ package org.jboss.mx.util;
/*    */ 
/*    */ import javax.management.BadAttributeValueExpException;
/*    */ import javax.management.BadBinaryOpValueExpException;
/*    */ import javax.management.BadStringOperationException;
/*    */ import javax.management.InstanceNotFoundException;
/*    */ import javax.management.InvalidApplicationException;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import javax.management.QueryExp;
/*    */ 
/*    */ public class InstanceOfQueryExp
/*    */   implements QueryExp
/*    */ {
/*    */   private static final long serialVersionUID = -1L;
/*    */   MBeanServer server;
/*    */   String classname;
/*    */ 
/*    */   public InstanceOfQueryExp(String classname)
/*    */   {
/* 48 */     this.classname = classname;
/*    */   }
/*    */ 
/*    */   public boolean apply(ObjectName name)
/*    */     throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException
/*    */   {
/*    */     try
/*    */     {
/* 59 */       return this.server.isInstanceOf(name, this.classname);
/*    */     }
/*    */     catch (InstanceNotFoundException e) {
/*    */     }
/* 63 */     throw new InvalidApplicationException(name);
/*    */   }
/*    */ 
/*    */   public void setMBeanServer(MBeanServer server)
/*    */   {
/* 69 */     this.server = server;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.InstanceOfQueryExp
 * JD-Core Version:    0.6.0
 */