/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.rmi.dgc.VMID;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.Random;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.server.ServerConstants;
/*     */ 
/*     */ public class AgentID
/*     */   implements ServerConstants
/*     */ {
/*  52 */   private static SynchronizedLong id = new SynchronizedLong(0L);
/*     */ 
/*  54 */   private static final Random rand = new Random(System.currentTimeMillis());
/*     */ 
/*     */   public static String create()
/*     */   {
/*  66 */     String ipAddress = null;
/*     */     try
/*     */     {
/*  70 */       ipAddress = (String)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run()
/*     */           throws Exception
/*     */         {
/*  75 */           return InetAddress.getLocalHost().getHostAddress();
/*     */         }
/*     */       });
/*     */     }
/*     */     catch (PrivilegedActionException e)
/*     */     {
/*  82 */       ipAddress = "127.0.0.1";
/*     */     }
/*     */ 
/*  86 */     String vmid = new VMID().toString().replace(':', 'x').replace('-', 'X') + rand.nextInt(100);
/*     */ 
/*  88 */     return ipAddress + "/" + System.currentTimeMillis() + "/" + vmid + "/" + id.increment();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  97 */     for (int c = 0; c < 10; c++)
/*  98 */       System.out.println(create());
/*     */   }
/*     */ 
/*     */   public static String get(MBeanServer server)
/*     */   {
/*     */     try
/*     */     {
/* 110 */       ObjectName name = new ObjectName("JMImplementation:type=MBeanServerDelegate");
/* 111 */       String agentID = (String)server.getAttribute(name, "MBeanServerId");
/*     */ 
/* 113 */       return agentID;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 117 */     throw new Error("Cannot find the MBean server delegate: " + t.toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.AgentID
 * JD-Core Version:    0.6.0
 */