/*     */ package org.jboss.mx.timer;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotificationBroadcasterSupport;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.timer.TimerNotification;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.RunnableScheduler;
/*     */ import org.jboss.mx.util.SchedulableRunnable;
/*     */ 
/*     */ public class JBossTimer extends NotificationBroadcasterSupport
/*     */   implements JBossTimerMBean, MBeanRegistration
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(JBossTimer.class);
/*     */   public static final long ONE_SECOND = 1000L;
/*     */   public static final long ONE_MINUTE = 60000L;
/*     */   public static final long ONE_HOUR = 3600000L;
/*     */   public static final long ONE_DAY = 86400000L;
/*     */   public static final long ONE_WEEK = 604800000L;
/*     */   private static final int SEND_NO = 0;
/*     */   private static final int SEND_START = 1;
/*     */   private static final int SEND_NORMAL = 2;
/*     */   int nextId;
/*     */   long sequenceNumber;
/*     */   boolean sendPastNotifications;
/*     */   boolean active;
/*     */   ObjectName objectName;
/*     */   HashMap notifications;
/*     */   private RunnableScheduler scheduler;
/*     */ 
/*     */   public JBossTimer()
/*     */   {
/*  98 */     this.nextId = 0;
/*     */ 
/* 101 */     this.sequenceNumber = 0L;
/*     */ 
/* 104 */     this.sendPastNotifications = false;
/*     */ 
/* 107 */     this.active = false;
/*     */ 
/* 113 */     this.notifications = new HashMap();
/*     */ 
/* 116 */     this.scheduler = new RunnableScheduler();
/*     */   }
/*     */ 
/*     */   public Integer addNotification(String type, String message, Object userData, Date date)
/*     */     throws IllegalArgumentException
/*     */   {
/* 129 */     return addNotification(type, message, userData, date, 0L);
/*     */   }
/*     */ 
/*     */   public Integer addNotification(String type, String message, Object userData, Date date, long period)
/*     */     throws IllegalArgumentException
/*     */   {
/* 135 */     return addNotification(type, message, userData, date, period, 0L);
/*     */   }
/*     */ 
/*     */   public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurences)
/*     */     throws IllegalArgumentException
/*     */   {
/* 141 */     return addNotification(type, message, userData, date, period, occurences, false);
/*     */   }
/*     */ 
/*     */   public Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate)
/*     */     throws IllegalArgumentException
/*     */   {
/* 169 */     int newId = 0;
/* 170 */     newId = ++this.nextId;
/* 171 */     Integer id = new Integer(newId);
/*     */ 
/* 174 */     RegisteredNotification rn = new RegisteredNotification(id, type, message, userData, date, period, nbOccurences, fixedRate);
/*     */ 
/* 178 */     synchronized (this.notifications)
/*     */     {
/* 180 */       this.notifications.put(id, rn);
/* 181 */       rn.setNextRun(rn.nextDate);
/* 182 */       rn.setScheduler(this.scheduler);
/*     */     }
/*     */ 
/* 185 */     return id;
/*     */   }
/*     */ 
/*     */   public Vector getAllNotificationIDs()
/*     */   {
/* 190 */     synchronized (this.notifications)
/*     */     {
/* 192 */       return new Vector(this.notifications.keySet());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Date getDate(Integer id)
/*     */   {
/* 199 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 200 */     if (rn == null) {
/* 201 */       return null;
/*     */     }
/*     */ 
/* 204 */     return new Date(rn.startDate);
/*     */   }
/*     */ 
/*     */   public int getNbNotifications()
/*     */   {
/* 209 */     return this.notifications.size();
/*     */   }
/*     */ 
/*     */   public Long getNbOccurences(Integer id)
/*     */   {
/* 215 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 216 */     if (rn == null) {
/* 217 */       return null;
/*     */     }
/*     */ 
/* 220 */     return new Long(rn.occurences);
/*     */   }
/*     */ 
/*     */   public Boolean getFixedRate(Integer id)
/*     */   {
/* 232 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 233 */     if (rn == null) {
/* 234 */       return null;
/*     */     }
/*     */ 
/* 237 */     return new Boolean(rn.fixedRate);
/*     */   }
/*     */ 
/*     */   public Vector getNotificationIDs(String type)
/*     */   {
/* 242 */     Vector result = new Vector();
/*     */ 
/* 245 */     synchronized (this.notifications)
/*     */     {
/* 247 */       Iterator iterator = this.notifications.values().iterator();
/* 248 */       while (iterator.hasNext())
/*     */       {
/* 250 */         RegisteredNotification rn = (RegisteredNotification)iterator.next();
/* 251 */         if (rn.type.equals(type)) {
/* 252 */           result.add(rn.id);
/*     */         }
/*     */       }
/*     */     }
/* 256 */     return result;
/*     */   }
/*     */ 
/*     */   public String getNotificationMessage(Integer id)
/*     */   {
/* 262 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 263 */     if (rn == null) {
/* 264 */       return null;
/*     */     }
/*     */ 
/* 267 */     return rn.message;
/*     */   }
/*     */ 
/*     */   public String getNotificationType(Integer id)
/*     */   {
/* 273 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 274 */     if (rn == null) {
/* 275 */       return null;
/*     */     }
/*     */ 
/* 278 */     return rn.type;
/*     */   }
/*     */ 
/*     */   public Object getNotificationUserData(Integer id)
/*     */   {
/* 284 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 285 */     if (rn == null) {
/* 286 */       return null;
/*     */     }
/*     */ 
/* 289 */     return rn.userData;
/*     */   }
/*     */ 
/*     */   public Long getPeriod(Integer id)
/*     */   {
/* 295 */     RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 296 */     if (rn == null) {
/* 297 */       return null;
/*     */     }
/*     */ 
/* 300 */     return new Long(rn.period);
/*     */   }
/*     */ 
/*     */   public boolean getSendPastNotifications()
/*     */   {
/* 305 */     return this.sendPastNotifications;
/*     */   }
/*     */ 
/*     */   public boolean isActive()
/*     */   {
/* 310 */     return this.active;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 315 */     return this.notifications.isEmpty();
/*     */   }
/*     */ 
/*     */   public void removeAllNotifications()
/*     */   {
/* 321 */     synchronized (this.notifications)
/*     */     {
/* 323 */       Iterator iterator = this.notifications.values().iterator();
/* 324 */       while (iterator.hasNext())
/*     */       {
/* 326 */         RegisteredNotification rn = (RegisteredNotification)iterator.next();
/* 327 */         rn.setScheduler(null);
/* 328 */         iterator.remove();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 333 */     synchronized (this)
/*     */     {
/* 335 */       this.nextId = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeNotification(Integer id)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 343 */     log.debug("removeNotification: " + this.objectName + ",id=" + id);
/*     */ 
/* 346 */     synchronized (this.notifications)
/*     */     {
/* 348 */       RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
/* 349 */       if (rn == null) {
/* 350 */         throw new InstanceNotFoundException("No notification id : " + id.toString());
/*     */       }
/*     */ 
/* 354 */       rn.setScheduler(null);
/* 355 */       this.notifications.remove(id);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeNotifications(String type)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 362 */     boolean found = false;
/*     */ 
/* 364 */     log.debug("removeNotifications: " + this.objectName + ",type=" + type);
/*     */ 
/* 367 */     synchronized (this.notifications)
/*     */     {
/* 369 */       Iterator iterator = this.notifications.values().iterator();
/* 370 */       while (iterator.hasNext())
/*     */       {
/* 372 */         RegisteredNotification rn = (RegisteredNotification)iterator.next();
/* 373 */         if (rn.type.equals(type))
/*     */         {
/* 375 */           rn.setScheduler(null);
/* 376 */           iterator.remove();
/* 377 */           found = true;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 383 */     if (!found)
/* 384 */       throw new InstanceNotFoundException("Nothing registered for type: " + type);
/*     */   }
/*     */ 
/*     */   public void setSendPastNotifications(boolean value)
/*     */   {
/* 390 */     log.debug("setSendPastNotifications: " + this.objectName + ",value=" + value);
/* 391 */     this.sendPastNotifications = value;
/*     */   }
/*     */ 
/*     */   public synchronized void start()
/*     */   {
/* 397 */     if (this.active == true)
/* 398 */       return;
/* 399 */     this.active = true;
/*     */ 
/* 401 */     log.debug("start: " + this.objectName + " at " + new Date());
/*     */ 
/* 405 */     synchronized (this.notifications)
/*     */     {
/* 407 */       Iterator iterator = this.notifications.values().iterator();
/* 408 */       while (iterator.hasNext())
/*     */       {
/* 410 */         RegisteredNotification rn = (RegisteredNotification)iterator.next();
/* 411 */         if (this.sendPastNotifications)
/* 412 */           rn.sendType = 1;
/*     */         else
/* 414 */           rn.sendType = 0;
/* 415 */         sendNotifications(rn);
/* 416 */         rn.sendType = 2;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 421 */     this.scheduler.start();
/*     */   }
/*     */ 
/*     */   public synchronized void stop()
/*     */   {
/* 427 */     if (!this.active) {
/* 428 */       return;
/*     */     }
/* 430 */     log.debug("stop: " + this.objectName + ",now=" + new Date());
/*     */ 
/* 433 */     this.active = false;
/* 434 */     this.scheduler.stop();
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName objectName)
/*     */     throws Exception
/*     */   {
/* 443 */     this.objectName = objectName;
/*     */ 
/* 446 */     return objectName;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void preDeregister()
/*     */     throws Exception
/*     */   {
/* 457 */     stop();
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void sendNotifications(RegisteredNotification rn)
/*     */   {
/* 484 */     while ((isActive()) && (rn.nextDate != 0L) && (rn.nextDate <= System.currentTimeMillis()))
/*     */     {
/* 488 */       if (rn.sendType != 0)
/*     */       {
/* 490 */         long seq = 0L;
/* 491 */         synchronized (this)
/*     */         {
/* 493 */           seq = ++this.sequenceNumber;
/*     */         }
/*     */ 
/* 496 */         log.debug("sendNotification: " + rn);
/* 497 */         TimerNotification tn = new TimerNotification(rn.type, this.objectName, seq, rn.nextDate, rn.message, rn.id);
/*     */ 
/* 499 */         tn.setUserData(rn.userData);
/* 500 */         sendNotification(tn);
/*     */       }
/*     */ 
/*     */       do
/*     */       {
/* 508 */         if (!rn.calcNextDate())
/*     */         {
/* 510 */           synchronized (this.notifications)
/*     */           {
/* 512 */             log.debug("remove: " + rn);
/* 513 */             this.notifications.remove(rn.id);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 518 */         if ((!isActive()) || (rn.sendType == 1) || (rn.nextDate == 0L) || (rn.occurences != 0L)) break; 
/* 518 */       }while (rn.nextDate < System.currentTimeMillis());
/*     */     }
/*     */ 
/* 521 */     if (rn.nextDate != 0L)
/* 522 */       rn.setNextRun(rn.nextDate);
/*     */   }
/*     */ 
/*     */   private class RegisteredNotification extends SchedulableRunnable
/*     */   {
/*     */     public Integer id;
/*     */     public String type;
/*     */     public String message;
/*     */     public Object userData;
/*     */     public long startDate;
/*     */     public long period;
/*     */     public long occurences;
/*     */     public boolean fixedRate;
/* 559 */     public int sendType = 2;
/*     */ 
/* 562 */     public long nextDate = 0L;
/*     */ 
/*     */     public RegisteredNotification(Integer id, String type, String message, Object userData, Date startDate, long period, long occurences, boolean fixedRate)
/*     */       throws IllegalArgumentException
/*     */     {
/* 592 */       if (startDate == null)
/* 593 */         throw new IllegalArgumentException("Null Date");
/* 594 */       if (period < 0L)
/* 595 */         throw new IllegalArgumentException("Negative Period");
/* 596 */       if (occurences < 0L) {
/* 597 */         throw new IllegalArgumentException("Negative Occurences");
/*     */       }
/* 599 */       this.startDate = startDate.getTime();
/* 600 */       if (startDate.getTime() < System.currentTimeMillis())
/*     */       {
/* 602 */         JBossTimer.log.debug("startDate [" + startDate + "] in the past, set to now");
/* 603 */         this.startDate = System.currentTimeMillis();
/*     */       }
/*     */ 
/* 607 */       this.id = id;
/* 608 */       this.type = type;
/* 609 */       this.message = message;
/* 610 */       this.userData = userData;
/* 611 */       this.period = period;
/* 612 */       this.occurences = occurences;
/* 613 */       this.fixedRate = fixedRate;
/*     */ 
/* 615 */       this.nextDate = this.startDate;
/*     */ 
/* 617 */       String msgStr = "new " + toString();
/* 618 */       JBossTimer.log.debug(msgStr);
/*     */     }
/*     */ 
/*     */     boolean calcNextDate()
/*     */     {
/* 632 */       if (this.period == 0L)
/*     */       {
/* 634 */         this.nextDate = 0L;
/* 635 */         return false;
/*     */       }
/*     */ 
/* 639 */       if ((this.occurences != 0L) && (--this.occurences == 0L))
/*     */       {
/* 641 */         this.nextDate = 0L;
/* 642 */         return false;
/*     */       }
/*     */ 
/* 646 */       if (this.fixedRate)
/* 647 */         this.nextDate += this.period;
/*     */       else {
/* 649 */         this.nextDate = (System.currentTimeMillis() + this.period);
/*     */       }
/* 651 */       return true;
/*     */     }
/*     */ 
/*     */     public void doRun()
/*     */     {
/* 662 */       JBossTimer.this.sendNotifications(this);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 667 */       return " RegisteredNotification: [timer=" + JBossTimer.this.objectName + ",id=" + this.id + ",startDate=" + new Date(this.startDate) + ",period=" + this.period + ",occurences=" + this.occurences + ",fixedRate=" + this.fixedRate + ",nextDate=" + new Date(this.nextDate) + "]";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.timer.JBossTimer
 * JD-Core Version:    0.6.0
 */