/*     */ package org.jboss.mx.server.registry;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ import org.jboss.mx.server.ServerConstants;
/*     */ 
/*     */ public class MBeanEntry
/*     */   implements ServerConstants
/*     */ {
/*  48 */   private ObjectName objectName = null;
/*     */ 
/*  53 */   private String resourceClassName = null;
/*     */ 
/*  58 */   private MBeanInvoker invoker = null;
/*     */ 
/*  63 */   private Object resource = null;
/*     */ 
/*  68 */   private ClassLoader cl = null;
/*     */ 
/*  73 */   private Map valueMap = null;
/*     */ 
/*     */   public MBeanEntry(ObjectName objectName, MBeanInvoker invoker, Object resource, Map valueMap)
/*     */   {
/*  88 */     this.objectName = objectName;
/*  89 */     this.invoker = invoker;
/*  90 */     this.resourceClassName = resource.getClass().getName();
/*  91 */     this.resource = resource;
/*  92 */     this.valueMap = valueMap;
/*     */ 
/*  95 */     if (valueMap != null)
/*  96 */       this.cl = ((ClassLoader)valueMap.get("org.jboss.mx.classloader"));
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 108 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   protected void setObjectName(ObjectName objectName)
/*     */   {
/* 119 */     this.objectName = objectName;
/*     */   }
/*     */ 
/*     */   public MBeanInvoker getInvoker()
/*     */   {
/* 129 */     return this.invoker;
/*     */   }
/*     */ 
/*     */   public String getResourceClassName()
/*     */   {
/* 139 */     return this.resourceClassName;
/*     */   }
/*     */ 
/*     */   public void setResourceClassName(String resourceClassName)
/*     */   {
/* 149 */     this.resourceClassName = resourceClassName;
/*     */   }
/*     */ 
/*     */   public Object getResourceInstance()
/*     */   {
/* 159 */     return this.resource;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 169 */     return this.cl;
/*     */   }
/*     */ 
/*     */   public Object getValue(String key)
/*     */   {
/* 180 */     if (this.valueMap != null)
/* 181 */       return this.valueMap.get(key);
/* 182 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.registry.MBeanEntry
 * JD-Core Version:    0.6.0
 */