/*     */ package org.jboss.mx.server.registry;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.Vector;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InstanceAlreadyExistsException;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanRegistrationException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerDelegate;
/*     */ import javax.management.MBeanServerNotification;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import javax.management.loading.ClassLoaderRepository;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.RequiredModelMBean;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepository;
/*     */ import org.jboss.mx.metadata.MBeanCapability;
/*     */ import org.jboss.mx.modelmbean.RequiredModelMBeanInvoker;
/*     */ import org.jboss.mx.modelmbean.XMBean;
/*     */ import org.jboss.mx.server.AbstractMBeanInvoker;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ import org.jboss.mx.server.RawDynamicInvoker;
/*     */ import org.jboss.mx.server.ServerConfig;
/*     */ import org.jboss.mx.server.ServerObjectInstance;
/*     */ import org.jboss.mx.util.ObjectNamePatternHelper;
/*     */ import org.jboss.mx.util.ObjectNamePatternHelper.PropertyPattern;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class BasicMBeanRegistry
/*     */   implements MBeanRegistry
/*     */ {
/*  98 */   private static ServerConfig serverConfig = ServerConfig.getInstance();
/*     */ 
/* 101 */   private static String JMI_DOMAIN = serverConfig.getJMIDomain();
/*     */ 
/* 110 */   private Map domainMap = new ConcurrentReaderHashMap();
/*     */   private String defaultDomain;
/*     */   private MBeanServer server;
/*     */   private LoaderRepository loaderRepository;
/* 130 */   protected final SynchronizedLong registrationNotificationSequence = new SynchronizedLong(1L);
/*     */ 
/* 135 */   protected final SynchronizedLong unregistrationNotificationSequence = new SynchronizedLong(1L);
/*     */   protected MBeanServerDelegate delegate;
/*     */   protected Vector fMbInfosToStore;
/*     */   private ObjectName mbeanInfoService;
/* 151 */   protected static Logger log = Logger.getLogger(BasicMBeanRegistry.class);
/*     */ 
/*     */   public BasicMBeanRegistry(MBeanServer server, String defaultDomain, ClassLoaderRepository clr)
/*     */   {
/* 162 */     this.server = server;
/* 163 */     this.defaultDomain = defaultDomain;
/*     */     try
/*     */     {
/* 167 */       this.loaderRepository = ((LoaderRepository)clr);
/* 168 */       this.mbeanInfoService = new ObjectName("user:service=MBeanInfoDB");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 172 */       throw new NestedRuntimeException("Error instantiating registry", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ObjectInstance registerMBean(Object object, ObjectName name, Map valueMap)
/*     */     throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException
/*     */   {
/* 182 */     ObjectName regName = name;
/* 183 */     boolean registrationDone = true;
/* 184 */     boolean invokedPreRegister = false;
/* 185 */     String magicToken = null;
/* 186 */     MBeanInvoker invoker = null;
/*     */ 
/* 188 */     if (object == null) {
/* 189 */       throw new RuntimeOperationsException(new IllegalArgumentException("Attempting to register null object"));
/*     */     }
/*     */ 
/* 193 */     MBeanCapability mbcap = MBeanCapability.of(object.getClass());
/*     */     try
/*     */     {
/* 198 */       if (valueMap != null) {
/* 199 */         magicToken = (String)valueMap.get(JMI_DOMAIN);
/*     */       }
/*     */ 
/* 202 */       int mbeanType = mbcap.getMBeanType();
/* 203 */       if (mbeanType == 291)
/*     */       {
/* 205 */         invoker = new XMBean(object, "StandardMBean");
/*     */       }
/* 207 */       else if ((object instanceof MBeanInvoker))
/*     */       {
/* 209 */         invoker = (MBeanInvoker)object;
/*     */       }
/* 211 */       else if (mbeanType == 801)
/*     */       {
/* 213 */         if ((object instanceof RequiredModelMBean))
/* 214 */           invoker = new RequiredModelMBeanInvoker((DynamicMBean)object);
/*     */         else {
/* 216 */           invoker = new RawDynamicInvoker((DynamicMBean)object);
/*     */         }
/*     */       }
/*     */ 
/* 220 */       MBeanEntry entry = new MBeanEntry(regName, invoker, object, valueMap);
/* 221 */       AbstractMBeanInvoker.setMBeanEntry(entry);
/* 222 */       regName = invokePreRegister(invoker, regName, magicToken);
/* 223 */       invokedPreRegister = true;
/*     */       try
/*     */       {
/* 227 */         MBeanInfo info = invoker.getMBeanInfo();
/* 228 */         verifyMBeanInfo(info, name);
/* 229 */         entry.setResourceClassName(info.getClassName());
/*     */ 
/* 234 */         entry.setObjectName(regName);
/*     */ 
/* 236 */         add(entry);
/*     */         try
/*     */         {
/* 241 */           if ((object instanceof ClassLoader)) {
/* 242 */             registerClassLoader((ClassLoader)object);
/*     */           }
/*     */           try
/*     */           {
/* 246 */             if (this.delegate != null)
/* 247 */               sendRegistrationNotification(regName);
/* 248 */             else if (serverConfig.getMBeanServerDelegateName().equals(name)) {
/* 249 */               this.delegate = ((MBeanServerDelegate)object);
/*     */             }
/* 251 */             ServerObjectInstance serverObjInst = new ServerObjectInstance(regName, entry.getResourceClassName(), this.delegate.getMBeanServerId());
/*     */ 
/* 254 */             persistIfRequired(invoker.getMBeanInfo(), regName);
/*     */ 
/* 256 */             ServerObjectInstance localServerObjectInstance1 = serverObjInst;
/*     */ 
/* 334 */             if (invoker != null)
/*     */             {
/*     */               try
/*     */               {
/* 338 */                 invoker.postRegister(new Boolean(registrationDone));
/*     */               }
/*     */               catch (Exception e)
/*     */               {
/* 343 */                 if (invokedPreRegister == true)
/*     */                 {
/* 345 */                   if ((e instanceof RuntimeException)) {
/* 346 */                     throw new RuntimeMBeanException((RuntimeException)e);
/*     */                   }
/* 348 */                   throw new MBeanRegistrationException(e);
/*     */                 }
/*     */               }
/*     */             }
/* 352 */             AbstractMBeanInvoker.setMBeanEntry(null); return localServerObjectInstance1;
/*     */           }
/*     */           catch (Throwable t)
/*     */           {
/* 262 */             if ((object instanceof ClassLoader)) {
/* 263 */               this.loaderRepository.removeClassLoader((ClassLoader)object);
/*     */             }
/* 265 */             throw t;
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 271 */           remove(regName);
/* 272 */           throw t;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NotCompliantMBeanException e)
/*     */       {
/* 278 */         throw e;
/*     */       }
/*     */       catch (InstanceAlreadyExistsException e)
/*     */       {
/* 283 */         throw e;
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 288 */         log.error("Unexpected Exception:", t);
/* 289 */         throw t;
/*     */       }
/*     */     }
/*     */     catch (NotCompliantMBeanException e)
/*     */     {
/* 294 */       registrationDone = false;
/* 295 */       throw e;
/*     */     }
/*     */     catch (InstanceAlreadyExistsException e)
/*     */     {
/* 300 */       registrationDone = false;
/* 301 */       throw e;
/*     */     }
/*     */     catch (MBeanRegistrationException e)
/*     */     {
/* 306 */       registrationDone = false;
/* 307 */       log.warn(e.toString());
/* 308 */       throw e;
/*     */     }
/*     */     catch (RuntimeOperationsException e)
/*     */     {
/* 313 */       registrationDone = false;
/* 314 */       throw e;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 319 */       registrationDone = false;
/* 320 */       ncex = new NotCompliantMBeanException("Cannot register MBean: " + name);
/* 321 */       ncex.initCause(ex);
/* 322 */       throw ncex;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 327 */       log.error("Cannot register MBean", t);
/* 328 */       registrationDone = false;
/* 329 */       NotCompliantMBeanException ncex = null;
/*     */       return ncex;
/*     */     }
/*     */     finally
/*     */     {
/* 334 */       if (invoker != null)
/*     */       {
/*     */         try
/*     */         {
/* 338 */           invoker.postRegister(new Boolean(registrationDone));
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 343 */           if (invokedPreRegister == true)
/*     */           {
/* 345 */             if ((e instanceof RuntimeException)) {
/* 346 */               throw new RuntimeMBeanException((RuntimeException)e);
/*     */             }
/* 348 */             throw new MBeanRegistrationException(e);
/*     */           }
/*     */         }
/*     */       }
/* 352 */       AbstractMBeanInvoker.setMBeanEntry(null); } throw localObject;
/*     */   }
/*     */ 
/*     */   private void verifyMBeanInfo(MBeanInfo info, ObjectName name)
/*     */     throws NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 367 */       if (info == null) {
/* 368 */         throw new NotCompliantMBeanException("MBeanInfo cannot be null, for: " + name);
/*     */       }
/* 370 */       if (info.getClassName() == null)
/* 371 */         throw new NotCompliantMBeanException("Classname returned from MBeanInfo cannot be null, for: " + name);
/*     */     }
/*     */     catch (NotCompliantMBeanException ncex)
/*     */     {
/* 375 */       throw ncex;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 379 */       NotCompliantMBeanException ncex = new NotCompliantMBeanException("Cannot verify MBeanInfo, for: " + name);
/* 380 */       ncex.initCause(t);
/* 381 */       throw ncex;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void sendRegistrationNotification(ObjectName regName)
/*     */   {
/* 393 */     long sequence = this.registrationNotificationSequence.increment();
/* 394 */     this.delegate.sendNotification(new MBeanServerNotification("JMX.mbean.registered", this.delegate, sequence, regName));
/*     */   }
/*     */ 
/*     */   protected ObjectName handlePreRegistration(MBeanRegistration registrationInterface, ObjectName regName)
/*     */     throws Exception
/*     */   {
/* 412 */     ObjectName mbean = registrationInterface.preRegister(this.server, regName);
/* 413 */     if (regName == null)
/*     */     {
/* 415 */       return mbean;
/*     */     }
/*     */ 
/* 419 */     return regName;
/*     */   }
/*     */ 
/*     */   protected void handlePreDeregister(MBeanRegistration registrationInterface)
/*     */     throws Exception
/*     */   {
/* 434 */     registrationInterface.preDeregister();
/*     */   }
/*     */ 
/*     */   protected void registerClassLoader(ClassLoader cl)
/*     */   {
/* 445 */     if (!(cl instanceof RealClassLoader))
/*     */     {
/* 448 */       this.loaderRepository.addClassLoader(cl);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unregisterMBean(ObjectName name)
/*     */     throws InstanceNotFoundException, MBeanRegistrationException
/*     */   {
/* 456 */     name = qualifyName(name);
/* 457 */     if (name.getDomain().equals(JMI_DOMAIN)) {
/* 458 */       throw new RuntimeOperationsException(new IllegalArgumentException("Not allowed to unregister: " + name.toString()));
/*     */     }
/*     */ 
/* 461 */     MBeanEntry entry = get(name);
/* 462 */     Object resource = entry.getResourceInstance();
/*     */     try
/*     */     {
/* 467 */       handlePreDeregister(entry.getInvoker());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 473 */       if ((e instanceof MBeanRegistrationException)) {
/* 474 */         throw ((MBeanRegistrationException)e);
/*     */       }
/* 476 */       throw new MBeanRegistrationException(e, "preDeregister");
/*     */     }
/*     */ 
/* 480 */     if ((resource instanceof ClassLoader)) {
/* 481 */       this.loaderRepository.removeClassLoader((ClassLoader)resource);
/*     */     }
/*     */ 
/* 484 */     remove(name);
/*     */ 
/* 486 */     sendUnRegistrationNotification(name);
/*     */ 
/* 488 */     entry.getInvoker().postDeregister();
/*     */   }
/*     */ 
/*     */   protected void sendUnRegistrationNotification(ObjectName name)
/*     */   {
/* 499 */     long sequence = this.unregistrationNotificationSequence.increment();
/*     */ 
/* 501 */     this.delegate.sendNotification(new MBeanServerNotification("JMX.mbean.unregistered", this.delegate, sequence, name));
/*     */   }
/*     */ 
/*     */   public MBeanEntry get(ObjectName name)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 514 */     if (name == null) {
/* 515 */       throw new RuntimeOperationsException(new IllegalArgumentException("null object name"));
/*     */     }
/*     */ 
/* 518 */     String domain = name.getDomain();
/*     */ 
/* 520 */     if (domain.length() == 0) {
/* 521 */       domain = this.defaultDomain;
/*     */     }
/* 523 */     String props = name.getCanonicalKeyPropertyListString();
/* 524 */     Map mbeanMap = getMBeanMap(domain, false);
/*     */ 
/* 527 */     Object o = null;
/* 528 */     if ((null == mbeanMap) || (null == (o = mbeanMap.get(props)))) {
/* 529 */       throw new InstanceNotFoundException(name + " is not registered.");
/*     */     }
/*     */ 
/* 532 */     return (MBeanEntry)o;
/*     */   }
/*     */ 
/*     */   public String getDefaultDomain()
/*     */   {
/* 537 */     return this.defaultDomain;
/*     */   }
/*     */ 
/*     */   public String[] getDomains()
/*     */   {
/* 542 */     ArrayList domains = new ArrayList(this.domainMap.size());
/* 543 */     for (Iterator iterator = this.domainMap.entrySet().iterator(); iterator.hasNext(); )
/*     */     {
/* 545 */       Map.Entry entry = (Map.Entry)iterator.next();
/* 546 */       String domainName = (String)entry.getKey();
/* 547 */       Map mbeans = (Map)entry.getValue();
/* 548 */       if ((mbeans != null) && (!mbeans.isEmpty()))
/* 549 */         domains.add(domainName);
/*     */     }
/* 551 */     return (String[])(String[])domains.toArray(new String[domains.size()]);
/*     */   }
/*     */ 
/*     */   public ObjectInstance getObjectInstance(ObjectName name)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 557 */     if (!contains(name)) {
/* 558 */       throw new InstanceNotFoundException(name + " not registered.");
/*     */     }
/* 560 */     return new ServerObjectInstance(qualifyName(name), get(name).getResourceClassName(), this.delegate.getMBeanServerId());
/*     */   }
/*     */ 
/*     */   public Object getValue(ObjectName name, String key)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 567 */     return get(name).getValue(key);
/*     */   }
/*     */ 
/*     */   public boolean contains(ObjectName name)
/*     */   {
/* 573 */     if (name == null) {
/* 574 */       return false;
/*     */     }
/*     */ 
/* 577 */     String domain = name.getDomain();
/*     */ 
/* 579 */     if (domain.length() == 0) {
/* 580 */       domain = this.defaultDomain;
/*     */     }
/* 582 */     String props = name.getCanonicalKeyPropertyListString();
/* 583 */     Map mbeanMap = getMBeanMap(domain, false);
/*     */ 
/* 586 */     return (null != mbeanMap) && (mbeanMap.containsKey(props));
/*     */   }
/*     */ 
/*     */   public int getSize()
/*     */   {
/* 591 */     int retval = 0;
/* 592 */     for (Iterator iterator = this.domainMap.values().iterator(); iterator.hasNext(); )
/*     */     {
/* 594 */       retval += ((Map)iterator.next()).size();
/*     */     }
/* 596 */     return retval;
/*     */   }
/*     */ 
/*     */   public List findEntries(ObjectName pattern)
/*     */   {
/* 601 */     ArrayList retval = new ArrayList();
/*     */     Iterator domainIter;
/*     */     String patternDomain;
/*     */     ObjectNamePatternHelper.PropertyPattern propertyPattern;
/*     */     Iterator domainIter;
/* 608 */     if ((pattern == null) || (pattern.getCanonicalName().equals("*:*")))
/*     */     {
/* 610 */       for (domainIter = this.domainMap.values().iterator(); domainIter.hasNext(); ) {
/* 611 */         retval.addAll(((Map)domainIter.next()).values());
/*     */       }
/*     */     }
/* 614 */     else if (!pattern.isPattern())
/*     */     {
/*     */       try
/*     */       {
/* 619 */         retval.add(get(pattern));
/*     */       }
/*     */       catch (InstanceNotFoundException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 629 */       patternDomain = pattern.getDomain();
/* 630 */       if (patternDomain.length() == 0)
/* 631 */         patternDomain = this.defaultDomain;
/* 632 */       propertyPattern = new ObjectNamePatternHelper.PropertyPattern(pattern);
/*     */ 
/* 636 */       for (domainIter = this.domainMap.entrySet().iterator(); domainIter.hasNext(); )
/*     */       {
/* 638 */         Map.Entry mapEntry = (Map.Entry)domainIter.next();
/* 639 */         Map value = (Map)mapEntry.getValue();
/* 640 */         if ((value != null) && (!value.isEmpty()))
/*     */         {
/* 642 */           if (ObjectNamePatternHelper.patternMatch((String)mapEntry.getKey(), patternDomain))
/*     */           {
/* 644 */             for (mbeanIter = value.values().iterator(); mbeanIter.hasNext(); )
/*     */             {
/* 646 */               MBeanEntry entry = (MBeanEntry)mbeanIter.next();
/* 647 */               if (propertyPattern.patternMatch(entry.getObjectName()))
/* 648 */                 retval.add(entry);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     Iterator mbeanIter;
/* 655 */     return retval;
/*     */   }
/*     */ 
/*     */   public void releaseRegistry()
/*     */   {
/* 666 */     this.server = null;
/* 667 */     this.delegate = null;
/*     */ 
/* 670 */     for (Iterator iterator = this.domainMap.keySet().iterator(); iterator.hasNext(); )
/*     */     {
/* 672 */       Map nextMap = (Map)this.domainMap.get(iterator.next());
/*     */ 
/* 674 */       if (nextMap.size() > 0)
/*     */       {
/* 676 */         nextMap.clear();
/*     */       }
/*     */     }
/*     */ 
/* 680 */     this.domainMap.clear();
/* 681 */     this.domainMap = null;
/*     */   }
/*     */ 
/*     */   protected ObjectName invokePreRegister(MBeanInvoker invoker, ObjectName regName, String magicToken)
/*     */     throws MBeanRegistrationException, NotCompliantMBeanException
/*     */   {
/* 693 */     if (regName != null) {
/* 694 */       regName = qualifyName(regName);
/*     */     }
/*     */ 
/* 697 */     ObjectName mbeanName = null;
/*     */     try
/*     */     {
/* 703 */       mbeanName = invoker.preRegister(this.server, regName);
/*     */     }
/*     */     catch (NotCompliantMBeanException ncex)
/*     */     {
/* 708 */       throw ncex;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 714 */       if ((e instanceof MBeanRegistrationException))
/*     */       {
/* 716 */         throw ((MBeanRegistrationException)e);
/*     */       }
/*     */ 
/* 719 */       throw new MBeanRegistrationException(e, "preRegister() failed: [ObjectName='" + regName + "', Class=" + invoker.getResource().getClass().getName() + " (" + invoker.getResource() + ")]");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 728 */       log.warn("preRegister() failed for " + regName + ": ", t);
/*     */ 
/* 730 */       if ((t instanceof Error)) {
/* 731 */         throw new RuntimeErrorException((Error)t);
/*     */       }
/* 733 */       throw new RuntimeException(t.toString());
/*     */     }
/*     */ 
/* 739 */     if (regName == null) {
/* 740 */       regName = mbeanName;
/*     */     }
/* 742 */     return validateAndQualifyName(regName, magicToken);
/*     */   }
/*     */ 
/*     */   protected synchronized void add(MBeanEntry entry)
/*     */     throws InstanceAlreadyExistsException
/*     */   {
/* 758 */     ObjectName name = entry.getObjectName();
/* 759 */     String domain = name.getDomain();
/* 760 */     String props = name.getCanonicalKeyPropertyListString();
/*     */ 
/* 763 */     Map mbeanMap = getMBeanMap(domain, true);
/*     */ 
/* 766 */     if (mbeanMap.get(props) != null) {
/* 767 */       throw new InstanceAlreadyExistsException(name + " already registered.");
/*     */     }
/*     */ 
/* 770 */     mbeanMap.put(props, entry);
/*     */   }
/*     */ 
/*     */   protected synchronized void remove(ObjectName name)
/*     */     throws InstanceNotFoundException
/*     */   {
/* 786 */     String domain = name.getDomain();
/* 787 */     String props = name.getCanonicalKeyPropertyListString();
/* 788 */     Map mbeanMap = getMBeanMap(domain, false);
/*     */ 
/* 791 */     if ((null == mbeanMap) || (null == mbeanMap.remove(props)))
/* 792 */       throw new InstanceNotFoundException(name + " not registered.");
/*     */   }
/*     */ 
/*     */   protected ObjectName validateAndQualifyName(ObjectName name, String magicToken)
/*     */   {
/* 816 */     ObjectName result = qualifyName(name);
/*     */ 
/* 819 */     if (result.isPattern()) {
/* 820 */       throw new RuntimeOperationsException(new IllegalArgumentException("Object name is a pattern:" + name));
/*     */     }
/*     */ 
/* 824 */     if ((magicToken != JMI_DOMAIN) && (result.getDomain().equals(JMI_DOMAIN)))
/*     */     {
/* 826 */       throw new RuntimeOperationsException(new IllegalArgumentException("Domain " + JMI_DOMAIN + " is reserved"));
/*     */     }
/*     */ 
/* 830 */     return result;
/*     */   }
/*     */ 
/*     */   protected ObjectName qualifyName(ObjectName name)
/*     */   {
/* 846 */     if (name == null) {
/* 847 */       throw new RuntimeOperationsException(new IllegalArgumentException("Null object name"));
/*     */     }
/*     */     try
/*     */     {
/* 851 */       if (name.getDomain().length() == 0) {
/* 852 */         return new ObjectName(this.defaultDomain + ":" + name.getCanonicalKeyPropertyListString());
/*     */       }
/*     */ 
/* 855 */       return name;
/*     */     }
/*     */     catch (MalformedObjectNameException e) {
/*     */     }
/* 859 */     throw new RuntimeOperationsException(new IllegalArgumentException(e.toString()));
/*     */   }
/*     */ 
/*     */   protected void persistIfRequired(MBeanInfo info, ObjectName name)
/*     */     throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 896 */     if (!(info instanceof ModelMBeanInfo))
/*     */     {
/* 898 */       return;
/* 900 */     }ModelMBeanInfo mmbInfo = (ModelMBeanInfo)info;
/*     */     Descriptor descriptor;
/*     */     try {
/* 904 */       descriptor = mmbInfo.getMBeanDescriptor();
/*     */     }
/*     */     catch (MBeanException cause)
/*     */     {
/* 908 */       log.error("Error trying to get descriptors.", cause);
/* 909 */       return;
/*     */     }
/* 911 */     if (descriptor == null)
/* 912 */       return;
/* 913 */     String persistInfo = (String)descriptor.getFieldValue("persistmbeaninfo");
/* 914 */     if (persistInfo == null)
/* 915 */       return;
/* 916 */     log.debug("persistInfo: " + persistInfo);
/* 917 */     Boolean shouldPersist = new Boolean(persistInfo);
/* 918 */     if (!shouldPersist.booleanValue())
/*     */     {
/* 920 */       return;
/*     */     }
/* 922 */     mbInfosToStore().add(name);
/*     */ 
/* 924 */     if (contains(this.mbeanInfoService))
/*     */     {
/* 927 */       log.debug("flushing queue");
/* 928 */       this.server.invoke(this.mbeanInfoService, "add", new Object[] { mbInfosToStore().clone() }, new String[] { mbInfosToStore().getClass().getName() });
/*     */ 
/* 933 */       log.debug("clearing queue");
/* 934 */       mbInfosToStore().clear();
/*     */     }
/*     */     else
/*     */     {
/* 938 */       log.debug("service is not registered.  items remain in queue");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Vector mbInfosToStore()
/*     */   {
/* 948 */     if (this.fMbInfosToStore == null)
/*     */     {
/* 950 */       this.fMbInfosToStore = new Vector(10);
/*     */     }
/* 952 */     return this.fMbInfosToStore;
/*     */   }
/*     */ 
/*     */   private Map getMBeanMap(String domain, boolean createIfMissing)
/*     */   {
/* 967 */     Map mbeanMap = (Map)this.domainMap.get(domain);
/* 968 */     if ((mbeanMap == null) && (createIfMissing))
/*     */     {
/* 970 */       mbeanMap = new ConcurrentReaderHashMap();
/* 971 */       this.domainMap.put(domain, mbeanMap);
/*     */     }
/* 973 */     return mbeanMap;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.registry.BasicMBeanRegistry
 * JD-Core Version:    0.6.0
 */