/*     */ package org.jboss.mx.server;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.reflect.Proxy;
/*     */ 
/*     */ public class ObjectInputStreamWithClassLoader extends ObjectInputStream
/*     */ {
/*     */   ClassLoader cl;
/*     */ 
/*     */   public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl)
/*     */     throws IOException
/*     */   {
/*  72 */     super(in);
/*     */ 
/*  74 */     this.cl = cl;
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass osc)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  99 */     return this.cl.loadClass(osc.getName());
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 105 */     Class[] interfacesClass = new Class[interfaces.length];
/* 106 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 108 */       interfacesClass[i] = Class.forName(interfaces[i], false, this.cl);
/*     */     }
/*     */ 
/* 111 */     return Proxy.getProxyClass(this.cl, interfacesClass);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.ObjectInputStreamWithClassLoader
 * JD-Core Version:    0.6.0
 */