/*     */ package org.jboss.mx.persistence;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.Vector;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.modelmbean.InvalidTargetObjectTypeException;
/*     */ import javax.management.modelmbean.ModelMBean;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanInvoker;
/*     */ import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
/*     */ import org.jboss.mx.server.registry.MbeanInfoDb;
/*     */ 
/*     */ public class MbeanInfoDbPm extends MBeanInfoOdb
/*     */   implements PersistenceManager
/*     */ {
/*     */   protected boolean fLoadedFromFs;
/*     */   protected Vector fNamesToRestore;
/*     */   protected Vector fInfosToRestore;
/*     */   protected MBeanServer fMbeanServer;
/*     */   protected MbeanInfoDb fMbeanInfoDb;
/*     */   protected File fMbiDbRoot;
/*     */ 
/*     */   public void load(ModelMBeanInvoker mbean, MBeanInfo info)
/*     */     throws MBeanException
/*     */   {
/*  76 */     logger().debug("Loading the MBI DB");
/*  77 */     setMbeanInfoDb((MbeanInfoDb)mbean.getResource());
/*  78 */     if (!loadedFromFs())
/*     */     {
/*  82 */       Descriptor d = ((ModelMBeanInfo)info).getMBeanDescriptor();
/*  83 */       String dir = (String)d.getFieldValue("persistLocation");
/*     */ 
/*  85 */       if ((dir != null) && (!dir.equals("")))
/*     */       {
/*  88 */         setMbiDbRoot(new File(dir));
/*     */       }
/*  90 */       String message = "Loading the MBI DB from the filesystem.  location: ";
/*  91 */       message = message + mbiDbRoot();
/*  92 */       logger().debug(message);
/*  93 */       File[] mbiFiles = mbiDbRoot().listFiles();
/*  94 */       if (mbiFiles == null)
/*     */       {
/*  97 */         return;
/*     */       }
/*     */ 
/* 100 */       for (int index = 0; index < mbiFiles.length; index++)
/*     */       {
/* 104 */         File curFile = mbiFiles[index];
/* 105 */         ObjectName nameToRestore = null;
/*     */         try
/*     */         {
/* 109 */           nameToRestore = objectName(curFile);
/*     */         }
/*     */         catch (MalformedObjectNameException cause)
/*     */         {
/* 114 */           throw new MBeanException(cause, "Object Name was stored incorrectly.");
/*     */         }
/*     */ 
/* 117 */         MBeanInfo infoToRestore = null;
/*     */         try
/*     */         {
/* 121 */           infoToRestore = load(curFile);
/*     */         }
/*     */         catch (IOException cause)
/*     */         {
/* 126 */           throw new MBeanException(cause, "Couldn't read the MBeanInfo file.");
/*     */         }
/*     */         catch (ClassNotFoundException cause2)
/*     */         {
/* 132 */           String message2 = "Couldn't find the Class specified in the object file.";
/* 133 */           throw new MBeanException(cause2, message2);
/*     */         }
/* 135 */         if (infoToRestore == null)
/*     */         {
/* 138 */           throw new MBeanException(new Exception("Null loaded MBean info.  Error on load."), "Could not load");
/*     */         }
/*     */ 
/* 142 */         namesToRestore().add(nameToRestore);
/* 143 */         infosToRestore().add(infoToRestore);
/*     */       }
/* 145 */       setLoadedFromFs(true);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 150 */       register();
/*     */     }
/*     */     catch (Exception cause)
/*     */     {
/* 155 */       throw new MBeanException(cause, "Error trying to register loaded MBeans");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void store(MBeanInfo info)
/*     */     throws MBeanException
/*     */   {
/* 163 */     logger().debug("storing MBI DB State");
/* 164 */     Enumeration queue = mbeanInfoDb().mbiPersistenceQueue();
/* 165 */     while (queue.hasMoreElements())
/*     */     {
/* 168 */       ObjectName curName = (ObjectName)queue.nextElement();
/* 169 */       logger().debug("queue elem: " + curName);
/* 170 */       MBeanInfo curInfo = null;
/*     */       try
/*     */       {
/* 174 */         curInfo = getMBeanServer().getMBeanInfo(curName);
/*     */       }
/*     */       catch (InstanceNotFoundException cause)
/*     */       {
/* 179 */         throw new MBeanException(cause);
/*     */       }
/*     */       catch (JMException cause3)
/*     */       {
/* 184 */         throw new MBeanException(cause3);
/*     */       }
/* 186 */       if (curInfo == null)
/*     */       {
/* 189 */         throw new MBeanException(new Exception("Current MBean Info object is null."), "Could not store null object.");
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 196 */         store(curName, curInfo);
/*     */       }
/*     */       catch (IOException cause2)
/*     */       {
/* 201 */         throw new MBeanException(cause2);
/*     */       }
/* 203 */       mbeanInfoDb().removeFromMbiQueue(curName);
/* 204 */       logger().info("Successfully stored mbi for " + curName);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void store(ObjectName name, MBeanInfo info)
/*     */     throws IOException
/*     */   {
/* 212 */     File location = new File(mbiDbRoot(), fileName(name));
/* 213 */     logger().debug("Storing mbi at: " + location);
/* 214 */     mbiDbRoot().mkdirs();
/* 215 */     store(info, location);
/*     */   }
/*     */ 
/*     */   protected void register()
/*     */     throws JMException, InvalidTargetObjectTypeException
/*     */   {
/* 227 */     logger().debug("registering...");
/* 228 */     Enumeration names = namesToRestore().elements();
/* 229 */     Enumeration infos = infosToRestore().elements();
/*     */     try
/*     */     {
/* 233 */       while ((names.hasMoreElements()) && (infos.hasMoreElements()))
/*     */       {
/* 236 */         ObjectName curName = (ObjectName)names.nextElement();
/* 237 */         logger().debug("curName: " + curName);
/* 238 */         ModelMBeanInfo curInfo = (ModelMBeanInfo)infos.nextElement();
/* 239 */         Descriptor mbeanDescriptor = curInfo.getMBeanDescriptor();
/* 240 */         String fieldName = "resourceClass";
/* 241 */         String className = (String)mbeanDescriptor.getFieldValue(fieldName);
/* 242 */         logger().debug("className: " + className);
/* 243 */         Object resource = getMBeanServer().instantiate(className);
/* 244 */         ModelMBean modelmbean = RequiredModelMBeanInstantiator.instantiate();
/* 245 */         modelmbean.setModelMBeanInfo(curInfo);
/* 246 */         modelmbean.setManagedResource(resource, "ObjectReference");
/* 247 */         getMBeanServer().registerMBean(modelmbean, curName);
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 253 */       namesToRestore().removeAllElements();
/* 254 */       infosToRestore().removeAllElements();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected MBeanServer getMBeanServer()
/*     */     throws JMException
/*     */   {
/* 261 */     if (this.fMbeanServer == null)
/*     */     {
/* 264 */       Collection col = MBeanServerFactory.findMBeanServer(null);
/* 265 */       if (col.isEmpty())
/*     */       {
/* 268 */         throw new JMException("No MBeanServer found");
/*     */       }
/* 270 */       this.fMbeanServer = ((MBeanServer)col.iterator().next());
/*     */     }
/* 272 */     return this.fMbeanServer;
/*     */   }
/*     */ 
/*     */   protected String replaceAll(String object, String target, String replacement)
/*     */   {
/* 283 */     return replaceAll(object, target, replacement, 0);
/*     */   }
/*     */ 
/*     */   protected String replaceAll(String object, String target, String replacement, int curIndex)
/*     */   {
/* 291 */     int indexOfMatch = object.indexOf(target, curIndex);
/* 292 */     if (indexOfMatch < curIndex)
/*     */     {
/* 295 */       return object;
/*     */     }
/* 297 */     String prefix = "";
/* 298 */     if (indexOfMatch > 0)
/*     */     {
/* 301 */       prefix = object.substring(0, indexOfMatch);
/*     */     }
/* 303 */     String tail = object.substring(indexOfMatch + target.length());
/* 304 */     String newObject = prefix + replacement + tail;
/* 305 */     return replaceAll(newObject, target, replacement, indexOfMatch + replacement.length());
/*     */   }
/*     */ 
/*     */   protected String objNameSeparator()
/*     */   {
/* 311 */     return ":";
/*     */   }
/*     */ 
/*     */   protected String objNameSepRep()
/*     */   {
/* 317 */     return "___";
/*     */   }
/*     */ 
/*     */   protected String fileName(ObjectName name)
/*     */   {
/* 323 */     String fileName = name.getCanonicalName();
/* 324 */     fileName = replaceAll(fileName, objNameSeparator(), objNameSepRep());
/* 325 */     return fileName;
/*     */   }
/*     */ 
/*     */   protected ObjectName objectName(File fileName)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 332 */     String objectName = fileName.getName();
/* 333 */     objectName = replaceAll(objectName, objNameSepRep(), objNameSeparator());
/* 334 */     return new ObjectName(objectName);
/*     */   }
/*     */ 
/*     */   protected boolean loadedFromFs()
/*     */   {
/* 340 */     return this.fLoadedFromFs;
/*     */   }
/*     */ 
/*     */   protected void setLoadedFromFs(boolean newLoadedFromFs)
/*     */   {
/* 346 */     this.fLoadedFromFs = newLoadedFromFs;
/*     */   }
/*     */ 
/*     */   protected Vector namesToRestore()
/*     */   {
/* 352 */     if (this.fNamesToRestore == null)
/*     */     {
/* 355 */       this.fNamesToRestore = new Vector(10);
/*     */     }
/* 357 */     return this.fNamesToRestore;
/*     */   }
/*     */ 
/*     */   protected Vector infosToRestore()
/*     */   {
/* 363 */     if (this.fInfosToRestore == null)
/*     */     {
/* 366 */       this.fInfosToRestore = new Vector(10);
/*     */     }
/* 368 */     return this.fInfosToRestore;
/*     */   }
/*     */ 
/*     */   protected File mbiDbRoot()
/*     */   {
/* 374 */     if (this.fMbiDbRoot == null)
/*     */     {
/* 377 */       this.fMbiDbRoot = new File("../conf/mbean-info-db/");
/*     */     }
/* 379 */     return this.fMbiDbRoot;
/*     */   }
/*     */ 
/*     */   protected void setMbiDbRoot(File newMbiDbRoot)
/*     */   {
/* 385 */     this.fMbiDbRoot = newMbiDbRoot;
/*     */   }
/*     */ 
/*     */   protected MbeanInfoDb mbeanInfoDb()
/*     */   {
/* 391 */     return this.fMbeanInfoDb;
/*     */   }
/*     */ 
/*     */   protected void setMbeanInfoDb(MbeanInfoDb newMbeanInfoDb)
/*     */   {
/* 397 */     this.fMbeanInfoDb = newMbeanInfoDb;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.persistence.MbeanInfoDbPm
 * JD-Core Version:    0.6.0
 */