/*     */ package org.jboss.mx.notification;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.HashSet;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class NotificationListenerProxy
/*     */   implements InvocationHandler
/*     */ {
/*     */   private NotificationListener listener;
/*     */   private ObjectName name;
/*     */   private static final String METHODNAME = "handleNotification";
/*     */   private final Integer hashCode;
/*     */ 
/*     */   public static Object newInstance(ObjectName name, NotificationListener listener)
/*     */   {
/*  77 */     HashSet set = new HashSet();
/*     */ 
/*  80 */     Class currentClass = listener.getClass();
/*  81 */     while (currentClass != null)
/*     */     {
/*  83 */       Class[] classInterfaces = currentClass.getInterfaces();
/*  84 */       for (int i = 0; i < classInterfaces.length; i++)
/*     */       {
/*  86 */         set.add(classInterfaces[i]);
/*     */       }
/*  88 */       currentClass = currentClass.getSuperclass();
/*     */     }
/*  90 */     Class[] interfaces = new Class[set.size()];
/*  91 */     interfaces = (Class[])(Class[])set.toArray(interfaces);
/*     */ 
/*  93 */     return Proxy.newProxyInstance(listener.getClass().getClassLoader(), interfaces, new NotificationListenerProxy(name, listener));
/*     */   }
/*     */ 
/*     */   public NotificationListenerProxy(ObjectName name, NotificationListener listener)
/*     */   {
/* 109 */     this.name = name;
/* 110 */     this.listener = listener;
/* 111 */     this.hashCode = new Integer(System.identityHashCode(this));
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 126 */     String localMethodName = method.getName();
/*     */ 
/* 128 */     if (localMethodName.equals("handleNotification"))
/*     */     {
/* 130 */       for (int x = 0; x < args.length; x++)
/*     */       {
/* 132 */         if (!(args[x] instanceof Notification))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/* 137 */         ((Notification)args[x]).setSource(this.name);
/*     */       }
/*     */     }
/*     */     else {
/* 141 */       if (localMethodName.equals("hashCode"))
/*     */       {
/* 143 */         return proxyHashCode(proxy);
/*     */       }
/* 145 */       if (localMethodName.equals("equals"))
/*     */       {
/* 147 */         return proxyEquals(proxy, args[0]);
/*     */       }
/* 149 */       if (localMethodName.equals("toString"))
/*     */       {
/* 151 */         return proxyToString(proxy);
/*     */       }
/*     */     }
/* 153 */     return method.invoke(this.listener, args);
/*     */   }
/*     */ 
/*     */   protected Integer proxyHashCode(Object proxy)
/*     */   {
/* 158 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   protected Boolean proxyEquals(Object proxy, Object other)
/*     */   {
/* 163 */     return proxy == other ? Boolean.TRUE : Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   protected String proxyToString(Object proxy)
/*     */   {
/* 168 */     return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.notification.NotificationListenerProxy
 * JD-Core Version:    0.6.0
 */