/*     */ package org.jboss.mx.notification;
/*     */ 
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.NotificationBroadcaster;
/*     */ import javax.management.NotificationEmitter;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class MBeanServerListenerRegistration extends DefaultListenerRegistration
/*     */ {
/*     */   private NotificationListener proxy;
/*     */   private NotificationFilter filterProxy;
/*     */   private NotificationBroadcaster broadcaster;
/*     */ 
/*     */   public MBeanServerListenerRegistration(ObjectName name, NotificationBroadcaster broadcaster, NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/*  78 */     super(listener, filter, handback);
/*  79 */     this.proxy = ((NotificationListener)NotificationListenerProxy.newInstance(name, listener));
/*  80 */     this.broadcaster = broadcaster;
/*  81 */     this.filterProxy = (filter == null ? null : new NotificationFilterProxy(name, filter));
/*  82 */     broadcaster.addNotificationListener(this.proxy, this.filterProxy, handback);
/*     */   }
/*     */ 
/*     */   public NotificationListener getListener()
/*     */   {
/*  91 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   public NotificationFilter getFilter()
/*     */   {
/*  96 */     return this.filterProxy;
/*     */   }
/*     */ 
/*     */   public void removed()
/*     */   {
/*     */     try
/*     */     {
/* 103 */       if ((this.broadcaster instanceof NotificationEmitter))
/* 104 */         ((NotificationEmitter)this.broadcaster).removeNotificationListener(getListener(), getFilter(), getHandback());
/*     */       else
/* 106 */         this.broadcaster.removeNotificationListener(getListener());
/*     */     }
/*     */     catch (ListenerNotFoundException ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.notification.MBeanServerListenerRegistration
 * JD-Core Version:    0.6.0
 */