/*     */ package org.jboss.mx.notification;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import javax.management.JMException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ 
/*     */ public class ListenerRegistry
/*     */ {
/*  64 */   private HashMap listeners = new HashMap();
/*     */   private ListenerRegistrationFactory factory;
/*     */ 
/*     */   public ListenerRegistry()
/*     */   {
/*  80 */     this(null);
/*     */   }
/*     */ 
/*     */   public ListenerRegistry(ListenerRegistrationFactory factory)
/*     */   {
/*  92 */     if (factory == null)
/*  93 */       this.factory = new DefaultListenerRegistrationFactory();
/*     */     else
/*  95 */       this.factory = factory;
/*     */   }
/*     */ 
/*     */   public void add(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws JMException
/*     */   {
/* 112 */     if (listener == null) {
/* 113 */       throw new IllegalArgumentException("Null listener");
/*     */     }
/* 115 */     synchronized (this.listeners)
/*     */     {
/* 117 */       HashMap newListeners = (HashMap)this.listeners.clone();
/*     */ 
/* 119 */       ArrayList registrations = (ArrayList)newListeners.get(listener);
/* 120 */       if (registrations == null)
/*     */       {
/* 122 */         registrations = new ArrayList();
/* 123 */         newListeners.put(listener, registrations);
/*     */       }
/*     */       else
/*     */       {
/* 127 */         registrations = (ArrayList)registrations.clone();
/* 128 */         newListeners.put(listener, registrations);
/*     */       }
/*     */ 
/* 131 */       registrations.add(this.factory.create(listener, filter, handback));
/*     */ 
/* 133 */       this.listeners = newListeners;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 146 */     ArrayList registrations = null;
/* 147 */     synchronized (this.listeners)
/*     */     {
/* 149 */       if (!this.listeners.containsKey(listener)) {
/* 150 */         throw new ListenerNotFoundException("Listener not found " + listener);
/*     */       }
/* 152 */       HashMap newListeners = (HashMap)this.listeners.clone();
/*     */ 
/* 154 */       registrations = (ArrayList)newListeners.remove(listener);
/*     */ 
/* 156 */       this.listeners = newListeners;
/*     */     }
/*     */ 
/* 159 */     for (Iterator iterator = registrations.iterator(); iterator.hasNext(); )
/*     */     {
/* 161 */       ListenerRegistration registration = (ListenerRegistration)iterator.next();
/* 162 */       registration.removed();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 177 */     ListenerRegistration registration = null;
/* 178 */     synchronized (this.listeners)
/*     */     {
/* 180 */       ArrayList registrations = (ArrayList)this.listeners.get(listener);
/* 181 */       if (registrations == null) {
/* 182 */         throw new ListenerNotFoundException("No registristrations for listener not listener=" + listener + " filter=" + filter + " handback=" + handback);
/*     */       }
/*     */ 
/* 185 */       registration = new DefaultListenerRegistration(listener, filter, handback);
/* 186 */       int index = registrations.indexOf(registration);
/* 187 */       if (index == -1) {
/* 188 */         throw new ListenerNotFoundException("Listener not found listener=" + listener + " filter=" + filter + " handback=" + handback);
/*     */       }
/*     */ 
/* 191 */       HashMap newListeners = (HashMap)this.listeners.clone();
/*     */ 
/* 193 */       registrations = (ArrayList)registrations.clone();
/* 194 */       registration = (ListenerRegistration)registrations.remove(index);
/* 195 */       if (registrations.isEmpty())
/* 196 */         newListeners.remove(listener);
/*     */       else {
/* 198 */         newListeners.put(listener, registrations);
/*     */       }
/* 200 */       this.listeners = newListeners;
/*     */     }
/*     */ 
/* 203 */     registration.removed();
/*     */   }
/*     */ 
/*     */   public void removeAll()
/*     */   {
/* 211 */     synchronized (this.listeners)
/*     */     {
/* 213 */       this.listeners.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public ListenerRegistrationIterator iterator()
/*     */   {
/* 227 */     return new ListenerRegistrationIterator();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 237 */     return this.listeners.isEmpty();
/*     */   }
/*     */ 
/*     */   public class ListenerRegistrationIterator
/*     */     implements Iterator
/*     */   {
/*     */     private Iterator listenerIterator;
/*     */     private Iterator registrationIterator;
/*     */ 
/*     */     public ListenerRegistrationIterator()
/*     */     {
/* 253 */       this.listenerIterator = ListenerRegistry.this.listeners.values().iterator();
/*     */     }
/*     */ 
/*     */     public boolean hasNext()
/*     */     {
/* 258 */       if ((this.registrationIterator == null) || (!this.registrationIterator.hasNext()))
/*     */       {
/*     */         do
/*     */         {
/* 262 */           if (!this.listenerIterator.hasNext()) {
/* 263 */             return false;
/*     */           }
/* 265 */           this.registrationIterator = ((ArrayList)this.listenerIterator.next()).iterator();
/*     */         }
/* 267 */         while (!this.registrationIterator.hasNext());
/*     */       }
/* 269 */       return true;
/*     */     }
/*     */ 
/*     */     public Object next()
/*     */     {
/* 274 */       if (!hasNext()) {
/* 275 */         throw new NoSuchElementException("Use hasNext before next");
/*     */       }
/* 277 */       return this.registrationIterator.next();
/*     */     }
/*     */ 
/*     */     public ListenerRegistration nextRegistration()
/*     */     {
/* 285 */       return (ListenerRegistration)next();
/*     */     }
/*     */ 
/*     */     public void remove()
/*     */     {
/* 293 */       throw new UnsupportedOperationException("remove is not supported");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.notification.ListenerRegistry
 * JD-Core Version:    0.6.0
 */