/*    */ package org.jboss.mx.mxbean;
/*    */ 
/*    */ import java.lang.reflect.ParameterizedType;
/*    */ import java.lang.reflect.Type;
/*    */ import javax.management.openmbean.OpenType;
/*    */ import org.jboss.util.UnreachableStatementException;
/*    */ 
/*    */ public class SkeletonOpenType
/*    */ {
/*    */   private OpenType openType;
/*    */   private CompositeTypeMetaData composite;
/*    */ 
/*    */   public SkeletonOpenType(Type type)
/*    */   {
/* 52 */     this.openType = MXBeanUtils.checkType(type);
/* 53 */     if (this.openType != null)
/* 54 */       return;
/* 55 */     Class clazz = null;
/* 56 */     if ((type instanceof ParameterizedType))
/*    */     {
/* 58 */       ParameterizedType parameterizedType = (ParameterizedType)type;
/* 59 */       clazz = (Class)parameterizedType.getRawType();
/*    */     }
/* 61 */     else if ((type instanceof Class))
/*    */     {
/* 63 */       clazz = (Class)type;
/*    */     }
/*    */     else
/*    */     {
/* 67 */       throw new UnsupportedOperationException("Unable to create open type for " + type);
/*    */     }
/* 69 */     this.composite = CompositeTypeMetaDataFactory.getCompositeTypeMetaData(clazz);
/*    */   }
/*    */ 
/*    */   public OpenType getOpenType()
/*    */   {
/* 79 */     if (this.openType != null)
/* 80 */       return this.openType;
/* 81 */     if (this.composite != null)
/* 82 */       return this.composite.getCompositeType();
/* 83 */     throw new UnreachableStatementException();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.SkeletonOpenType
 * JD-Core Version:    0.6.0
 */