/*     */ package org.jboss.mx.mxbean;
/*     */ 
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotificationEmitter;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ 
/*     */ public class MXBeanSupport
/*     */   implements DynamicMBean, MBeanRegistration, NotificationEmitter
/*     */ {
/*  50 */   private static final MBeanNotificationInfo[] NO_NOTIFICATIONS = new MBeanNotificationInfo[0];
/*     */   private DynamicMBean delegate;
/*     */   private MBeanRegistration registration;
/*     */   private NotificationEmitter emitter;
/*     */ 
/*     */   protected MXBeanSupport()
/*     */   {
/*  66 */     init(MXBeanUtils.createMXBean(this, null));
/*     */   }
/*     */ 
/*     */   protected MXBeanSupport(Class<?> mxbeanInterface)
/*     */   {
/*  76 */     init(MXBeanUtils.createMXBean(this, mxbeanInterface));
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/*  81 */     return this.delegate.getMBeanInfo();
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/*  86 */     return this.delegate.getAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes)
/*     */   {
/*  91 */     return this.delegate.getAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/*  96 */     this.delegate.setAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 101 */     return this.delegate.setAttributes(attributes);
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException
/*     */   {
/* 106 */     return this.delegate.invoke(actionName, params, signature);
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception
/*     */   {
/* 111 */     return this.registration.preRegister(server, name);
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/* 116 */     this.registration.postDeregister();
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception
/*     */   {
/* 121 */     this.registration.preDeregister();
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/* 126 */     this.registration.postDeregister();
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 131 */     return NO_NOTIFICATIONS;
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException
/*     */   {
/* 136 */     this.emitter.addNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 142 */     this.emitter.removeNotificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException
/*     */   {
/* 147 */     this.emitter.removeNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   private void init(DynamicMBean delegate)
/*     */   {
/* 157 */     this.delegate = delegate;
/* 158 */     this.registration = ((MBeanRegistration)delegate);
/* 159 */     this.emitter = ((NotificationEmitter)delegate);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.MXBeanSupport
 * JD-Core Version:    0.6.0
 */