/*     */ package org.jboss.mx.mxbean;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.openmbean.CompositeType;
/*     */ import javax.management.openmbean.OpenType;
/*     */ import javax.management.openmbean.SimpleType;
/*     */ import org.jboss.util.UnexpectedThrowable;
/*     */ 
/*     */ public class CompositeTypeMetaData
/*     */ {
/*     */   private Class<?> clazz;
/*     */   private CompositeType compositeType;
/*  50 */   private List<ItemMetaData> items = new ArrayList();
/*     */ 
/*     */   public CompositeTypeMetaData(Class<?> clazz)
/*     */   {
/*  59 */     this.clazz = clazz;
/*     */   }
/*     */ 
/*     */   public CompositeType getCompositeType()
/*     */   {
/*  69 */     if (this.compositeType == null)
/*     */     {
/*  71 */       String typeName = this.clazz.getName();
/*  72 */       if (this.items.size() == 0) {
/*  73 */         return generateAnObject(typeName);
/*     */       }
/*  75 */       String[] itemNames = new String[this.items.size()];
/*  76 */       OpenType[] itemTypes = new OpenType[this.items.size()];
/*  77 */       for (int i = 0; i < this.items.size(); i++)
/*     */       {
/*  79 */         ItemMetaData item = (ItemMetaData)this.items.get(i);
/*  80 */         itemNames[i] = item.getName();
/*  81 */         itemTypes[i] = item.getOpenType();
/*     */       }
/*     */       try
/*     */       {
/*  85 */         this.compositeType = new CompositeType(typeName, typeName, itemNames, itemNames, itemTypes);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  89 */         throw new UnexpectedThrowable("Error creating composite type for: " + typeName, t);
/*     */       }
/*     */     }
/*  92 */     return this.compositeType;
/*     */   }
/*     */ 
/*     */   public void generate()
/*     */   {
/* 100 */     if (Object.class.equals(this.clazz))
/*     */     {
/* 102 */       this.compositeType = generateObject();
/* 103 */       return;
/*     */     }
/* 105 */     if (Class.class.equals(this.clazz))
/*     */     {
/* 107 */       this.compositeType = generateClass();
/* 108 */       return;
/*     */     }
/* 110 */     if (ClassLoader.class.equals(this.clazz))
/*     */     {
/* 112 */       this.compositeType = generateClassLoader();
/* 113 */       return;
/*     */     }
/*     */ 
/* 116 */     Method[] methods = this.clazz.getMethods();
/* 117 */     for (Method method : methods)
/*     */     {
/* 119 */       Type returnType = method.getGenericReturnType();
/* 120 */       Class declaring = method.getDeclaringClass();
/* 121 */       if (Object.class.equals(declaring))
/*     */         continue;
/* 123 */       String key = MXBeanUtils.getCompositeDataKey(method);
/* 124 */       if (key != null)
/* 125 */         this.items.add(new ItemMetaData(key, returnType));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static CompositeType generateObject()
/*     */   {
/* 137 */     return generateAnObject(Object.class.getName());
/*     */   }
/*     */ 
/*     */   private static CompositeType generateAnObject(String name)
/*     */   {
/* 148 */     String[] itemNames = { "class" };
/* 149 */     OpenType[] openTypes = { generateClass() };
/* 150 */     return safeCreateCompositeType(name, itemNames, openTypes);
/*     */   }
/*     */ 
/*     */   public static CompositeType generateClass()
/*     */   {
/* 160 */     String name = Object.class.getName();
/* 161 */     String[] itemNames = { "name" };
/* 162 */     OpenType[] openTypes = { SimpleType.STRING };
/* 163 */     return safeCreateCompositeType(name, itemNames, openTypes);
/*     */   }
/*     */ 
/*     */   public static CompositeType generateClassLoader()
/*     */   {
/* 173 */     String name = Object.class.getName();
/* 174 */     String[] itemNames = { "name" };
/* 175 */     OpenType[] openTypes = { SimpleType.STRING };
/* 176 */     return safeCreateCompositeType(name, itemNames, openTypes);
/*     */   }
/*     */ 
/*     */   private static CompositeType safeCreateCompositeType(String name, String[] itemNames, OpenType[] openTypes)
/*     */   {
/*     */     try
/*     */     {
/* 191 */       return new CompositeType(name, name, itemNames, itemNames, openTypes);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 195 */     throw new UnexpectedThrowable(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.CompositeTypeMetaData
 * JD-Core Version:    0.6.0
 */