/*     */ package org.jboss.mx.modelmbean;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationBroadcaster;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import javax.management.StandardMBean;
/*     */ import javax.management.modelmbean.InvalidTargetObjectTypeException;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanConstructorInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*     */ import javax.management.modelmbean.ModelMBeanNotificationInfo;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import org.dom4j.io.DOMReader;
/*     */ import org.jboss.mx.interceptor.StandardMBeanInfoInterceptor;
/*     */ import org.jboss.mx.metadata.MBeanInfoConversion;
/*     */ import org.jboss.mx.metadata.MetaDataBuilder;
/*     */ import org.jboss.mx.metadata.StandardMetaData;
/*     */ import org.jboss.mx.metadata.XMLMetaData;
/*     */ import org.jboss.mx.server.InvocationContext;
/*     */ 
/*     */ public class XMBean extends ModelMBeanInvoker
/*     */   implements XMBeanConstants, NotificationListener
/*     */ {
/*     */   public XMBean()
/*     */     throws MBeanException
/*     */   {
/*     */     try
/*     */     {
/*  85 */       setManagedResource(new Object(), "ObjectReference");
/*  86 */       setModelMBeanInfo(new ModelMBeanInfoSupport("XMBean", "Uninitialized XMBean", new ModelMBeanAttributeInfo[0], new ModelMBeanConstructorInfo[0], new ModelMBeanOperationInfo[0], new ModelMBeanNotificationInfo[0]));
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  91 */       throw new RuntimeOperationsException(e);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  95 */       throw new MBeanException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public XMBean(ModelMBeanInfo info)
/*     */     throws MBeanException
/*     */   {
/* 107 */     super(info);
/*     */   }
/*     */ 
/*     */   public XMBean(Object resource, String resourceType)
/*     */     throws MBeanException, NotCompliantMBeanException
/*     */   {
/* 162 */     ModelMBeanInfo minfo = null;
/*     */     try
/*     */     {
/* 165 */       HashMap properties = new HashMap();
/*     */ 
/* 167 */       if (resourceType.equals("descriptor"))
/*     */       {
/* 169 */         Descriptor d = (Descriptor)resource;
/*     */ 
/* 172 */         resourceType = (String)d.getFieldValue("xmbean.resource.type");
/*     */ 
/* 175 */         resource = d.getFieldValue("xmbean.resource.reference");
/*     */ 
/* 178 */         String[] fields = d.getFieldNames();
/*     */ 
/* 180 */         for (int i = 0; i < fields.length; i++)
/*     */         {
/* 184 */           if (fields[i].startsWith("xmbean.metadata.")) {
/* 185 */             properties.put(fields[i], d.getFieldValue(fields[i]));
/*     */           }
/*     */         }
/*     */       }
/* 189 */       if ((resourceType.equals("StandardMBean")) && ((resource instanceof StandardMBean)))
/* 190 */         setManagedResource(((StandardMBean)resource).getImplementation(), resourceType);
/*     */       else {
/* 192 */         setManagedResource(resource, resourceType);
/*     */       }
/*     */ 
/* 196 */       boolean CREATE_ATTRIBUTE_OPERATION_MAPPING = true;
/*     */ 
/* 199 */       if ((resourceType.equals("StandardMBean")) && ((resource instanceof StandardMBean)))
/*     */       {
/* 202 */         StandardMBean standardMBean = (StandardMBean)resource;
/* 203 */         minfo = MBeanInfoConversion.toModelMBeanInfo(standardMBean.getMBeanInfo(), true);
/*     */       }
/* 208 */       else if ((resourceType.equals("StandardInterface")) || (resourceType.equals("StandardMBean")))
/*     */       {
/* 211 */         this.dynamicResource = false;
/*     */ 
/* 214 */         MetaDataBuilder builder = new StandardMetaData(resource);
/*     */ 
/* 217 */         for (Iterator it = properties.keySet().iterator(); it.hasNext(); )
/*     */         {
/* 219 */           String key = (String)it.next();
/* 220 */           builder.setProperty(key, properties.get(key));
/*     */         }
/*     */ 
/* 224 */         MBeanInfo standardInfo = builder.build();
/*     */ 
/* 229 */         minfo = MBeanInfoConversion.toModelMBeanInfo(standardInfo, true);
/*     */       }
/* 234 */       else if (resourceType.endsWith(".xml"))
/*     */       {
/* 240 */         MetaDataBuilder builder = new XMLMetaData(getClass().getName(), resource.getClass().getName(), resourceType);
/*     */ 
/* 247 */         for (Iterator it = properties.keySet().iterator(); it.hasNext(); )
/*     */         {
/* 249 */           String key = (String)it.next();
/* 250 */           builder.setProperty(key, properties.get(key));
/*     */         }
/*     */ 
/* 253 */         minfo = (ModelMBeanInfo)builder.build();
/*     */       }
/*     */ 
/* 256 */       setModelMBeanInfo(minfo);
/*     */ 
/* 260 */       load();
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 264 */       throw new MBeanException(e);
/*     */     }
/*     */     catch (InvalidTargetObjectTypeException e)
/*     */     {
/* 268 */       if (resourceType.endsWith(".xml")) {
/* 269 */         throw new MBeanException(e, "Malformed URL: " + resourceType);
/*     */       }
/* 271 */       throw new MBeanException(e, "Unsupported resource type: " + resourceType);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 275 */       throw new MBeanException(e, "Malformed URL: " + resourceType);
/*     */     }
/*     */   }
/*     */ 
/*     */   public XMBean(Object resource, URL interfaceURL)
/*     */     throws MBeanException, NotCompliantMBeanException
/*     */   {
/* 282 */     this(resource, interfaceURL.toString());
/*     */   }
/*     */ 
/*     */   public XMBean(Descriptor descriptor)
/*     */     throws MBeanException, NotCompliantMBeanException
/*     */   {
/* 288 */     this(descriptor, "descriptor");
/*     */   }
/*     */ 
/*     */   public XMBean(Object resource, org.w3c.dom.Element element, String version) throws MBeanException, NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 295 */       DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
/* 296 */       org.w3c.dom.Document doc = builder.newDocument();
/* 297 */       doc.appendChild(doc.importNode(element, true));
/*     */ 
/* 299 */       DOMReader domReader = new DOMReader();
/* 300 */       org.dom4j.Document dom4jDoc = domReader.read(doc);
/* 301 */       org.dom4j.Element dom4jElem = dom4jDoc.getRootElement();
/* 302 */       dom4jElem.detach();
/* 303 */       createXMBean(resource, dom4jElem, version);
/*     */     }
/*     */     catch (ParserConfigurationException e)
/*     */     {
/* 307 */       throw new MBeanException(e, "Could not convert w3c Element to dom4j Element.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public XMBean(Object resource, org.dom4j.Element element, String version)
/*     */     throws MBeanException, NotCompliantMBeanException
/*     */   {
/* 315 */     createXMBean(resource, element, version);
/*     */   }
/*     */ 
/*     */   private void createXMBean(Object resource, org.dom4j.Element element, String version)
/*     */     throws MBeanException, NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 324 */       setManagedResource(resource, "ObjectReference");
/* 325 */       MetaDataBuilder builder = new XMLMetaData(getClass().getName(), resource.getClass().getName(), element, version);
/*     */ 
/* 332 */       ModelMBeanInfo minfo = (ModelMBeanInfo)builder.build();
/* 333 */       setModelMBeanInfo(minfo);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 337 */       throw new MBeanException(e);
/*     */     }
/*     */     catch (InvalidTargetObjectTypeException e)
/*     */     {
/* 341 */       throw new MBeanException(e, "Unsupported resource type: " + this.resourceType);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isSupportedResourceType(Object resource, String resourceType)
/*     */   {
/* 351 */     if (resourceType == null) {
/* 352 */       return false;
/*     */     }
/* 354 */     if (resourceType.equalsIgnoreCase("ObjectReference"))
/* 355 */       return true;
/* 356 */     if (resourceType.equalsIgnoreCase("StandardInterface"))
/* 357 */       return true;
/* 358 */     if (resourceType.equalsIgnoreCase("StandardMBean"))
/* 359 */       return true;
/* 360 */     if (resourceType.equalsIgnoreCase("descriptor"))
/*     */     {
/* 362 */       if ((resource == null) || (!(resource instanceof Descriptor))) {
/* 363 */         return false;
/*     */       }
/* 365 */       Descriptor d = (Descriptor)resource;
/*     */ 
/* 367 */       if (d.getFieldValue("xmbean.resource.reference") == null) {
/* 368 */         return false;
/*     */       }
/*     */ 
/* 371 */       return d.getFieldValue("xmbean.resource.type") != null;
/*     */     }
/*     */ 
/* 375 */     if (resourceType.endsWith(".xml"))
/*     */     {
/*     */       try
/*     */       {
/* 379 */         new URL(resourceType);
/* 380 */         return true;
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 384 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 388 */     return false;
/*     */   }
/*     */ 
/*     */   protected void configureInterceptorStack(ModelMBeanInfo info, MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 400 */     super.configureInterceptorStack(info, server, name);
/*     */ 
/* 402 */     if (this.resourceType.equals("StandardMBean"))
/*     */     {
/* 404 */       List interceptors = this.getMBeanInfoCtx.getInterceptors();
/* 405 */       interceptors.add(0, new StandardMBeanInfoInterceptor());
/* 406 */       this.getMBeanInfoCtx.setInterceptors(interceptors);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/* 418 */     if (this.resourceType.equals("StandardMBean"))
/*     */     {
/* 420 */       addNotificationListenerToResource(listener, filter, handback);
/*     */     }
/*     */     else
/*     */     {
/* 426 */       super.addNotificationListener(listener, filter, handback);
/*     */ 
/* 429 */       if ((getResource() instanceof NotificationBroadcaster))
/* 430 */         addNotificationListenerToResource(listener, filter, handback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 438 */     if (this.resourceType.equals("StandardMBean"))
/*     */     {
/* 440 */       removeNotificationListenerFromResource(listener);
/*     */     }
/*     */     else
/*     */     {
/* 446 */       super.removeNotificationListener(listener);
/*     */ 
/* 449 */       if ((getResource() instanceof NotificationBroadcaster))
/* 450 */         removeNotificationListenerFromResource(listener);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 460 */     if (this.resourceType.equals("StandardMBean"))
/*     */     {
/* 462 */       removeNotificationListenerFromResource(listener, filter, handback);
/*     */     }
/*     */     else
/*     */     {
/* 468 */       super.removeNotificationListener(listener, filter, handback);
/*     */ 
/* 471 */       if ((getResource() instanceof NotificationBroadcaster))
/* 472 */         removeNotificationListenerFromResource(listener, filter, handback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 478 */     if (this.resourceType.equals("StandardMBean")) {
/* 479 */       return getNotificationInfoFromResource();
/*     */     }
/* 481 */     return super.getNotificationInfo();
/*     */   }
/*     */ 
/*     */   public void handleNotification(Notification notification, Object handback)
/*     */   {
/* 497 */     Object resource = getResource();
/*     */ 
/* 499 */     if ((resource instanceof NotificationListener))
/* 500 */       ((NotificationListener)resource).handleNotification(notification, handback);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.modelmbean.XMBean
 * JD-Core Version:    0.6.0
 */