/*    */ package org.jboss.mx.modelmbean;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import javax.management.modelmbean.ModelMBean;
/*    */ import javax.management.modelmbean.ModelMBeanInfo;
/*    */ import org.jboss.mx.util.PropertyAccess;
/*    */ 
/*    */ public class RequiredModelMBeanInstantiator
/*    */ {
/*    */   public static ModelMBean instantiate()
/*    */   {
/* 47 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 48 */     String className = getClassName();
/*    */     try
/*    */     {
/* 51 */       Class modelMBean = cl.loadClass(className);
/* 52 */       return (ModelMBean)modelMBean.newInstance();
/*    */     }
/*    */     catch (ClassNotFoundException e)
/*    */     {
/* 56 */       throw new Error("Cannot instantiate model mbean class. Class " + className + " not found.");
/*    */     }
/*    */     catch (ClassCastException e)
/*    */     {
/* 60 */       throw new Error("Cannot instantiate model mbean class. The target class is not an instance of ModelMBean interface.");
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 64 */     throw new Error("Cannot instantiate model mbean class " + className + " with default constructor: " + e.getMessage());
/*    */   }
/*    */ 
/*    */   public static ModelMBean instantiate(ModelMBeanInfo info)
/*    */   {
/* 70 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 71 */     String className = getClassName();
/*    */     try
/*    */     {
/* 74 */       Class modelMBean = cl.loadClass(className);
/* 75 */       Constructor constructor = modelMBean.getConstructor(new Class[] { ModelMBeanInfo.class });
/* 76 */       return (ModelMBean)constructor.newInstance(new Object[] { info });
/*    */     }
/*    */     catch (ClassNotFoundException e)
/*    */     {
/* 80 */       throw new Error("Cannot instantiate model mbean class. Class " + className + " not found.");
/*    */     }
/*    */     catch (ClassCastException e)
/*    */     {
/* 84 */       throw new Error("Cannot instantiate model mbean class. The target class is not an instance of ModelMBean interface.");
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 88 */     throw new Error("Cannot instantiate model mbean class " + className + ": " + e.toString());
/*    */   }
/*    */ 
/*    */   public static String getClassName()
/*    */   {
/* 94 */     return PropertyAccess.getProperty("jbossmx.required.modelmbean.class", "org.jboss.mx.modelmbean.XMBean");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator
 * JD-Core Version:    0.6.0
 */