/*     */ package org.jboss.mx.metadata.xb;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ 
/*     */ public class ModelMBeanOperationInfoContainer
/*     */   implements GenericValueContainer
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(ModelMBeanOperationInfoContainer.class);
/*     */   private String name;
/*  47 */   private String returnType = "void";
/*     */   private String impact;
/*     */   private String description;
/*  50 */   private ArrayList params = new ArrayList();
/*     */   private Descriptor descriptor;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  55 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  60 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getReturnType()
/*     */   {
/*  65 */     return this.returnType;
/*     */   }
/*     */ 
/*     */   public void setReturnType(String returnType)
/*     */   {
/*  70 */     this.returnType = returnType;
/*     */   }
/*     */ 
/*     */   public String getImpact()
/*     */   {
/*  75 */     return this.impact;
/*     */   }
/*     */ 
/*     */   public void setImpact(String impact)
/*     */   {
/*  80 */     this.impact = impact;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/*  85 */     return this.description;
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/*  90 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public Descriptor getDescriptors()
/*     */   {
/*  95 */     return this.descriptor;
/*     */   }
/*     */ 
/*     */   public void setDescriptors(Descriptor descriptor) {
/*  99 */     this.descriptor = descriptor;
/*     */   }
/*     */ 
/*     */   public void addParameter(MBeanParameterInfo param)
/*     */   {
/* 104 */     this.params.add(param);
/*     */   }
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/* 109 */     MBeanParameterInfo[] sig = new MBeanParameterInfo[this.params.size()];
/* 110 */     this.params.toArray(sig);
/* 111 */     if (this.descriptor != null)
/*     */     {
/* 113 */       if (this.descriptor.getFieldValue("name") == null)
/* 114 */         this.descriptor.setField("name", this.name);
/* 115 */       if (this.descriptor.getFieldValue("descriptorType") == null)
/* 116 */         this.descriptor.setField("descriptorType", "operation");
/* 117 */       if (this.descriptor.getFieldValue("role") == null)
/* 118 */         this.descriptor.setField("role", "operation");
/*     */     }
/* 120 */     int operImpact = 2;
/*     */ 
/* 122 */     if (this.impact != null)
/*     */     {
/* 124 */       if (this.impact.equals("INFO"))
/* 125 */         operImpact = 0;
/* 126 */       else if (this.impact.equals("ACTION"))
/* 127 */         operImpact = 1;
/* 128 */       else if (this.impact.equals("ACTION_INFO")) {
/* 129 */         operImpact = 2;
/*     */       }
/*     */     }
/* 132 */     ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(this.name, this.description, sig, this.returnType, operImpact, this.descriptor);
/*     */ 
/* 134 */     return info;
/*     */   }
/*     */ 
/*     */   public void addChild(QName name, Object value) {
/* 138 */     log.debug("addChild, " + name + "," + value);
/* 139 */     if ("name".equals(name.getLocalPart()))
/*     */     {
/* 141 */       this.name = ((String)value);
/*     */     }
/* 143 */     if ("description".equals(name.getLocalPart()))
/*     */     {
/* 145 */       this.description = ((String)value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getTargetClass() {
/* 150 */     return ModelMBeanOperationInfo.class;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.ModelMBeanOperationInfoContainer
 * JD-Core Version:    0.6.0
 */