/*    */ package org.jboss.mx.metadata.xb;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import javax.management.Descriptor;
/*    */ import javax.management.modelmbean.ModelMBeanNotificationInfo;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.xb.binding.GenericValueContainer;
/*    */ 
/*    */ public class ModelMBeanNotificationInfoContainer
/*    */   implements GenericValueContainer
/*    */ {
/* 43 */   private static final Logger log = Logger.getLogger(ModelMBeanNotificationInfoContainer.class);
/*    */   private String name;
/* 45 */   private ArrayList types = new ArrayList();
/*    */   private String description;
/*    */   private Descriptor descriptor;
/*    */ 
/*    */   public Descriptor getDescriptors()
/*    */   {
/* 51 */     return this.descriptor;
/*    */   }
/*    */ 
/*    */   public void setDescriptors(Descriptor descriptor) {
/* 55 */     this.descriptor = descriptor;
/*    */   }
/*    */ 
/*    */   public void addType(String type)
/*    */   {
/* 60 */     this.types.add(type);
/*    */   }
/*    */ 
/*    */   public Object instantiate() {
/* 64 */     if (this.descriptor != null)
/*    */     {
/* 66 */       if (this.descriptor.getFieldValue("name") == null)
/*    */       {
/* 68 */         this.descriptor.setField("name", this.name);
/*    */       }
/* 70 */       if (this.descriptor.getFieldValue("descriptorType") == null)
/*    */       {
/* 72 */         this.descriptor.setField("descriptorType", "notification");
/*    */       }
/*    */     }
/*    */ 
/* 76 */     String[] ntypes = new String[this.types.size()];
/* 77 */     this.types.toArray(ntypes);
/* 78 */     ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo(ntypes, this.name, this.description, this.descriptor);
/*    */ 
/* 80 */     return info;
/*    */   }
/*    */ 
/*    */   public void addChild(QName name, Object value)
/*    */   {
/* 85 */     log.debug("addChild, " + name + "," + value);
/* 86 */     if ("name".equals(name.getLocalPart()))
/*    */     {
/* 88 */       this.name = ((String)value);
/*    */     }
/* 90 */     if ("description".equals(name.getLocalPart()))
/*    */     {
/* 92 */       this.description = ((String)value);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Class getTargetClass() {
/* 97 */     return ModelMBeanNotificationInfo.class;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.ModelMBeanNotificationInfoContainer
 * JD-Core Version:    0.6.0
 */