/*     */ package org.jboss.mx.metadata.xb;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanConstructorInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*     */ import javax.management.modelmbean.ModelMBeanNotificationInfo;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ModelMBeanInfoSupportWrapper
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ModelMBeanInfoSupportWrapper.class);
/*  45 */   private String mmbClassName = "org.jboss.mx.modelmbean.XMBean";
/*     */   private String description;
/*  48 */   private ArrayList operInfo = new ArrayList();
/*  49 */   private ArrayList attrInfo = new ArrayList();
/*  50 */   private ArrayList constrInfo = new ArrayList();
/*  51 */   private ArrayList notifInfo = new ArrayList();
/*     */   private Descriptor descriptor;
/*     */ 
/*     */   public String getClassName()
/*     */   {
/*  56 */     return this.mmbClassName;
/*     */   }
/*     */ 
/*     */   public void setClassName(String mmbClassName)
/*     */   {
/*  61 */     this.mmbClassName = mmbClassName;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/*  66 */     return this.description;
/*     */   }
/*     */ 
/*     */   public void setDescription(String description) {
/*  70 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public Descriptor getDescriptors() {
/*  74 */     return this.descriptor;
/*     */   }
/*     */ 
/*     */   public void setDescriptors(Descriptor descriptor) {
/*  78 */     this.descriptor = descriptor;
/*     */   }
/*     */ 
/*     */   public void addConstructor(ModelMBeanConstructorInfo info)
/*     */   {
/*  83 */     this.constrInfo.add(info);
/*     */   }
/*     */ 
/*     */   public void addAttribute(ModelMBeanAttributeInfo info) {
/*  87 */     this.attrInfo.add(info);
/*     */   }
/*     */ 
/*     */   public void addOperation(ModelMBeanOperationInfo info) {
/*  91 */     this.operInfo.add(info);
/*     */   }
/*     */ 
/*     */   public void addNotification(ModelMBeanNotificationInfo info) {
/*  95 */     this.notifInfo.add(info);
/*     */   }
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/* 100 */     ModelMBeanOperationInfo[] ops = new ModelMBeanOperationInfo[this.operInfo.size()];
/* 101 */     this.operInfo.toArray(ops);
/* 102 */     ModelMBeanAttributeInfo[] attrs = new ModelMBeanAttributeInfo[this.attrInfo.size()];
/* 103 */     this.attrInfo.toArray(attrs);
/* 104 */     ModelMBeanConstructorInfo[] ctors = new ModelMBeanConstructorInfo[this.constrInfo.size()];
/* 105 */     this.constrInfo.toArray(ctors);
/* 106 */     ModelMBeanNotificationInfo[] msgs = new ModelMBeanNotificationInfo[this.notifInfo.size()];
/* 107 */     this.notifInfo.toArray(msgs);
/*     */ 
/* 109 */     if (this.descriptor != null)
/*     */     {
/* 111 */       if (this.descriptor.getFieldValue("name") == null)
/* 112 */         this.descriptor.setField("name", getClassName());
/* 113 */       if (this.descriptor.getFieldValue("descriptorType") == null)
/* 114 */         this.descriptor.setField("descriptorType", "mbean");
/*     */     }
/* 116 */     ModelMBeanInfo info = new ModelMBeanInfoSupport(this.mmbClassName, this.description, attrs, ctors, ops, msgs, this.descriptor);
/*     */ 
/* 119 */     return info;
/*     */   }
/*     */ 
/*     */   public ModelMBeanInfo getMBeanInfo()
/*     */   {
/* 124 */     return (ModelMBeanInfo)instantiate();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.ModelMBeanInfoSupportWrapper
 * JD-Core Version:    0.6.0
 */