/*    */ package org.jboss.mx.metadata.xb;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import javax.management.Descriptor;
/*    */ import javax.management.MBeanParameterInfo;
/*    */ import javax.management.modelmbean.ModelMBeanConstructorInfo;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.xb.binding.GenericValueContainer;
/*    */ 
/*    */ public class ModelMBeanConstructorInfoContainer
/*    */   implements GenericValueContainer
/*    */ {
/* 43 */   private static final Logger log = Logger.getLogger(ModelMBeanConstructorInfoContainer.class);
/*    */   private String name;
/*    */   private String description;
/* 46 */   private ArrayList params = new ArrayList();
/*    */   private Descriptor descriptor;
/*    */ 
/*    */   public Descriptor getDescriptors()
/*    */   {
/* 51 */     return this.descriptor;
/*    */   }
/*    */ 
/*    */   public void setDescriptors(Descriptor descriptor) {
/* 55 */     this.descriptor = descriptor;
/*    */   }
/*    */ 
/*    */   public void addParameter(MBeanParameterInfo param)
/*    */   {
/* 60 */     this.params.add(param);
/*    */   }
/*    */ 
/*    */   public Object instantiate()
/*    */   {
/* 65 */     MBeanParameterInfo[] sig = new MBeanParameterInfo[this.params.size()];
/* 66 */     this.params.toArray(sig);
/* 67 */     if (this.descriptor != null)
/*    */     {
/* 69 */       if (this.descriptor.getFieldValue("name") == null)
/* 70 */         this.descriptor.setField("name", ModelMBeanConstructorInfo.class.getName());
/* 71 */       if (this.descriptor.getFieldValue("descriptorType") == null)
/* 72 */         this.descriptor.setField("descriptorType", "constructor");
/*    */     }
/* 74 */     ModelMBeanConstructorInfo ctor = new ModelMBeanConstructorInfo(this.name, this.description, sig, this.descriptor);
/*    */ 
/* 76 */     return ctor;
/*    */   }
/*    */ 
/*    */   public void addChild(QName name, Object value) {
/* 80 */     log.debug("addChild, " + name + "," + value);
/* 81 */     if ("name".equals(name.getLocalPart()))
/*    */     {
/* 83 */       this.name = ((String)value);
/*    */     }
/* 85 */     if ("description".equals(name.getLocalPart()))
/*    */     {
/* 87 */       this.description = ((String)value);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Class getTargetClass() {
/* 92 */     return ModelMBeanConstructorInfo.class;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.ModelMBeanConstructorInfoContainer
 * JD-Core Version:    0.6.0
 */