/*     */ package org.jboss.mx.metadata.xb;
/*     */ 
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.modelmbean.DescriptorSupport;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ 
/*     */ public class ModelMBeanAttributeInfoContainer
/*     */   implements GenericValueContainer
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ModelMBeanAttributeInfoContainer.class);
/*     */   private String name;
/*     */   private String type;
/*     */   private String access;
/*     */   private String getMethod;
/*     */   private String setMethod;
/*     */   private String description;
/*     */   private Object value;
/*     */   private Object defaultValue;
/*     */   private Descriptor descriptor;
/*     */ 
/*     */   public Object getValue()
/*     */   {
/*  57 */     return this.value;
/*     */   }
/*     */ 
/*     */   public void setValue(Object value)
/*     */   {
/*  62 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public Object getDefaultValue()
/*     */   {
/*  67 */     return this.defaultValue;
/*     */   }
/*     */ 
/*     */   public void setDefaultValue(Object defaultValue)
/*     */   {
/*  72 */     this.defaultValue = defaultValue;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/*  77 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/*  82 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public String getAccess()
/*     */   {
/*  87 */     return this.access;
/*     */   }
/*     */ 
/*     */   public void setAccess(String access)
/*     */   {
/*  92 */     this.access = access;
/*     */   }
/*     */ 
/*     */   public String getGetMethod()
/*     */   {
/*  97 */     return this.getMethod;
/*     */   }
/*     */ 
/*     */   public void setGetMethod(String getMethod)
/*     */   {
/* 102 */     this.getMethod = getMethod;
/*     */   }
/*     */ 
/*     */   public String getSetMethod()
/*     */   {
/* 107 */     return this.setMethod;
/*     */   }
/*     */ 
/*     */   public void setSetMethod(String setMethod)
/*     */   {
/* 112 */     this.setMethod = setMethod;
/*     */   }
/*     */ 
/*     */   public Descriptor getDescriptors()
/*     */   {
/* 117 */     return this.descriptor;
/*     */   }
/*     */ 
/*     */   public void setDescriptors(Descriptor descriptor) {
/* 121 */     this.descriptor = descriptor;
/*     */   }
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/*     */     try
/*     */     {
/* 128 */       ModelMBeanAttributeInfo info = buildAttributeInfo();
/* 129 */       return info;
/*     */     }
/*     */     catch (NotCompliantMBeanException e) {
/*     */     }
/* 133 */     throw new JBossXBRuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void addChild(QName name, Object value)
/*     */   {
/* 139 */     log.debug("addChild, " + name + "," + value);
/* 140 */     String localName = name.getLocalPart();
/* 141 */     if ("name".equals(localName))
/*     */     {
/* 143 */       this.name = ((String)value);
/*     */     }
/* 145 */     if ("type".equals(localName))
/*     */     {
/* 147 */       this.type = ((String)value);
/*     */     }
/* 149 */     if ("access".equals(localName))
/*     */     {
/* 151 */       this.access = ((String)value);
/*     */     }
/* 153 */     if ("getMethod".equals(localName))
/*     */     {
/* 155 */       this.getMethod = ((String)value);
/*     */     }
/* 157 */     if ("setMethod".equals(localName))
/*     */     {
/* 159 */       this.setMethod = ((String)value);
/*     */     }
/* 161 */     if ("value".equals(localName))
/*     */     {
/* 163 */       this.value = value;
/*     */     }
/* 165 */     if ("default".equals(localName))
/*     */     {
/* 167 */       this.defaultValue = value;
/*     */     }
/* 169 */     if ("description".equals(localName))
/*     */     {
/* 171 */       this.description = ((String)value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getTargetClass() {
/* 176 */     return ModelMBeanAttributeInfo.class;
/*     */   }
/*     */ 
/*     */   protected ModelMBeanAttributeInfo buildAttributeInfo()
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 182 */     if (this.descriptor == null)
/*     */     {
/* 184 */       this.descriptor = new DescriptorSupport();
/*     */     }
/* 186 */     if (this.descriptor.getFieldValue("name") == null)
/*     */     {
/* 188 */       this.descriptor.setField("name", this.name);
/*     */     }
/* 190 */     if (this.descriptor.getFieldValue("descriptorType") == null)
/*     */     {
/* 192 */       this.descriptor.setField("descriptorType", "attribute");
/*     */     }
/*     */ 
/* 195 */     if (this.value != null)
/*     */     {
/* 197 */       this.descriptor.setField("value", this.value);
/*     */     }
/* 199 */     if (this.defaultValue != null)
/*     */     {
/* 201 */       this.descriptor.setField("default", this.defaultValue);
/*     */     }
/*     */ 
/* 204 */     if (this.getMethod != null)
/*     */     {
/* 206 */       this.descriptor.setField("getMethod", this.getMethod);
/*     */     }
/* 208 */     if (this.setMethod != null)
/*     */     {
/* 210 */       this.descriptor.setField("setMethod", this.setMethod);
/*     */     }
/*     */ 
/* 214 */     boolean isReadable = true;
/* 215 */     boolean isWritable = true;
/* 216 */     if (this.access.equalsIgnoreCase("read-only"))
/*     */     {
/* 218 */       isWritable = false;
/*     */     }
/* 220 */     else if (this.access.equalsIgnoreCase("write-only"))
/*     */     {
/* 222 */       isReadable = false;
/*     */     }
/*     */ 
/* 225 */     ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(this.name, this.type, this.description, isReadable, isWritable, false, this.descriptor);
/*     */ 
/* 228 */     return info;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.ModelMBeanAttributeInfoContainer
 * JD-Core Version:    0.6.0
 */