/*    */ package org.jboss.mx.metadata.xb;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.mx.interceptor.Interceptor;
/*    */ import org.jboss.util.NestedRuntimeException;
/*    */ import org.jboss.xb.binding.GenericValueContainer;
/*    */ 
/*    */ public class InterceptorHolder
/*    */   implements GenericValueContainer
/*    */ {
/*    */   private Class clazz;
/*    */ 
/*    */   public void addChild(QName name, Object value)
/*    */   {
/* 43 */     String lname = name.getLocalPart();
/* 44 */     if (lname.equals("code"))
/*    */     {
/* 46 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 47 */       String cname = (String)value;
/*    */       try
/*    */       {
/* 50 */         this.clazz = loader.loadClass(cname);
/*    */       }
/*    */       catch (Throwable e)
/*    */       {
/* 54 */         throw new NestedRuntimeException("Unable to load code: " + cname, e);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object instantiate()
/*    */   {
/*    */     Interceptor i;
/*    */     try
/*    */     {
/* 65 */       i = (Interceptor)this.clazz.newInstance();
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 69 */       throw new NestedRuntimeException("Failed to instantiate interceptor", e);
/*    */     }
/* 71 */     return i;
/*    */   }
/*    */ 
/*    */   public Class getTargetClass()
/*    */   {
/* 76 */     return Interceptor.class;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.InterceptorHolder
 * JD-Core Version:    0.6.0
 */