/*     */ package org.jboss.mx.metadata.xb;
/*     */ 
/*     */ import javax.management.modelmbean.DescriptorSupport;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.interceptor.Interceptor;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ 
/*     */ public class DescriptorSupportContainer
/*     */   implements GenericValueContainer
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(DescriptorSupportContainer.class);
/*  41 */   DescriptorSupport support = new DescriptorSupport();
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/*  45 */     return this.support;
/*     */   }
/*     */ 
/*     */   public void addChild(QName name, Object value)
/*     */   {
/*  50 */     log.debug("addChild, " + name + "," + value);
/*  51 */     String localName = name.getLocalPart();
/*  52 */     if ("name".equals(localName))
/*     */     {
/*  54 */       this.support.setField("name", value);
/*     */     }
/*  56 */     else if (name.equals("persistence"))
/*     */     {
/*  58 */       PersistPolicy policy = (PersistPolicy)value;
/*  59 */       String persistPolicy = policy.getPersistPolicy();
/*  60 */       String persistPeriod = policy.getPersistPeriod();
/*  61 */       String persistLocation = policy.getPersistLocation();
/*  62 */       String persistName = policy.getPersistName();
/*  63 */       if (persistPolicy != null)
/*     */       {
/*  66 */         this.support.setField("persistPolicy", persistPolicy);
/*     */       }
/*  68 */       if (persistPeriod != null)
/*     */       {
/*  70 */         this.support.setField("persistPeriod", persistPeriod);
/*     */       }
/*  72 */       if (persistLocation != null)
/*     */       {
/*  74 */         this.support.setField("persistLocation", persistLocation);
/*     */       }
/*  76 */       if (persistName != null)
/*     */       {
/*  78 */         this.support.setField("persistName", persistName);
/*     */       }
/*     */     }
/*  81 */     else if (name.equals("currencyTimeLimit"))
/*     */     {
/*  83 */       this.support.setField("currencyTimeLimit", value);
/*     */     }
/*  85 */     else if (name.equals("default"))
/*     */     {
/*  87 */       this.support.setField("default", value);
/*     */     }
/*  89 */     else if (name.equals("display-name"))
/*     */     {
/*  91 */       this.support.setField("displayName", value);
/*     */     }
/*  93 */     else if (name.equals("value"))
/*     */     {
/*  95 */       this.support.setField("value", value);
/*     */     }
/*  97 */     else if (name.equals("persistence-manager"))
/*     */     {
/*  99 */       this.support.setField("persistence-manager", value);
/*     */     }
/* 101 */     else if (name.equals("descriptor"))
/*     */     {
/* 103 */       Holder desc = (Holder)value;
/* 104 */       this.support.setField(desc.getName(), desc.getValue());
/*     */     }
/* 106 */     else if (name.equals("injection"))
/*     */     {
/* 108 */       Holder desc = (Holder)value;
/* 109 */       this.support.setField(desc.getName(), desc.getValue());
/*     */     }
/* 111 */     else if ("interceptors".equals(localName))
/*     */     {
/* 113 */       InterceptorsHolder holder = (InterceptorsHolder)value;
/*     */ 
/* 118 */       Interceptor[] ivalue = holder.getInterceptors();
/* 119 */       this.support.setField("interceptors", ivalue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getTargetClass()
/*     */   {
/* 125 */     return DescriptorSupport.class;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.xb.DescriptorSupportContainer
 * JD-Core Version:    0.6.0
 */