/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.IntrospectionException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.NotificationBroadcaster;
/*     */ 
/*     */ public class StandardMetaData extends AbstractBuilder
/*     */ {
/*  67 */   private Object mbeanInstance = null;
/*     */ 
/*  72 */   private Class mbeanClass = null;
/*     */ 
/*  77 */   private Class mbeanInterface = null;
/*     */ 
/*     */   public static Class findStandardInterface(Class mbeanClass)
/*     */   {
/*  92 */     Class concrete = mbeanClass;
/*  93 */     Class stdInterface = null;
/*  94 */     while (null != concrete)
/*     */     {
/*  96 */       stdInterface = findStandardInterface(concrete, concrete.getInterfaces());
/*  97 */       if (null != stdInterface)
/*     */       {
/*  99 */         return stdInterface;
/*     */       }
/* 101 */       concrete = concrete.getSuperclass();
/*     */     }
/* 103 */     return null;
/*     */   }
/*     */ 
/*     */   private static Class findStandardInterface(Class concrete, Class[] interfaces)
/*     */   {
/* 108 */     String stdName = concrete.getName() + "MBean";
/* 109 */     Class retval = null;
/*     */ 
/* 112 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 114 */       if (!interfaces[i].getName().equals(stdName))
/*     */         continue;
/* 116 */       retval = interfaces[i];
/* 117 */       break;
/*     */     }
/*     */ 
/* 121 */     return retval;
/*     */   }
/*     */ 
/*     */   public StandardMetaData(Object mbeanInstance)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 135 */     this(mbeanInstance.getClass());
/* 136 */     this.mbeanInstance = mbeanInstance;
/*     */   }
/*     */ 
/*     */   public StandardMetaData(Class mbeanClass)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 148 */     this.mbeanClass = mbeanClass;
/* 149 */     this.mbeanInterface = findStandardInterface(mbeanClass);
/* 150 */     if (this.mbeanInterface == null)
/* 151 */       throw new NotCompliantMBeanException("Cannot obtain management interface for: " + mbeanClass);
/*     */   }
/*     */ 
/*     */   public StandardMetaData(Object mbInstance, Class mbInterface)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 163 */     this.mbeanInstance = mbInstance;
/* 164 */     this.mbeanClass = mbInstance.getClass();
/* 165 */     this.mbeanInterface = mbInterface;
/*     */ 
/* 168 */     if (this.mbeanInterface == null) {
/* 169 */       this.mbeanInterface = findStandardInterface(this.mbeanClass);
/*     */     }
/* 171 */     if (this.mbeanInterface == null)
/* 172 */       throw new NotCompliantMBeanException("Cannot obtain management interface for: " + this.mbeanClass);
/* 173 */     if (!this.mbeanInterface.isInterface())
/* 174 */       throw new NotCompliantMBeanException("Management interface is not an interface: " + this.mbeanInterface);
/*     */   }
/*     */ 
/*     */   public Class getMBeanInterface()
/*     */   {
/* 182 */     return this.mbeanInterface;
/*     */   }
/*     */ 
/*     */   public MBeanInfo build()
/*     */     throws NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 192 */       if (this.mbeanInterface == null)
/* 193 */         throw new NotCompliantMBeanException("The mbean does not implement a management interface");
/* 194 */       if ((this.mbeanInstance != null) && (!this.mbeanInterface.isInstance(this.mbeanInstance))) {
/* 195 */         throw new NotCompliantMBeanException("The mbean does not implement its management interface " + this.mbeanInterface.getName());
/*     */       }
/*     */ 
/* 199 */       Constructor[] constructors = this.mbeanClass.getConstructors();
/* 200 */       MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
/* 201 */       for (int i = 0; i < constructors.length; i++)
/*     */       {
/* 203 */         constructorInfo[i] = new MBeanConstructorInfo("MBean Constructor.", constructors[i]);
/*     */       }
/*     */ 
/* 208 */       Method[] methods = this.mbeanInterface.getMethods();
/* 209 */       HashMap getters = new HashMap();
/* 210 */       HashMap setters = new HashMap();
/*     */ 
/* 212 */       HashMap operInfo = new HashMap();
/* 213 */       List attrInfo = new ArrayList();
/*     */ 
/* 215 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 217 */         String methodName = methods[i].getName();
/* 218 */         Class[] signature = methods[i].getParameterTypes();
/* 219 */         Class returnType = methods[i].getReturnType();
/*     */ 
/* 221 */         if ((methodName.startsWith("set")) && (methodName.length() > 3) && (signature.length == 1) && (returnType == Void.TYPE))
/*     */         {
/* 224 */           String key = methodName.substring(3, methodName.length());
/* 225 */           Method setter = (Method)setters.get(key);
/* 226 */           if ((setter != null) && (!setter.getParameterTypes()[0].equals(signature[0])))
/*     */           {
/* 228 */             throw new IntrospectionException("overloaded type for attribute set: " + key);
/*     */           }
/* 230 */           setters.put(key, methods[i]);
/*     */         }
/* 232 */         else if ((methodName.startsWith("get")) && (methodName.length() > 3) && (signature.length == 0) && (returnType != Void.TYPE))
/*     */         {
/* 235 */           String key = methodName.substring(3, methodName.length());
/* 236 */           Method getter = (Method)getters.get(key);
/* 237 */           if ((getter != null) && (getter.getName().startsWith("is")))
/*     */           {
/* 239 */             throw new IntrospectionException("mixed use of get/is for attribute " + key);
/*     */           }
/* 241 */           getters.put(key, methods[i]);
/*     */         }
/* 243 */         else if ((methodName.startsWith("is")) && (methodName.length() > 2) && (signature.length == 0) && (isBooleanReturn(returnType)))
/*     */         {
/* 246 */           String key = methodName.substring(2, methodName.length());
/* 247 */           Method getter = (Method)getters.get(key);
/* 248 */           if ((getter != null) && (getter.getName().startsWith("get")))
/*     */           {
/* 250 */             throw new IntrospectionException("mixed use of get/is for attribute " + key);
/*     */           }
/* 252 */           getters.put(key, methods[i]);
/*     */         }
/*     */         else
/*     */         {
/* 256 */           MBeanOperationInfo info = new MBeanOperationInfo("MBean Operation.", methods[i]);
/* 257 */           operInfo.put(getSignatureString(methods[i]), info);
/*     */         }
/*     */       }
/*     */ 
/* 261 */       Object[] keys = getters.keySet().toArray();
/* 262 */       for (int i = 0; i < keys.length; i++)
/*     */       {
/* 264 */         String attrName = (String)keys[i];
/* 265 */         Method getter = (Method)getters.remove(attrName);
/* 266 */         Method setter = (Method)setters.remove(attrName);
/* 267 */         MBeanAttributeInfo info = new MBeanAttributeInfo(attrName, "MBean Attribute.", getter, setter);
/* 268 */         attrInfo.add(info);
/*     */       }
/*     */ 
/* 271 */       Iterator it = setters.keySet().iterator();
/* 272 */       while (it.hasNext())
/*     */       {
/* 274 */         String attrName = (String)it.next();
/* 275 */         Method setter = (Method)setters.get(attrName);
/* 276 */         MBeanAttributeInfo info = new MBeanAttributeInfo(attrName, "MBean Attribute.", null, setter);
/* 277 */         attrInfo.add(info);
/*     */       }
/*     */ 
/* 281 */       MBeanAttributeInfo[] attributeInfo = (MBeanAttributeInfo[])(MBeanAttributeInfo[])attrInfo.toArray(new MBeanAttributeInfo[0]);
/* 282 */       MBeanOperationInfo[] operationInfo = (MBeanOperationInfo[])(MBeanOperationInfo[])operInfo.values().toArray(new MBeanOperationInfo[0]);
/*     */ 
/* 287 */       MBeanNotificationInfo[] notifications = null;
/* 288 */       if ((this.mbeanInstance instanceof NotificationBroadcaster))
/*     */       {
/* 290 */         notifications = ((NotificationBroadcaster)this.mbeanInstance).getNotificationInfo();
/*     */       }
/*     */       else
/*     */       {
/* 294 */         notifications = new MBeanNotificationInfo[0];
/*     */       }
/*     */ 
/* 297 */       return new MBeanInfo(this.mbeanClass.getName(), "Management Bean.", attributeInfo, constructorInfo, operationInfo, notifications);
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/*     */     }
/*     */ 
/* 303 */     throw new NotCompliantMBeanException(e.getMessage());
/*     */   }
/*     */ 
/*     */   private boolean isBooleanReturn(Class returnType)
/*     */   {
/* 313 */     return returnType == Boolean.TYPE;
/*     */   }
/*     */ 
/*     */   protected String getSignatureString(Method method)
/*     */   {
/* 318 */     String name = method.getName();
/* 319 */     Class[] signature = method.getParameterTypes();
/* 320 */     StringBuffer buffer = new StringBuffer(512);
/* 321 */     buffer.append(name);
/* 322 */     buffer.append("(");
/* 323 */     if (signature != null)
/*     */     {
/* 325 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 327 */         buffer.append(signature[i].getName());
/* 328 */         if (i < signature.length - 1)
/* 329 */           buffer.append(",");
/*     */       }
/*     */     }
/* 332 */     buffer.append(")");
/* 333 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.StandardMetaData
 * JD-Core Version:    0.6.0
 */