/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ 
/*     */ public class MethodMapper
/*     */ {
/*  45 */   private HashMap map = null;
/*     */ 
/*     */   public MethodMapper(Class resourceClass)
/*     */   {
/*  52 */     if (null == resourceClass)
/*     */     {
/*  54 */       throw new IllegalArgumentException("resourceClass cannot be null");
/*     */     }
/*     */ 
/*  57 */     this.map = createMap(resourceClass);
/*     */   }
/*     */ 
/*     */   public Method lookupOperation(MBeanOperationInfo info)
/*     */   {
/*  65 */     if (null == info)
/*     */     {
/*  67 */       throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
/*     */     }
/*     */ 
/*  70 */     return (Method)this.map.get(operationSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupGetter(MBeanAttributeInfo info)
/*     */   {
/*  78 */     if (null == info)
/*     */     {
/*  80 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/*  83 */     return (Method)this.map.get(getterSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupGetter(ModelMBeanAttributeInfo info)
/*     */   {
/*  91 */     if (null == info)
/*     */     {
/*  93 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/*  96 */     return (Method)this.map.get(getterSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupSetter(MBeanAttributeInfo info)
/*     */   {
/* 104 */     if (null == info)
/*     */     {
/* 106 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 109 */     return (Method)this.map.get(setterSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupSetter(ModelMBeanAttributeInfo info)
/*     */   {
/* 117 */     if (null == info)
/*     */     {
/* 119 */       throw new IllegalArgumentException("ModelMBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 122 */     return (Method)this.map.get(setterSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupMethod(String returnType, String name, String[] signature)
/*     */   {
/* 130 */     if (null == returnType)
/*     */     {
/* 132 */       throw new IllegalArgumentException("returnType cannot be null");
/*     */     }
/*     */ 
/* 135 */     if (null == name)
/*     */     {
/* 137 */       throw new IllegalArgumentException("method name cannot be null");
/*     */     }
/*     */ 
/* 140 */     return (Method)this.map.get(methodSignature(returnType, name, signature));
/*     */   }
/*     */ 
/*     */   public static String getterSignature(MBeanAttributeInfo info)
/*     */   {
/* 148 */     if (null == info)
/*     */     {
/* 150 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 153 */     String prefix = info.isIs() ? "is" : "get";
/* 154 */     return methodSignature(info.getType(), prefix + info.getName(), null);
/*     */   }
/*     */ 
/*     */   public static String getterSignature(ModelMBeanAttributeInfo info)
/*     */   {
/* 163 */     if (null == info)
/*     */     {
/* 165 */       throw new IllegalArgumentException("ModelMBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 168 */     String methodName = (String)info.getDescriptor().getFieldValue("getMethod");
/*     */ 
/* 170 */     if (null == methodName)
/*     */     {
/* 172 */       throw new IllegalArgumentException("getMethod not defined in ModelMBeanAttributeInfo descriptor");
/*     */     }
/*     */ 
/* 175 */     return methodSignature(info.getType(), methodName, null);
/*     */   }
/*     */ 
/*     */   public static String setterSignature(MBeanAttributeInfo info)
/*     */   {
/* 183 */     if (null == info)
/*     */     {
/* 185 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 188 */     return methodSignature(Void.TYPE.getName(), "set" + info.getName(), new String[] { info.getType() });
/*     */   }
/*     */ 
/*     */   public static String setterSignature(ModelMBeanAttributeInfo info)
/*     */   {
/* 197 */     if (null == info)
/*     */     {
/* 199 */       throw new IllegalArgumentException("ModelMBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 202 */     String methodName = (String)info.getDescriptor().getFieldValue("setMethod");
/*     */ 
/* 204 */     if (null == methodName)
/*     */     {
/* 206 */       throw new IllegalArgumentException("setMethod not defined in ModelMBeanAttributeInfo descriptor");
/*     */     }
/*     */ 
/* 209 */     return methodSignature(Void.TYPE.getName(), methodName, new String[] { info.getType() });
/*     */   }
/*     */ 
/*     */   public static String operationSignature(MBeanOperationInfo info)
/*     */   {
/* 217 */     if (null == info)
/*     */     {
/* 219 */       throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
/*     */     }
/*     */ 
/* 222 */     MBeanParameterInfo[] params = info.getSignature();
/* 223 */     String[] signature = new String[params.length];
/* 224 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 226 */       signature[i] = params[i].getType();
/*     */     }
/* 228 */     return methodSignature(info.getReturnType(), info.getName(), signature);
/*     */   }
/*     */ 
/*     */   public static String methodSignature(Method method)
/*     */   {
/* 236 */     if (null == method)
/*     */     {
/* 238 */       throw new IllegalArgumentException("Method cannot be null");
/*     */     }
/*     */ 
/* 241 */     Class[] paramtypes = method.getParameterTypes();
/* 242 */     String[] signature = new String[paramtypes.length];
/* 243 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 245 */       signature[i] = paramtypes[i].getName();
/*     */     }
/* 247 */     return methodSignature(method.getReturnType().getName(), method.getName(), signature);
/*     */   }
/*     */ 
/*     */   public static String methodSignature(String returnType, String name, String[] signature)
/*     */   {
/* 255 */     if (null == returnType)
/*     */     {
/* 257 */       throw new IllegalArgumentException("returnType cannot be null");
/*     */     }
/* 259 */     if (null == name)
/*     */     {
/* 261 */       throw new IllegalArgumentException("method name cannot be null");
/*     */     }
/*     */ 
/* 264 */     StringBuffer buf = new StringBuffer(returnType).append(';').append(name);
/* 265 */     if (null == signature)
/*     */     {
/* 267 */       return buf.toString();
/*     */     }
/*     */ 
/* 270 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 272 */       buf.append(';').append(signature[i]);
/*     */     }
/*     */ 
/* 275 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   protected HashMap createMap(Class resourceClass)
/*     */   {
/* 283 */     HashMap cmap = new HashMap();
/* 284 */     Method[] methods = resourceClass.getMethods();
/* 285 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 287 */       cmap.put(methodSignature(methods[i]), methods[i]);
/*     */     }
/* 289 */     return cmap;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.MethodMapper
 * JD-Core Version:    0.6.0
 */