/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.modelmbean.DescriptorSupport;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanConstructorInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*     */ import javax.management.modelmbean.ModelMBeanNotificationInfo;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanConstants;
/*     */ import org.jboss.mx.server.MethodMapper;
/*     */ 
/*     */ public class MBeanInfoConversion
/*     */   implements ModelMBeanConstants
/*     */ {
/*     */   public static ModelMBeanInfoSupport toModelMBeanInfo(MBeanInfo info)
/*     */   {
/*  63 */     return toModelMBeanInfo(info, true);
/*     */   }
/*     */ 
/*     */   public static ModelMBeanInfoSupport toModelMBeanInfo(MBeanInfo info, boolean createAttributeOperationMapping)
/*     */   {
/*  80 */     if ((info instanceof ModelMBeanInfoSupport)) {
/*  81 */       return (ModelMBeanInfoSupport)info;
/*     */     }
/*  83 */     if ((info instanceof ModelMBeanInfo)) {
/*  84 */       return new ModelMBeanInfoSupport((ModelMBeanInfo)info);
/*     */     }
/*     */ 
/*  87 */     MBeanAttributeInfo[] attributes = info.getAttributes();
/*  88 */     ModelMBeanAttributeInfo[] mmbAttributes = new ModelMBeanAttributeInfo[attributes.length];
/*  89 */     List accessorOperations = new ArrayList();
/*     */ 
/*  91 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/*  94 */       ModelMBeanAttributeInfo attrInfo = new ModelMBeanAttributeInfo(attributes[i].getName(), attributes[i].getType(), attributes[i].getDescription(), attributes[i].isReadable(), attributes[i].isWritable(), attributes[i].isIs());
/*     */ 
/* 104 */       Descriptor d = attrInfo.getDescriptor();
/* 105 */       d.setField("currencyTimeLimit", "-1");
/* 106 */       attrInfo.setDescriptor(d);
/*     */ 
/* 108 */       mmbAttributes[i] = attrInfo;
/*     */ 
/* 114 */       if (!createAttributeOperationMapping)
/*     */         continue;
/* 116 */       String getterOperationName = null;
/* 117 */       String setterOperationName = null;
/* 118 */       Descriptor getterDescriptor = null;
/* 119 */       Descriptor setterDescriptor = null;
/*     */ 
/* 122 */       if (attributes[i].isReadable())
/*     */       {
/* 124 */         if (attributes[i].isIs())
/* 125 */           getterOperationName = "is" + attributes[i].getName();
/*     */         else {
/* 127 */           getterOperationName = "get" + attributes[i].getName();
/*     */         }
/*     */ 
/* 130 */         getterDescriptor = new DescriptorSupport();
/* 131 */         getterDescriptor.setField("name", getterOperationName);
/* 132 */         getterDescriptor.setField("descriptorType", "operation");
/* 133 */         getterDescriptor.setField("role", "getter");
/*     */ 
/* 136 */         ModelMBeanOperationInfo opInfo = new ModelMBeanOperationInfo(getterOperationName, "Read accessor operation for '" + attributes[i].getName() + "' attribute.", new MBeanParameterInfo[0], attributes[i].getType(), 0, getterDescriptor);
/*     */ 
/* 147 */         Descriptor attrDescriptor = mmbAttributes[i].getDescriptor();
/* 148 */         attrDescriptor.setField("getMethod", getterOperationName);
/* 149 */         mmbAttributes[i].setDescriptor(attrDescriptor);
/*     */ 
/* 151 */         accessorOperations.add(opInfo);
/*     */       }
/*     */ 
/* 155 */       if (!attributes[i].isWritable())
/*     */         continue;
/* 157 */       setterOperationName = "set" + attributes[i].getName();
/*     */ 
/* 160 */       setterDescriptor = new DescriptorSupport();
/* 161 */       setterDescriptor.setField("name", setterOperationName);
/* 162 */       setterDescriptor.setField("descriptorType", "operation");
/* 163 */       setterDescriptor.setField("role", "setter");
/*     */ 
/* 166 */       ModelMBeanOperationInfo opInfo = new ModelMBeanOperationInfo(setterOperationName, "Write accessor operation for '" + attributes[i].getName() + "' attribute.", new MBeanParameterInfo[] { new MBeanParameterInfo("value", attributes[i].getType(), "Attribute's value.") }, Void.TYPE.getName(), 1, setterDescriptor);
/*     */ 
/* 181 */       Descriptor attrDescriptor = mmbAttributes[i].getDescriptor();
/* 182 */       attrDescriptor.setField("setMethod", setterOperationName);
/* 183 */       mmbAttributes[i].setDescriptor(attrDescriptor);
/*     */ 
/* 185 */       accessorOperations.add(opInfo);
/*     */     }
/*     */ 
/* 191 */     MBeanOperationInfo[] operations = info.getOperations();
/* 192 */     ModelMBeanOperationInfo[] mmbOperations = new ModelMBeanOperationInfo[operations.length + accessorOperations.size()];
/*     */ 
/* 194 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 196 */       mmbOperations[i] = new ModelMBeanOperationInfo(operations[i].getName(), operations[i].getDescription(), operations[i].getSignature(), operations[i].getReturnType(), operations[i].getImpact());
/*     */     }
/*     */ 
/* 205 */     for (int i = operations.length; i < mmbOperations.length; i++) {
/* 206 */       mmbOperations[i] = ((ModelMBeanOperationInfo)accessorOperations.get(i - operations.length));
/*     */     }
/*     */ 
/* 209 */     MBeanConstructorInfo[] constructors = info.getConstructors();
/* 210 */     ModelMBeanConstructorInfo[] mmbConstructors = new ModelMBeanConstructorInfo[constructors.length];
/*     */ 
/* 212 */     for (int i = 0; i < constructors.length; i++)
/*     */     {
/* 214 */       mmbConstructors[i] = new ModelMBeanConstructorInfo(constructors[i].getName(), constructors[i].getDescription(), constructors[i].getSignature());
/*     */     }
/*     */ 
/* 227 */     MBeanNotificationInfo[] notifications = info.getNotifications();
/* 228 */     ModelMBeanNotificationInfo[] mmbNotifications = new ModelMBeanNotificationInfo[notifications.length];
/*     */ 
/* 230 */     for (int i = 0; i < notifications.length; i++)
/*     */     {
/* 232 */       mmbNotifications[i] = new ModelMBeanNotificationInfo(notifications[i].getNotifTypes(), notifications[i].getName(), notifications[i].getDescription());
/*     */     }
/*     */ 
/* 239 */     return new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), mmbAttributes, mmbConstructors, mmbOperations, mmbNotifications);
/*     */   }
/*     */ 
/*     */   public static ModelMBeanInfoSupport stripAttributeOperations(ModelMBeanInfo info, boolean stripAllRoles)
/*     */     throws MBeanException
/*     */   {
/* 253 */     HashMap opsMap = new HashMap();
/* 254 */     ModelMBeanOperationInfo[] operations = (ModelMBeanOperationInfo[])(ModelMBeanOperationInfo[])info.getOperations();
/*     */ 
/* 256 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 258 */       opsMap.put(MethodMapper.operationSignature(operations[i]), operations[i]);
/*     */     }
/*     */ 
/* 261 */     ModelMBeanAttributeInfo[] attributes = (ModelMBeanAttributeInfo[])(ModelMBeanAttributeInfo[])info.getAttributes();
/*     */ 
/* 263 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/* 265 */       if ((attributes[i].isReadable()) && (attributes[i].getDescriptor().getFieldValue("getMethod") != null))
/*     */       {
/* 267 */         String key = MethodMapper.getterSignature(attributes[i]);
/* 268 */         ModelMBeanOperationInfo opinfo = (ModelMBeanOperationInfo)opsMap.get(key);
/* 269 */         String role = (String)opinfo.getDescriptor().getFieldValue("role");
/* 270 */         if (("getter".equals(role)) || (stripAllRoles))
/*     */         {
/* 272 */           opsMap.remove(key);
/*     */         }
/*     */       }
/*     */ 
/* 276 */       if ((!attributes[i].isWritable()) || (attributes[i].getDescriptor().getFieldValue("setMethod") == null))
/*     */         continue;
/* 278 */       String key = MethodMapper.setterSignature(attributes[i]);
/* 279 */       ModelMBeanOperationInfo opinfo = (ModelMBeanOperationInfo)opsMap.get(key);
/*     */ 
/* 281 */       String role = (String)opinfo.getDescriptor().getFieldValue("role");
/* 282 */       if ((!"setter".equals(role)) && (!stripAllRoles))
/*     */         continue;
/* 284 */       opsMap.remove(key);
/*     */     }
/*     */ 
/* 289 */     operations = new ModelMBeanOperationInfo[opsMap.size()];
/* 290 */     int position = 0;
/* 291 */     for (Iterator iterator = opsMap.values().iterator(); iterator.hasNext(); position++)
/*     */     {
/* 293 */       operations[position] = ((ModelMBeanOperationInfo)iterator.next());
/*     */     }
/*     */ 
/* 296 */     return new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), (ModelMBeanAttributeInfo[])(ModelMBeanAttributeInfo[])info.getAttributes(), (ModelMBeanConstructorInfo[])(ModelMBeanConstructorInfo[])info.getConstructors(), operations, (ModelMBeanNotificationInfo[])(ModelMBeanNotificationInfo[])info.getNotifications(), info.getMBeanDescriptor());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.MBeanInfoConversion
 * JD-Core Version:    0.6.0
 */