/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ 
/*     */ public class MBeanCapability
/*     */ {
/*     */   public static final int DYNAMIC_MBEAN = 801;
/*     */   public static final int STANDARD_MBEAN = 291;
/*     */   public static final int NOT_AN_MBEAN = 49374;
/*  61 */   protected int mbeanType = 49374;
/*     */ 
/*     */   private MBeanCapability(int type)
/*     */   {
/*  65 */     this.mbeanType = type;
/*     */   }
/*     */ 
/*     */   public int getMBeanType()
/*     */   {
/*  70 */     return this.mbeanType;
/*     */   }
/*     */ 
/*     */   public static MBeanCapability of(Class mbeanClass) throws NotCompliantMBeanException
/*     */   {
/*  75 */     if (null == mbeanClass)
/*     */     {
/*  77 */       throw new IllegalArgumentException("MBean class cannot be null");
/*     */     }
/*     */ 
/*  81 */     if (DynamicMBean.class.isAssignableFrom(mbeanClass))
/*     */     {
/*  83 */       return new MBeanCapability(801);
/*     */     }
/*     */ 
/*  87 */     Class[] interfaces = mbeanClass.getInterfaces();
/*  88 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/*  90 */       Class anInterface = interfaces[i];
/*  91 */       if (anInterface.getName().equals(mbeanClass.getName() + "MBean"))
/*     */       {
/*  93 */         return new MBeanCapability(291);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  98 */     Class superClass = mbeanClass.getSuperclass();
/*  99 */     if (superClass != null) {
/* 100 */       return of(superClass);
/*     */     }
/* 102 */     throw new NotCompliantMBeanException("Class does not expose a management interface: " + mbeanClass.getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.MBeanCapability
 * JD-Core Version:    0.6.0
 */