/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ 
/*     */ public class AttributeOperationResolver
/*     */ {
/*  41 */   private Node opRoot = null;
/*  42 */   private Node atRoot = null;
/*     */ 
/*     */   public AttributeOperationResolver()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AttributeOperationResolver(MBeanInfo info)
/*     */   {
/*  58 */     this(info.getAttributes(), info.getOperations());
/*     */   }
/*     */ 
/*     */   public AttributeOperationResolver(MBeanAttributeInfo[] attributes, MBeanOperationInfo[] operations)
/*     */   {
/*  68 */     int attributeCount = attributes != null ? attributes.length : 0;
/*  69 */     for (int i = 0; i < attributeCount; i++)
/*     */     {
/*  71 */       store(attributes[i].getName(), new Integer(i));
/*     */     }
/*     */ 
/*  74 */     int operationCount = operations != null ? operations.length : 0;
/*  75 */     for (int i = 0; i < operationCount; i++)
/*     */     {
/*  77 */       MBeanOperationInfo operation = operations[i];
/*  78 */       MBeanParameterInfo[] params = operation.getSignature();
/*  79 */       String[] signature = new String[params.length];
/*  80 */       for (int j = 0; j < signature.length; j++)
/*     */       {
/*  82 */         signature[j] = params[j].getType();
/*     */       }
/*  84 */       store(operation.getName(), signature, new Integer(i));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Integer lookup(String actionName, String[] signature)
/*     */   {
/*  90 */     String word = actionName;
/*  91 */     int wordh = word.hashCode();
/*  92 */     int wordpos = -1;
/*  93 */     int maxword = signature != null ? signature.length : 0;
/*     */ 
/*  95 */     Node node = this.opRoot;
/*  96 */     Integer rval = null;
/*  97 */     label167: while (node != null)
/*     */     {
/*  99 */       if (wordh < node.hash)
/*     */       {
/* 101 */         node = node.loKid; continue;
/*     */       }
/* 103 */       if (wordh > node.hash)
/*     */       {
/* 105 */         node = node.hiKid; continue;
/*     */       }
/*     */ 
/* 109 */       for (int i = node.eqKid.length - 1; ; i--) { if (i <= -1) break label167;
/* 111 */         if (!word.equals(node.eqKid[i].val))
/*     */           continue;
/* 113 */         wordpos++; if (wordpos < maxword)
/*     */         {
/* 115 */           node = node.eqKid[i];
/* 116 */           word = signature[wordpos];
/* 117 */           wordh = word.hashCode();
/* 118 */           break;
/*     */         }
/*     */ 
/* 122 */         rval = node.eqKid[i].code;
/* 123 */         break label170;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 129 */     label170: return rval;
/*     */   }
/*     */ 
/*     */   public Integer lookup(String attrName)
/*     */   {
/* 134 */     int attrh = attrName.hashCode();
/*     */ 
/* 136 */     Node node = this.atRoot;
/* 137 */     Integer rval = null;
/* 138 */     while (node != null)
/*     */     {
/* 140 */       if (attrh < node.hash)
/*     */       {
/* 142 */         node = node.loKid; continue;
/*     */       }
/* 144 */       if (attrh > node.hash)
/*     */       {
/* 146 */         node = node.hiKid; continue;
/*     */       }
/*     */ 
/* 150 */       for (int i = node.eqKid.length - 1; i > -1; i--)
/*     */       {
/* 152 */         if (!attrName.equals(node.eqKid[i].val))
/*     */           continue;
/* 154 */         rval = node.eqKid[i].code;
/* 155 */         break label105;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 160 */     label105: return rval;
/*     */   }
/*     */ 
/*     */   public void store(String mname, String[] signature, Integer code)
/*     */   {
/* 165 */     if (this.opRoot == null)
/*     */     {
/* 167 */       this.opRoot = createNode(mname);
/* 168 */       createValueNode(this.opRoot, mname);
/*     */     }
/*     */ 
/* 171 */     int word = -1;
/* 172 */     int maxword = signature != null ? signature.length : 0;
/*     */ 
/* 174 */     Node current = createOrGetNode(this.opRoot, mname);
/*     */     while (true) { word++; if (word >= maxword)
/*     */         break;
/* 177 */       current = createOrGetNode(current, signature[word]);
/*     */     }
/*     */ 
/* 180 */     current.code = code;
/*     */   }
/*     */ 
/*     */   public void store(String attrName, Integer code)
/*     */   {
/* 185 */     Node current = null;
/*     */ 
/* 187 */     if (this.atRoot == null)
/*     */     {
/* 189 */       this.atRoot = createNode(attrName);
/* 190 */       current = createValueNode(this.atRoot, attrName);
/*     */     }
/*     */     else
/*     */     {
/* 194 */       current = createOrGetNode(this.atRoot, attrName);
/*     */     }
/*     */ 
/* 197 */     current.code = code;
/*     */   }
/*     */ 
/*     */   protected Node createNode(String key)
/*     */   {
/* 202 */     Node h = new Node();
/* 203 */     h.hash = key.hashCode();
/* 204 */     h.val = key;
/* 205 */     return h;
/*     */   }
/*     */ 
/*     */   protected Node createValueNode(Node parent, String key)
/*     */   {
/* 210 */     Node h = new Node();
/* 211 */     h.val = key;
/* 212 */     h.hash = key.hashCode();
/* 213 */     int insertAt = 0;
/* 214 */     if (parent.eqKid == null)
/*     */     {
/* 216 */       parent.eqKid = new Node[1];
/*     */     }
/*     */     else
/*     */     {
/* 220 */       Node[] old = parent.eqKid;
/* 221 */       insertAt = old.length;
/* 222 */       parent.eqKid = new Node[insertAt + 1];
/* 223 */       System.arraycopy(old, 0, parent.eqKid, 0, insertAt);
/*     */     }
/*     */ 
/* 226 */     parent.eqKid[insertAt] = h;
/* 227 */     return h;
/*     */   }
/*     */ 
/*     */   protected Node createOrGetNode(Node parent, String key)
/*     */   {
/* 232 */     Node realParent = parent;
/* 233 */     int keycode = key.hashCode();
/*     */     while (true)
/*     */     {
/* 237 */       if (keycode < realParent.hash)
/*     */       {
/* 239 */         if (realParent.loKid == null)
/*     */         {
/* 241 */           realParent.loKid = createNode(key);
/* 242 */           return createValueNode(realParent.loKid, key);
/*     */         }
/* 244 */         realParent = realParent.loKid; continue;
/*     */       }
/* 246 */       if (keycode <= realParent.hash)
/*     */         break;
/* 248 */       if (realParent.hiKid == null)
/*     */       {
/* 250 */         realParent.hiKid = createNode(key);
/* 251 */         return createValueNode(realParent.hiKid, key);
/*     */       }
/* 253 */       realParent = realParent.hiKid;
/*     */     }
/*     */ 
/* 257 */     if (realParent.eqKid != null)
/*     */     {
/* 259 */       for (int i = 0; i < realParent.eqKid.length; i++)
/*     */       {
/* 261 */         if (key.equals(realParent.eqKid[i].val))
/*     */         {
/* 263 */           return realParent.eqKid[i];
/*     */         }
/*     */       }
/*     */     }
/* 267 */     return createValueNode(realParent, key);
/*     */   }
/*     */ 
/*     */   public static class Node
/*     */   {
/* 275 */     public int hash = 0;
/* 276 */     public String val = null;
/*     */ 
/* 278 */     public Node hiKid = null;
/* 279 */     public Node loKid = null;
/* 280 */     public Node[] eqKid = null;
/*     */ 
/* 282 */     public Integer code = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.AttributeOperationResolver
 * JD-Core Version:    0.6.0
 */