/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ 
/*     */ public abstract class AbstractBuilder
/*     */   implements MetaDataBuilder
/*     */ {
/*  50 */   protected Map properties = new HashMap();
/*     */ 
/*     */   public AbstractBuilder()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractBuilder(Map properties)
/*     */   {
/*  61 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public boolean getBooleanProperty(String key)
/*     */     throws IllegalPropertyException
/*     */   {
/*  81 */     Object value = this.properties.get(key);
/*     */ 
/*  83 */     if (value == null) {
/*  84 */       throw new IllegalPropertyException("boolean property " + key + " does not exist");
/*     */     }
/*  86 */     if ((value instanceof String))
/*     */     {
/*  88 */       String v = (String)value;
/*  89 */       if (v.equalsIgnoreCase("true"))
/*  90 */         return true;
/*  91 */       if (v.equalsIgnoreCase("false"))
/*  92 */         return false;
/*  93 */       if (v.equalsIgnoreCase("t"))
/*  94 */         return true;
/*  95 */       if (v.equalsIgnoreCase("f")) {
/*  96 */         return false;
/*     */       }
/*  98 */       throw new IllegalPropertyException("unknown string value '" + v + "' for boolean property");
/*     */     }
/* 100 */     if ((value instanceof Boolean)) {
/* 101 */       return ((Boolean)value).booleanValue();
/*     */     }
/* 103 */     throw new IllegalPropertyException("illegal property type: " + value.getClass().getName());
/*     */   }
/*     */ 
/*     */   public String getStringProperty(String key)
/*     */   {
/* 111 */     return (String)this.properties.get(key);
/*     */   }
/*     */ 
/*     */   public void setProperty(String key, Object value)
/*     */   {
/* 122 */     this.properties.put(key, value);
/*     */   }
/*     */ 
/*     */   public Object getProperty(String key)
/*     */   {
/* 130 */     return this.properties.get(key);
/*     */   }
/*     */ 
/*     */   public abstract MBeanInfo build()
/*     */     throws NotCompliantMBeanException;
/*     */ 
/*     */   protected void setProperties(Map properties)
/*     */   {
/* 144 */     this.properties = new HashMap(properties);
/*     */   }
/*     */ 
/*     */   protected Map getProperties()
/*     */   {
/* 152 */     return this.properties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.AbstractBuilder
 * JD-Core Version:    0.6.0
 */