/*      */ package org.jboss.mx.loading;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*      */ import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
/*      */ import java.io.IOException;
/*      */ import java.lang.ref.WeakReference;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.net.URLClassLoader;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collections;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javax.management.ListenerNotFoundException;
/*      */ import javax.management.MBeanNotificationInfo;
/*      */ import javax.management.MBeanRegistration;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.Notification;
/*      */ import javax.management.NotificationBroadcaster;
/*      */ import javax.management.NotificationFilter;
/*      */ import javax.management.NotificationListener;
/*      */ import javax.management.ObjectName;
/*      */ import javax.management.loading.MLet;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*      */ import org.jboss.util.Classes;
/*      */ import org.jboss.util.loading.Translator;
/*      */ 
/*      */ public class UnifiedLoaderRepository3 extends LoaderRepository
/*      */   implements MBeanRegistration, NotificationBroadcaster, UnifiedLoaderRepository3MBean
/*      */ {
/*   75 */   private static final Logger log = Logger.getLogger(UnifiedLoaderRepository3.class);
/*      */   private static int addedCount;
/*      */   private static final int LEGACY_MODE = 0;
/*      */   private static final int WEAK_REFERENCE_MODE = 1;
/*      */   private static final int NO_NOTIFICATION_MODE = 2;
/*      */   private static int NOTIFICATION_MODE;
/*      */   private CopyOnWriteArraySet classLoaders;
/*      */   private HashSet dynamicClassLoaders;
/*      */   private HashMap nonUCLClassLoader;
/*      */   private HashSet classLoaderURLs;
/*      */   private ConcurrentReaderHashMap classes;
/*      */   private HashMap loaderToClassesMap;
/*      */   private HashMap loaderToResourcesMap;
/*      */   private HashMap globalResources;
/*      */   private ConcurrentReaderHashMap packagesMap;
/*      */   private HashMap<RepositoryClassLoader, List<String>> loaderToPackagesMap;
/*      */   private long sequenceNumber;
/*      */   private final JBossNotificationBroadcasterSupport broadcaster;
/*      */   private MBeanNotificationInfo[] info;
/*      */ 
/*      */   public UnifiedLoaderRepository3()
/*      */   {
/*   96 */     this.classLoaders = new CopyOnWriteArraySet();
/*      */ 
/*  101 */     this.dynamicClassLoaders = new HashSet();
/*      */ 
/*  107 */     this.nonUCLClassLoader = new HashMap();
/*      */ 
/*  114 */     this.classLoaderURLs = new HashSet();
/*      */ 
/*  119 */     this.classes = new ConcurrentReaderHashMap();
/*      */ 
/*  125 */     this.loaderToClassesMap = new HashMap();
/*      */ 
/*  131 */     this.loaderToResourcesMap = new HashMap();
/*      */ 
/*  137 */     this.globalResources = new HashMap();
/*      */ 
/*  143 */     this.packagesMap = new ConcurrentReaderHashMap();
/*      */ 
/*  149 */     this.loaderToPackagesMap = new HashMap();
/*      */ 
/*  154 */     this.sequenceNumber = 0L;
/*      */ 
/*  159 */     this.broadcaster = new JBossNotificationBroadcasterSupport();
/*      */   }
/*      */ 
/*      */   public RepositoryClassLoader newClassLoader(URL url, boolean addToRepository)
/*      */     throws Exception
/*      */   {
/*  190 */     UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, null, this);
/*  191 */     if (addToRepository)
/*  192 */       registerClassLoader(ucl);
/*  193 */     return ucl;
/*      */   }
/*      */ 
/*      */   public RepositoryClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository)
/*      */     throws Exception
/*      */   {
/*  199 */     UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, origURL, this);
/*  200 */     if (addToRepository)
/*  201 */       registerClassLoader(ucl);
/*  202 */     return ucl;
/*      */   }
/*      */ 
/*      */   public int getCacheSize()
/*      */   {
/*  207 */     return this.classes.size();
/*      */   }
/*      */ 
/*      */   public int getClassLoadersSize()
/*      */   {
/*  212 */     return this.classLoaders.size();
/*      */   }
/*      */ 
/*      */   public void flush()
/*      */   {
/*  217 */     synchronized (this.classes)
/*      */     {
/*  219 */       this.classes.clear();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Class getCachedClass(String classname)
/*      */   {
/*  225 */     return (Class)this.classes.get(classname);
/*      */   }
/*      */ 
/*      */   public Class loadClass(String name, boolean resolve, ClassLoader cl)
/*      */     throws ClassNotFoundException
/*      */   {
/*  234 */     RepositoryClassLoader rcl = getRepositoryClassLoader(cl, name);
/*  235 */     return rcl.loadClass(name, resolve);
/*      */   }
/*      */ 
/*      */   public Set getPackageClassLoaders(String className)
/*      */   {
/*  243 */     String pkgName = ClassLoaderUtils.getPackageName(className);
/*      */ 
/*  246 */     if (pkgName.startsWith("java.")) {
/*  247 */       return null;
/*      */     }
/*  249 */     Set pkgSet = (Set)this.packagesMap.get(pkgName);
/*  250 */     if (this.dynamicClassLoaders.size() > 0)
/*      */     {
/*  252 */       Set newSet = ClassLoaderUtils.newPackageSet();
/*  253 */       if (pkgSet != null)
/*  254 */         newSet.addAll(pkgSet);
/*  255 */       pkgSet = newSet;
/*  256 */       pkgSet.addAll(this.dynamicClassLoaders);
/*      */     }
/*  258 */     return pkgSet;
/*      */   }
/*      */ 
/*      */   private String getResourcePackageName(String rsrcName)
/*      */   {
/*  263 */     int index = rsrcName.lastIndexOf('/');
/*  264 */     String pkgName = rsrcName;
/*  265 */     if (index > 0)
/*  266 */       pkgName = rsrcName.substring(0, index);
/*  267 */     return pkgName.replace('/', '.');
/*      */   }
/*      */ 
/*      */   public Class loadClassFromCache(String name)
/*      */   {
/*  276 */     Class cls = null;
/*  277 */     synchronized (this.classes)
/*      */     {
/*  279 */       cls = (Class)this.classes.get(name);
/*      */     }
/*  281 */     return cls;
/*      */   }
/*      */ 
/*      */   public void cacheLoadedClass(String name, Class cls, ClassLoader cl)
/*      */   {
/*  291 */     synchronized (this.classes)
/*      */     {
/*  294 */       Object prevClass = this.classes.put(name, cls);
/*  295 */       if (log.isTraceEnabled())
/*      */       {
/*  297 */         log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", ucl: " + cl + ", prevClass: " + prevClass);
/*      */       }
/*      */ 
/*  303 */       HashSet loadedClasses = (HashSet)this.loaderToClassesMap.get(cl);
/*  304 */       if (loadedClasses == null)
/*      */       {
/*  306 */         loadedClasses = new HashSet();
/*  307 */         this.loaderToClassesMap.put(cl, loadedClasses);
/*      */       }
/*  309 */       loadedClasses.add(name);
/*      */     }
/*      */   }
/*      */ 
/*      */   Class loadClassFromClassLoader(String name, boolean resolve, RepositoryClassLoader cl)
/*      */   {
/*      */     try
/*      */     {
/*  317 */       Class cls = cl.loadClassLocally(name, resolve);
/*  318 */       cacheLoadedClass(name, cls, cl);
/*  319 */       return cls;
/*      */     }
/*      */     catch (ClassNotFoundException x)
/*      */     {
/*      */     }
/*      */ 
/*  325 */     return null;
/*      */   }
/*      */ 
/*      */   public URL getResource(String name, ClassLoader cl)
/*      */   {
/*  335 */     URL resource = getResourceFromCache(name, cl);
/*      */ 
/*  338 */     if (resource != null) {
/*  339 */       return resource;
/*      */     }
/*      */ 
/*  342 */     resource = getResourceFromClassLoader(name, cl);
/*      */ 
/*  345 */     if (resource != null) {
/*  346 */       return resource;
/*      */     }
/*      */ 
/*  349 */     resource = getResourceFromGlobalCache(name);
/*      */ 
/*  352 */     if (resource != null) {
/*  353 */       return resource;
/*      */     }
/*      */ 
/*  356 */     resource = getResourceFromRepository(name, cl);
/*      */ 
/*  359 */     if (resource != null) {
/*  360 */       return resource;
/*      */     }
/*      */ 
/*  363 */     return null;
/*      */   }
/*      */ 
/*      */   public void getResources(String name, ClassLoader cl, List urls)
/*      */   {
/*  376 */     Iterator iter = this.classLoaders.iterator();
/*  377 */     while (iter.hasNext() == true)
/*      */     {
/*  379 */       ClassLoader nextCL = (ClassLoader)iter.next();
/*  380 */       if ((nextCL instanceof RepositoryClassLoader))
/*      */       {
/*  382 */         RepositoryClassLoader ucl = (RepositoryClassLoader)nextCL;
/*      */         try
/*      */         {
/*  385 */           Enumeration resURLs = ucl.findResourcesLocally(name);
/*  386 */           while (resURLs.hasMoreElements())
/*      */           {
/*  388 */             Object res = resURLs.nextElement();
/*  389 */             urls.add(res);
/*      */           }
/*      */         }
/*      */         catch (IOException ignore)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private URL getResourceFromCache(String name, ClassLoader cl)
/*      */   {
/*  409 */     URL resource = null;
/*  410 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  412 */       if (this.loaderToResourcesMap.containsKey(cl))
/*      */       {
/*  414 */         HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
/*  415 */         resource = (URL)resources.get(name);
/*      */       }
/*      */     }
/*  418 */     return resource;
/*      */   }
/*      */ 
/*      */   private URL getResourceFromClassLoader(String name, ClassLoader cl)
/*      */   {
/*  423 */     URL resource = null;
/*  424 */     if ((cl instanceof RepositoryClassLoader))
/*      */     {
/*  426 */       RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
/*  427 */       resource = ucl.getResourceLocally(name);
/*  428 */       cacheLoadedResource(name, resource, cl);
/*      */     }
/*  430 */     return resource;
/*      */   }
/*      */ 
/*      */   protected URL getResourceFromGlobalCache(String name)
/*      */   {
/*  440 */     ResourceInfo ri = null;
/*  441 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  443 */       ri = (ResourceInfo)this.globalResources.get(name);
/*      */     }
/*  445 */     URL resource = null;
/*  446 */     if (ri != null)
/*  447 */       resource = ri.url;
/*  448 */     return resource;
/*      */   }
/*      */ 
/*      */   protected URL getResourceFromRepository(String name, ClassLoader cl)
/*      */   {
/*  454 */     String pkgName = getResourcePackageName(name);
/*  455 */     Iterator i = null;
/*  456 */     Set pkgSet = (Set)this.packagesMap.get(pkgName);
/*  457 */     if (pkgSet != null)
/*      */     {
/*  459 */       i = pkgSet.iterator();
/*      */     }
/*  461 */     if (i == null)
/*      */     {
/*  464 */       i = this.classLoaders.iterator();
/*      */     }
/*      */ 
/*  467 */     URL url = null;
/*  468 */     while (i.hasNext() == true)
/*      */     {
/*  470 */       ClassLoader classloader = (ClassLoader)i.next();
/*  471 */       if (classloader.equals(cl))
/*      */       {
/*      */         continue;
/*      */       }
/*      */ 
/*  476 */       if ((classloader instanceof RepositoryClassLoader))
/*      */       {
/*  478 */         url = ((RepositoryClassLoader)classloader).getResourceLocally(name);
/*  479 */         if (url != null)
/*      */         {
/*  481 */           cacheLoadedResource(name, url, classloader);
/*  482 */           cacheGlobalResource(name, url, classloader);
/*  483 */           break;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  491 */     return url;
/*      */   }
/*      */ 
/*      */   private void cacheLoadedResource(String name, URL url, ClassLoader cl)
/*      */   {
/*  503 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  505 */       HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
/*  506 */       if (resources == null)
/*      */       {
/*  508 */         resources = new HashMap();
/*  509 */         this.loaderToResourcesMap.put(cl, resources);
/*      */       }
/*  511 */       resources.put(name, url);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void cacheGlobalResource(String name, URL url, ClassLoader cl)
/*      */   {
/*  522 */     synchronized (this.loaderToResourcesMap)
/*      */     {
/*  524 */       this.globalResources.put(name, new ResourceInfo(url, cl));
/*      */     }
/*      */   }
/*      */ 
/*      */   public URL[] getURLs()
/*      */   {
/*  534 */     HashSet classpath = new HashSet();
/*  535 */     Set tmp = this.classLoaders;
/*  536 */     for (Iterator iter = tmp.iterator(); iter.hasNext(); )
/*      */     {
/*  538 */       Object obj = iter.next();
/*  539 */       if ((obj instanceof RepositoryClassLoader))
/*      */       {
/*  541 */         RepositoryClassLoader cl = (RepositoryClassLoader)obj;
/*  542 */         URL[] urls = cl.getClasspath();
/*  543 */         int length = urls != null ? urls.length : 0;
/*  544 */         for (int u = 0; u < length; u++)
/*      */         {
/*  546 */           URL path = urls[u];
/*  547 */           classpath.add(path);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  552 */     URL[] cp = new URL[classpath.size()];
/*  553 */     classpath.toArray(cp);
/*  554 */     return cp;
/*      */   }
/*      */ 
/*      */   public String displayClassInfo(String className)
/*      */   {
/*  566 */     String classRsrcName = className.replace('.', '/') + ".class";
/*      */ 
/*  568 */     int count = 0;
/*  569 */     Class loadedClass = loadClassFromCache(className);
/*  570 */     StringBuffer results = new StringBuffer(className + " Information\n");
/*  571 */     if (loadedClass != null)
/*      */     {
/*  573 */       results.append("Repository cache version:");
/*  574 */       Classes.displayClassInfo(loadedClass, results);
/*      */     }
/*      */     else
/*      */     {
/*  578 */       results.append("Not loaded in repository cache\n");
/*      */     }
/*  580 */     Set tmp = this.classLoaders;
/*  581 */     for (Iterator iter = tmp.iterator(); iter.hasNext(); )
/*      */     {
/*  583 */       URLClassLoader cl = (URLClassLoader)iter.next();
/*  584 */       URL classURL = cl.findResource(classRsrcName);
/*  585 */       if (classURL != null)
/*      */       {
/*  587 */         results.append("\n\n### Instance" + count + " found in UCL: " + cl + "\n");
/*  588 */         count++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  593 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*  594 */     URLClassLoader[] stack = ClassLoaderUtils.getClassLoaderStack(tcl);
/*  595 */     for (int s = 0; s < stack.length; s++)
/*      */     {
/*  597 */       URLClassLoader cl = stack[s];
/*  598 */       URL classURL = cl.findResource(classRsrcName);
/*  599 */       if (classURL == null)
/*      */         continue;
/*  601 */       results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
/*  602 */       count++;
/*      */     }
/*      */ 
/*  606 */     return results.toString();
/*      */   }
/*      */ 
/*      */   public Class loadClass(String className)
/*      */     throws ClassNotFoundException
/*      */   {
/*  619 */     ClassLoader scl = Thread.currentThread().getContextClassLoader();
/*  620 */     ClassLoader ucl = null;
/*  621 */     if (this.classLoaders.size() > 0)
/*  622 */       ucl = (ClassLoader)this.classLoaders.iterator().next();
/*      */     try
/*      */     {
/*  625 */       if (ucl != null) {
/*  626 */         return loadClass(className, false, ucl);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ClassNotFoundException ignore)
/*      */     {
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  636 */       return scl.loadClass(className);
/*      */     }
/*      */     catch (ClassNotFoundException clazz)
/*      */     {
/*  644 */       Class clazz = getNativeClassForName(className);
/*  645 */       if (clazz != null) return clazz;
/*      */     }
/*  647 */     throw new ClassNotFoundException(className);
/*      */   }
/*      */ 
/*      */   public Class loadClassWithout(ClassLoader loader, String className)
/*      */     throws ClassNotFoundException
/*      */   {
/*  662 */     throw new ClassNotFoundException("NYI");
/*      */   }
/*      */ 
/*      */   public Class loadClassBefore(ClassLoader stop, String className)
/*      */     throws ClassNotFoundException
/*      */   {
/*  678 */     RepositoryClassLoader stopAt = getRepositoryClassLoader(stop, className);
/*  679 */     return stopAt.loadClassBefore(className);
/*      */   }
/*      */ 
/*      */   public RepositoryClassLoader getWrappingClassLoader(ClassLoader cl)
/*      */   {
/*  690 */     synchronized (this.classLoaders)
/*      */     {
/*  692 */       return (RepositoryClassLoader)this.nonUCLClassLoader.get(cl);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addClassLoader(ClassLoader loader)
/*      */   {
/*  701 */     if ((loader instanceof RepositoryClassLoader))
/*  702 */       addRepositoryClassLoader((RepositoryClassLoader)loader);
/*  703 */     else if ((loader instanceof MLet))
/*      */     {
/*  705 */       addMLetClassLoader((MLet)loader);
/*      */     }
/*  707 */     else if ((loader instanceof URLClassLoader))
/*      */     {
/*  709 */       addURLClassLoader((URLClassLoader)loader);
/*      */     }
/*      */     else
/*      */     {
/*  713 */       log.warn("Tried to add non-URLClassLoader.  Ignored");
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean addClassLoaderURL(ClassLoader cl, URL url)
/*      */   {
/*  719 */     RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
/*  720 */     boolean added = false;
/*  721 */     synchronized (this.classLoaders)
/*      */     {
/*  724 */       String query = url.getQuery();
/*  725 */       if (query != null)
/*      */       {
/*  727 */         String ext = url.toExternalForm();
/*  728 */         String ext2 = ext.substring(0, ext.length() - query.length() - 1);
/*      */         try
/*      */         {
/*  731 */           url = new URL(ext2);
/*      */         }
/*      */         catch (MalformedURLException e)
/*      */         {
/*  735 */           log.warn("Failed to strip query from: " + url, e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  740 */       if (!this.classLoaderURLs.contains(url))
/*      */       {
/*  742 */         updatePackageMap(ucl, url);
/*  743 */         this.classLoaderURLs.add(url);
/*  744 */         added = true;
/*      */ 
/*  746 */         if ((query != null) && (query.indexOf("dynamic=true") >= 0))
/*  747 */           this.dynamicClassLoaders.add(ucl);
/*      */       }
/*      */     }
/*  750 */     return added;
/*      */   }
/*      */ 
/*      */   private void addRepositoryClassLoader(RepositoryClassLoader cl)
/*      */   {
/*  759 */     cl.setRepository(this);
/*      */ 
/*  761 */     URL url = cl.getURL();
/*  762 */     boolean added = false;
/*  763 */     synchronized (this.classLoaders)
/*      */     {
/*  765 */       boolean exists = false;
/*  766 */       if ((cl instanceof UnifiedClassLoader)) {
/*  767 */         exists = this.classLoaderURLs.contains(url);
/*      */       }
/*  769 */       if (!exists)
/*      */       {
/*  771 */         if (url != null)
/*  772 */           this.classLoaderURLs.add(url);
/*  773 */         added = this.classLoaders.add(cl);
/*      */       }
/*  775 */       if (added)
/*      */       {
/*  777 */         log.debug("Adding " + cl);
/*  778 */         addedCount += 1;
/*  779 */         cl.setAddedOrder(addedCount);
/*  780 */         updatePackageMap(cl);
/*      */       }
/*      */       else
/*      */       {
/*  784 */         log.debug("Skipping duplicate " + cl);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addMLetClassLoader(MLet loader)
/*      */   {
/*  791 */     MLetRepositoryClassLoader rcl = new MLetRepositoryClassLoader(loader);
/*  792 */     synchronized (this.classLoaders)
/*      */     {
/*  794 */       this.nonUCLClassLoader.put(loader, rcl);
/*      */     }
/*  796 */     addRepositoryClassLoader(rcl);
/*      */   }
/*      */ 
/*      */   private void addURLClassLoader(URLClassLoader loader)
/*      */   {
/*  801 */     URL[] urls = loader.getURLs();
/*  802 */     int count = (urls != null) && (urls.length > 0) ? urls.length : 0;
/*  803 */     URL origURL = count > 0 ? urls[0] : null;
/*  804 */     UnifiedClassLoader3 ucl3 = new UnifiedClassLoader3(origURL, origURL, this);
/*  805 */     addRepositoryClassLoader(ucl3);
/*  806 */     synchronized (this.classLoaders)
/*      */     {
/*  808 */       this.nonUCLClassLoader.put(loader, ucl3);
/*      */     }
/*  810 */     for (int i = 1; i < count; i++)
/*      */     {
/*  812 */       addClassLoaderURL(ucl3, urls[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void updatePackageMap(RepositoryClassLoader cl)
/*      */   {
/*      */     try
/*      */     {
/*  823 */       URL url = cl.getURL();
/*  824 */       PackageMapper listener = new PackageMapper(cl);
/*  825 */       ClassLoaderUtils.updatePackageMap(url, listener);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  829 */       if (log.isTraceEnabled())
/*  830 */         log.trace("Failed to update pkgs for cl=" + cl, e);
/*      */       else
/*  832 */         log.debug("Failed to update pkgs for cl=" + cl + ", " + e.getMessage());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void updatePackageMap(RepositoryClassLoader cl, URL url)
/*      */   {
/*      */     try
/*      */     {
/*  843 */       PackageMapper listener = new PackageMapper(cl);
/*  844 */       ClassLoaderUtils.updatePackageMap(url, listener);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  848 */       if (log.isTraceEnabled())
/*  849 */         log.trace("Failed to update pkgs for cl=" + cl, e);
/*      */       else
/*  851 */         log.debug("Failed to update pkgs for cl=" + cl, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeClassLoader(ClassLoader loader)
/*      */   {
/*  860 */     ArrayList removeNotifications = new ArrayList();
/*  861 */     ClassLoader cl = loader;
/*      */     Iterator i;
/*  862 */     synchronized (this.classLoaders)
/*      */     {
/*  864 */       if (!(loader instanceof RepositoryClassLoader))
/*      */       {
/*  866 */         cl = (ClassLoader)this.nonUCLClassLoader.remove(loader);
/*      */       }
/*  868 */       if ((cl instanceof RepositoryClassLoader))
/*      */       {
/*  870 */         RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
/*  871 */         if (getTranslator() != null)
/*  872 */           getTranslator().unregisterClassLoader(ucl);
/*  873 */         URL[] urls = ucl.getClasspath();
/*  874 */         for (int u = 0; u < urls.length; u++)
/*  875 */           this.classLoaderURLs.remove(urls[u]);
/*      */       }
/*  877 */       boolean dynamic = this.dynamicClassLoaders.remove(cl);
/*  878 */       boolean removed = this.classLoaders.remove(cl);
/*  879 */       log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
/*      */ 
/*  882 */       HashSet loadedClasses = null;
/*  883 */       boolean hasLoadedClasses = false;
/*      */       Iterator i;
/*  884 */       synchronized (this.classes)
/*      */       {
/*  886 */         hasLoadedClasses = this.loaderToClassesMap.containsKey(cl);
/*  887 */         if (hasLoadedClasses) {
/*  888 */           loadedClasses = (HashSet)this.loaderToClassesMap.remove(cl);
/*      */         }
/*  890 */         if (loadedClasses != null)
/*      */         {
/*  893 */           for (Iterator iter = loadedClasses.iterator(); iter.hasNext(); )
/*      */           {
/*  895 */             String className = (String)iter.next();
/*  896 */             Notification n = new Notification("jboss.mx.class.removed", this, getNextSequenceNumber(), className);
/*      */ 
/*  898 */             removeNotifications.add(n);
/*      */           }
/*      */ 
/*  902 */           for (i = loadedClasses.iterator(); i.hasNext(); )
/*      */           {
/*  904 */             String cls = (String)i.next();
/*  905 */             this.classes.remove(cls);
/*      */           }
/*      */         }
/*      */       }
/*      */       Iterator i;
/*  911 */       synchronized (this.loaderToResourcesMap)
/*      */       {
/*  913 */         if (this.loaderToResourcesMap.containsKey(cl))
/*      */         {
/*  915 */           HashMap resources = (HashMap)this.loaderToResourcesMap.remove(cl);
/*      */ 
/*  918 */           if (resources != null)
/*      */           {
/*  920 */             for (i = resources.keySet().iterator(); i.hasNext(); )
/*      */             {
/*  922 */               String name = (String)i.next();
/*  923 */               ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
/*  924 */               if ((ri != null) && (ri.cl == cl)) {
/*  925 */                 this.globalResources.remove(name);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  932 */       if (!dynamic)
/*      */       {
/*  934 */         List pkgNames = (List)this.loaderToPackagesMap.remove(cl);
/*  935 */         if (pkgNames != null)
/*      */         {
/*  937 */           for (String pkgName : pkgNames)
/*      */           {
/*  939 */             Set pkgSet = (Set)this.packagesMap.get(pkgName);
/*  940 */             if (pkgSet != null)
/*      */             {
/*  942 */               Set newSet = ClassLoaderUtils.newPackageSet();
/*  943 */               newSet.addAll(pkgSet);
/*  944 */               pkgSet = newSet;
/*      */ 
/*  946 */               pkgSet.remove(cl);
/*  947 */               this.packagesMap.put(pkgName, newSet);
/*  948 */               if (pkgSet.isEmpty()) {
/*  949 */                 this.packagesMap.remove(pkgName);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  957 */         this.loaderToPackagesMap.remove(cl);
/*  958 */         for (i = this.packagesMap.entrySet().iterator(); i.hasNext(); )
/*      */         {
/*  960 */           Map.Entry entry = (Map.Entry)i.next();
/*  961 */           Set pkgSet = (Set)entry.getValue();
/*  962 */           if (pkgSet.contains(cl))
/*      */           {
/*  964 */             if (pkgSet.size() > 1)
/*      */             {
/*  966 */               Set newSet = ClassLoaderUtils.newPackageSet();
/*  967 */               newSet.addAll(pkgSet);
/*  968 */               newSet.remove(cl);
/*  969 */               this.packagesMap.put(entry.getKey(), newSet);
/*      */             }
/*      */             else
/*      */             {
/*  973 */               pkgSet = Collections.emptySet();
/*      */             }
/*      */           }
/*  976 */           if (pkgSet.isEmpty()) {
/*  977 */             i.remove();
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  983 */     for (int n = 0; n < removeNotifications.size(); n++)
/*      */     {
/*  985 */       Notification msg = (Notification)removeNotifications.get(n);
/*  986 */       this.broadcaster.sendNotification(msg);
/*      */     }
/*      */ 
/*  989 */     if ((NOTIFICATION_MODE == 0) || (NOTIFICATION_MODE == 1))
/*      */     {
/*  991 */       Notification msg = new Notification("jboss.mx.classloader.removed", this, getNextSequenceNumber());
/*  992 */       if (NOTIFICATION_MODE == 1)
/*  993 */         msg.setUserData(new WeakReference(cl));
/*      */       else
/*  995 */         msg.setUserData(cl);
/*  996 */       this.broadcaster.sendNotification(msg);
/*      */     }
/*      */   }
/*      */ 
/*      */   public LoaderRepository registerClassLoader(RepositoryClassLoader ucl)
/*      */   {
/* 1011 */     addClassLoader(ucl);
/* 1012 */     if ((NOTIFICATION_MODE == 0) || (NOTIFICATION_MODE == 1))
/*      */     {
/* 1014 */       Notification msg = new Notification("jboss.mx.classloader.added", this, getNextSequenceNumber());
/* 1015 */       if (NOTIFICATION_MODE == 1)
/* 1016 */         msg.setUserData(new WeakReference(ucl));
/*      */       else
/* 1018 */         msg.setUserData(ucl);
/* 1019 */       this.broadcaster.sendNotification(msg);
/*      */     }
/*      */ 
/* 1022 */     return this;
/*      */   }
/*      */ 
/*      */   public LoaderRepository getInstance()
/*      */   {
/* 1030 */     return this;
/*      */   }
/*      */ 
/*      */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*      */     throws IllegalArgumentException
/*      */   {
/* 1046 */     this.broadcaster.addNotificationListener(listener, filter, handback);
/*      */   }
/*      */ 
/*      */   public MBeanNotificationInfo[] getNotificationInfo()
/*      */   {
/* 1055 */     if (this.info == null)
/*      */     {
/* 1057 */       if (NOTIFICATION_MODE != 2)
/*      */       {
/* 1059 */         this.info = new MBeanNotificationInfo[] { new MBeanNotificationInfo(new String[] { "CLASSLOADER_ADDED" }, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[] { "CLASS_REMOVED" }, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader") };
/*      */       }
/*      */       else
/*      */       {
/* 1071 */         this.info = new MBeanNotificationInfo[0];
/*      */       }
/*      */     }
/* 1074 */     return this.info;
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(NotificationListener listener)
/*      */     throws ListenerNotFoundException
/*      */   {
/* 1085 */     this.broadcaster.removeNotificationListener(listener);
/*      */   }
/*      */ 
/*      */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*      */     throws Exception
/*      */   {
/* 1092 */     return name;
/*      */   }
/*      */ 
/*      */   public void postRegister(Boolean registrationDone)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void preDeregister()
/*      */     throws Exception
/*      */   {
/*      */   }
/*      */ 
/*      */   public void postDeregister()
/*      */   {
/* 1106 */     log.debug("postDeregister, clearing all references");
/* 1107 */     this.classLoaders.clear();
/* 1108 */     this.dynamicClassLoaders.clear();
/* 1109 */     this.nonUCLClassLoader.clear();
/* 1110 */     this.classLoaderURLs.clear();
/* 1111 */     this.classes.clear();
/* 1112 */     this.loaderToClassesMap.clear();
/* 1113 */     this.loaderToResourcesMap.clear();
/* 1114 */     this.globalResources.clear();
/* 1115 */     this.packagesMap.clear();
/* 1116 */     this.loaderToPackagesMap.clear();
/*      */   }
/*      */ 
/*      */   private synchronized long getNextSequenceNumber()
/*      */   {
/* 1121 */     return this.sequenceNumber++;
/*      */   }
/*      */ 
/*      */   private RepositoryClassLoader getRepositoryClassLoader(ClassLoader cl, String name)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1127 */     if ((cl instanceof RepositoryClassLoader)) {
/* 1128 */       return (RepositoryClassLoader)cl;
/*      */     }
/*      */ 
/* 1131 */     RepositoryClassLoader rcl = getWrappingClassLoader(cl);
/* 1132 */     if (rcl == null)
/* 1133 */       throw new ClassNotFoundException("Class not found " + name + " (Unknown classloader " + cl + ")");
/* 1134 */     return rcl;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  169 */     String value = ClassToStringAction.getProperty("org.jboss.mx.loading.UnifiedLoaderRepository.notifyMode", "0");
/*  170 */     NOTIFICATION_MODE = Integer.valueOf(value).intValue();
/*  171 */     switch (NOTIFICATION_MODE)
/*      */     {
/*      */     case 0:
/*      */     case 1:
/*      */     case 2:
/*  176 */       break;
/*      */     default:
/*  178 */       log.warn("Invalid org.jboss.mx.loading.UnifiedLoaderRepository.notifyMode(" + value + "), defaulting to LEGACY_MODE");
/*      */ 
/*  180 */       NOTIFICATION_MODE = 0;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class PackageMapper
/*      */     implements ClassLoaderUtils.PkgNameListener
/*      */   {
/*      */     private RepositoryClassLoader loader;
/*      */ 
/*      */     PackageMapper(RepositoryClassLoader loader)
/*      */     {
/* 1143 */       this.loader = loader;
/*      */     }
/*      */ 
/*      */     public void addPackage(String pkgName)
/*      */     {
/* 1148 */       if ((pkgName.startsWith("META-INF")) || (pkgName.startsWith("WEB-INF"))) {
/* 1149 */         return;
/*      */       }
/* 1151 */       Set pkgSet = (Set)UnifiedLoaderRepository3.this.packagesMap.get(pkgName);
/* 1152 */       if (pkgSet == null)
/*      */       {
/* 1154 */         pkgSet = ClassLoaderUtils.newPackageSet();
/* 1155 */         UnifiedLoaderRepository3.this.packagesMap.put(pkgName, pkgSet);
/*      */       }
/* 1157 */       if (!pkgSet.contains(this.loader))
/*      */       {
/* 1160 */         Set newSet = ClassLoaderUtils.newPackageSet();
/* 1161 */         newSet.addAll(pkgSet);
/* 1162 */         pkgSet = newSet;
/*      */ 
/* 1164 */         pkgSet.add(this.loader);
/* 1165 */         UnifiedLoaderRepository3.this.packagesMap.put(pkgName, newSet);
/* 1166 */         List loaderPkgNames = (List)UnifiedLoaderRepository3.this.loaderToPackagesMap.get(this.loader);
/* 1167 */         if (loaderPkgNames == null)
/*      */         {
/* 1169 */           loaderPkgNames = new ArrayList();
/* 1170 */           UnifiedLoaderRepository3.this.loaderToPackagesMap.put(this.loader, loaderPkgNames);
/*      */         }
/* 1172 */         loaderPkgNames.add(pkgName);
/*      */ 
/* 1175 */         if (pkgSet.size() > 1)
/*      */         {
/* 1177 */           UnifiedLoaderRepository3.log.debug("Multiple class loaders found for pkg: " + pkgName);
/*      */         }
/* 1179 */         if (UnifiedLoaderRepository3.log.isTraceEnabled())
/* 1180 */           UnifiedLoaderRepository3.log.trace("Indexed pkg: " + pkgName + ", UCL: " + this.loader);
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.UnifiedLoaderRepository3
 * JD-Core Version:    0.6.0
 */