/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import org.jboss.classloading.spi.ClassLoadingDomain;
/*     */ import org.jboss.classloading.spi.DomainClassLoader;
/*     */ import org.jboss.classloading.spi.Translator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.ServerConstants;
/*     */ 
/*     */ public abstract class LoaderRepositoryDomain
/*     */   implements ServerConstants, ClassLoadingDomain
/*     */ {
/*  49 */   protected static Vector loaders = new Vector();
/*  50 */   protected static LoaderRepositoryDomain instance = null;
/*  51 */   protected Translator translator = null;
/*     */ 
/*  56 */   private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
/*     */   private static HashMap nativeClassBySignature;
/*  65 */   private static final Logger log = Logger.getLogger(LoaderRepositoryDomain.class);
/*     */ 
/*     */   public Vector getLoaders()
/*     */   {
/*  96 */     return loaders;
/*     */   }
/*     */ 
/*     */   public URL[] getURLs()
/*     */   {
/* 101 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getCachedClass(String classname)
/*     */   {
/* 106 */     return (Class)this.classes.get(classname);
/*     */   }
/*     */ 
/*     */   public Translator getTranslator()
/*     */   {
/* 111 */     return this.translator;
/*     */   }
/*     */ 
/*     */   public void setTranslator(Translator t)
/*     */   {
/* 116 */     this.translator = t;
/*     */   }
/*     */ 
/*     */   public int compare(LoaderRepositoryDomain lr)
/*     */   {
/* 127 */     if (lr == this) {
/* 128 */       return 0;
/*     */     }
/* 130 */     return 1;
/*     */   }
/*     */ 
/*     */   public abstract Class loadClass(String paramString)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public abstract Class loadClass(String paramString, boolean paramBoolean, DomainClassLoader paramDomainClassLoader)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public abstract DomainClassLoader newClassLoader(URL paramURL, boolean paramBoolean)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract DomainClassLoader newClassLoader(URL paramURL1, URL paramURL2, boolean paramBoolean)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract URL getResource(String paramString, DomainClassLoader paramDomainClassLoader);
/*     */ 
/*     */   public abstract void getResources(String paramString, DomainClassLoader paramDomainClassLoader, List paramList);
/*     */ 
/*     */   public abstract void addClassLoader(DomainClassLoader paramDomainClassLoader);
/*     */ 
/*     */   public abstract boolean addClassLoaderURL(DomainClassLoader paramDomainClassLoader, URL paramURL);
/*     */ 
/*     */   public abstract void removeClassLoader(DomainClassLoader paramDomainClassLoader);
/*     */ 
/*     */   public static final Class getNativeClassForName(String className)
/*     */   {
/* 219 */     return (Class)nativeClassBySignature.get(className);
/*     */   }
/*     */ 
/*     */   protected int reverseCompare(LoaderRepositoryDomain lr)
/*     */   {
/* 230 */     return 0;
/*     */   }
/*     */ 
/*     */   void cacheLoadedClass(String name, Class cls, DomainClassLoader cl)
/*     */   {
/* 238 */     synchronized (this.classes)
/*     */     {
/* 241 */       this.classes.put(name, cls);
/* 242 */       if (log.isTraceEnabled())
/*     */       {
/* 244 */         log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", cl: " + cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void clear()
/*     */   {
/* 261 */     this.classes.clear();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  72 */     nativeClassBySignature = new HashMap();
/*  73 */     nativeClassBySignature.put("boolean", Boolean.TYPE);
/*  74 */     nativeClassBySignature.put("byte", Byte.TYPE);
/*  75 */     nativeClassBySignature.put("char", Character.TYPE);
/*  76 */     nativeClassBySignature.put("double", Double.TYPE);
/*  77 */     nativeClassBySignature.put("float", Float.TYPE);
/*  78 */     nativeClassBySignature.put("int", Integer.TYPE);
/*  79 */     nativeClassBySignature.put("long", Long.TYPE);
/*  80 */     nativeClassBySignature.put("short", Short.TYPE);
/*  81 */     nativeClassBySignature.put("void", Void.TYPE);
/*     */ 
/*  83 */     nativeClassBySignature.put("boolean[]", [Z.class);
/*  84 */     nativeClassBySignature.put("byte[]", [B.class);
/*  85 */     nativeClassBySignature.put("char[]", [C.class);
/*  86 */     nativeClassBySignature.put("double[]", [D.class);
/*  87 */     nativeClassBySignature.put("float[]", [F.class);
/*  88 */     nativeClassBySignature.put("int[]", [I.class);
/*  89 */     nativeClassBySignature.put("long[]", [J.class);
/*  90 */     nativeClassBySignature.put("short[]", [S.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.LoaderRepositoryDomain
 * JD-Core Version:    0.6.0
 */