/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Vector;
/*     */ import javax.management.loading.ClassLoaderRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.ServerConstants;
/*     */ import org.jboss.util.loading.Translator;
/*     */ 
/*     */ public abstract class LoaderRepository
/*     */   implements ServerConstants, ClassLoaderRepository
/*     */ {
/*  48 */   protected static Vector loaders = new Vector();
/*  49 */   protected static LoaderRepository instance = null;
/*  50 */   protected Translator translator = null;
/*     */ 
/*  55 */   private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
/*     */   private static HashMap nativeClassBySignature;
/*  64 */   private static final Logger log = Logger.getLogger(LoaderRepository.class);
/*     */ 
/*     */   public Vector getLoaders()
/*     */   {
/*  95 */     return loaders;
/*     */   }
/*     */ 
/*     */   public URL[] getURLs()
/*     */   {
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getCachedClass(String classname)
/*     */   {
/* 105 */     return (Class)this.classes.get(classname);
/*     */   }
/*     */ 
/*     */   public Translator getTranslator()
/*     */   {
/* 110 */     return this.translator;
/*     */   }
/*     */ 
/*     */   public void setTranslator(Translator t)
/*     */   {
/* 115 */     this.translator = t;
/*     */   }
/*     */ 
/*     */   public int compare(LoaderRepository lr)
/*     */   {
/* 126 */     if (lr == this) {
/* 127 */       return 0;
/*     */     }
/* 129 */     return -lr.reverseCompare(this);
/*     */   }
/*     */ 
/*     */   public abstract Class loadClass(String paramString)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public abstract Class loadClassWithout(ClassLoader paramClassLoader, String paramString)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public abstract Class loadClassBefore(ClassLoader paramClassLoader, String paramString)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public abstract RepositoryClassLoader newClassLoader(URL paramURL, boolean paramBoolean)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract RepositoryClassLoader newClassLoader(URL paramURL1, URL paramURL2, boolean paramBoolean)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract Class loadClass(String paramString, boolean paramBoolean, ClassLoader paramClassLoader)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public abstract URL getResource(String paramString, ClassLoader paramClassLoader);
/*     */ 
/*     */   public abstract void getResources(String paramString, ClassLoader paramClassLoader, List paramList);
/*     */ 
/*     */   public abstract void addClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */   public abstract boolean addClassLoaderURL(ClassLoader paramClassLoader, URL paramURL);
/*     */ 
/*     */   public abstract void removeClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */   public static final Class getNativeClassForName(String className)
/*     */   {
/* 244 */     return (Class)nativeClassBySignature.get(className);
/*     */   }
/*     */ 
/*     */   protected int reverseCompare(LoaderRepository lr)
/*     */   {
/* 255 */     return 0;
/*     */   }
/*     */ 
/*     */   void cacheLoadedClass(String name, Class cls, ClassLoader cl)
/*     */   {
/* 263 */     synchronized (this.classes)
/*     */     {
/* 266 */       this.classes.put(name, cls);
/* 267 */       if (log.isTraceEnabled())
/*     */       {
/* 269 */         log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", cl: " + cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void clear()
/*     */   {
/* 286 */     this.classes.clear();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  71 */     nativeClassBySignature = new HashMap();
/*  72 */     nativeClassBySignature.put("boolean", Boolean.TYPE);
/*  73 */     nativeClassBySignature.put("byte", Byte.TYPE);
/*  74 */     nativeClassBySignature.put("char", Character.TYPE);
/*  75 */     nativeClassBySignature.put("double", Double.TYPE);
/*  76 */     nativeClassBySignature.put("float", Float.TYPE);
/*  77 */     nativeClassBySignature.put("int", Integer.TYPE);
/*  78 */     nativeClassBySignature.put("long", Long.TYPE);
/*  79 */     nativeClassBySignature.put("short", Short.TYPE);
/*  80 */     nativeClassBySignature.put("void", Void.TYPE);
/*     */ 
/*  82 */     nativeClassBySignature.put("boolean[]", [Z.class);
/*  83 */     nativeClassBySignature.put("byte[]", [B.class);
/*  84 */     nativeClassBySignature.put("char[]", [C.class);
/*  85 */     nativeClassBySignature.put("double[]", [D.class);
/*  86 */     nativeClassBySignature.put("float[]", [F.class);
/*  87 */     nativeClassBySignature.put("int[]", [I.class);
/*  88 */     nativeClassBySignature.put("long[]", [J.class);
/*  89 */     nativeClassBySignature.put("short[]", [S.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.LoaderRepository
 * JD-Core Version:    0.6.0
 */