/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.classloading.spi.DomainClassLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class LoadMgrDCL
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(LoadMgrDCL.class);
/*     */ 
/*  53 */   private static Object registrationLock = new Object();
/*     */ 
/*  58 */   private static HashMap loadClassThreads = new HashMap();
/*     */ 
/*  62 */   private static Map loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/*  64 */   private static SecurityManager sm = System.getSecurityManager();
/*     */ 
/*     */   public static void registerLoaderThread(DomainClassLoader ucl, Thread t)
/*     */   {
/* 123 */     synchronized (registrationLock)
/*     */     {
/* 125 */       Object prevThread = loadClassThreads.put(ucl, t);
/* 126 */       if (log.isTraceEnabled()) {
/* 127 */         log.trace("registerLoaderThread, ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
/*     */       }
/* 129 */       synchronized (loadTasksByThread)
/*     */       {
/* 131 */         List taskList = (List)loadTasksByThread.get(t);
/* 132 */         if (taskList == null)
/*     */         {
/* 134 */           taskList = Collections.synchronizedList(new LinkedList());
/* 135 */           loadTasksByThread.put(t, taskList);
/* 136 */           if (log.isTraceEnabled())
/* 137 */             log.trace("created new task list");
/*     */         }
/*     */       }
/* 140 */       registrationLock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean beginLoadTask(ClassLoadingTaskDCL task, UnifiedLoaderRepositoryDCL repository)
/*     */     throws ClassNotFoundException
/*     */   {
/* 163 */     boolean trace = log.isTraceEnabled();
/* 164 */     if (trace) {
/* 165 */       log.trace("Begin beginLoadTask, task=" + task);
/*     */     }
/*     */ 
/* 168 */     Class cls = repository.loadClassFromCache(task.classname);
/* 169 */     if (cls != null)
/*     */     {
/* 171 */       task.loadedClass = cls;
/* 172 */       task.state = 4;
/* 173 */       if (trace)
/* 174 */         log.trace("End beginLoadTask, loadClassFromCache, classname: " + task.classname);
/* 175 */       return true;
/*     */     }
/*     */ 
/* 179 */     Set pkgSet = repository.getPackageClassLoaders(task.classname);
/* 180 */     if ((pkgSet == null) || (pkgSet.size() == 0))
/*     */     {
/* 182 */       if (task.stopOrder == 2147483647)
/*     */       {
/*     */         try
/*     */         {
/* 190 */           cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
/*     */         }
/*     */         catch (LinkageError e)
/*     */         {
/* 195 */           if (trace)
/* 196 */             log.trace("End beginLoadTask, LinkageError for task: " + task, e);
/* 197 */           throw e;
/*     */         }
/* 199 */         if (cls != null)
/*     */         {
/* 201 */           task.loadedClass = cls;
/* 202 */           task.state = 4;
/* 203 */           if (trace)
/* 204 */             log.trace("End beginLoadTask, loadClassFromClassLoader");
/* 205 */           return true;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 210 */       if (trace)
/* 211 */         log.trace("End beginLoadTask, ClassNotFoundException");
/* 212 */       String msg = "No ClassLoaders found for: " + task.classname;
/* 213 */       throw new ClassNotFoundException(msg);
/*     */     }
/*     */ 
/* 231 */     Iterator iter = pkgSet.iterator();
/* 232 */     DomainClassLoaderUCLImpl theUCL = null;
/* 233 */     int order = 2147483647;
/* 234 */     while (iter.hasNext())
/*     */     {
/* 236 */       Object next = iter.next();
/*     */       int uclOrder;
/*     */       DomainClassLoaderUCLImpl ucl;
/*     */       int uclOrder;
/* 240 */       if ((next instanceof DomainClassLoaderUCLImpl))
/*     */       {
/* 242 */         DomainClassLoaderUCLImpl ucl = (DomainClassLoaderUCLImpl)next;
/* 243 */         uclOrder = 0;
/*     */       }
/*     */       else
/*     */       {
/* 247 */         PkgClassLoader pkgUcl = (PkgClassLoader)next;
/* 248 */         ucl = pkgUcl.ucl;
/* 249 */         uclOrder = pkgUcl.order;
/*     */       }
/*     */ 
/* 253 */       if ((task.stopOrder != 2147483647) && (task.stopOrder <= uclOrder))
/*     */       {
/*     */         break;
/*     */       }
/* 257 */       String classRsrcName = task.classname.replace('.', '/') + ".class";
/* 258 */       URL url = null;
/* 259 */       if (sm != null)
/*     */       {
/* 261 */         ResourceAction action = new ResourceAction(ucl, classRsrcName);
/* 262 */         url = (URL)AccessController.doPrivileged(action);
/*     */       }
/*     */       else
/*     */       {
/* 266 */         url = ucl.loadResourceLocally(classRsrcName);
/*     */       }
/*     */ 
/* 269 */       if ((url != null) && (uclOrder < order))
/*     */       {
/* 271 */         if ((trace) && (theUCL != null))
/* 272 */           log.trace("Replacing UCL: " + theUCL + " with UCL:" + ucl);
/* 273 */         theUCL = ucl;
/* 274 */         order = uclOrder;
/*     */       }
/*     */     }
/* 277 */     if ((theUCL == null) && (task.stopOrder == 2147483647))
/*     */     {
/*     */       try
/*     */       {
/* 285 */         cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
/*     */       }
/*     */       catch (LinkageError e)
/*     */       {
/* 290 */         if (trace)
/* 291 */           log.trace("End beginLoadTask, LinkageError for task: " + task, e);
/* 292 */         throw e;
/*     */       }
/* 294 */       if (cls != null)
/*     */       {
/* 296 */         task.loadedClass = cls;
/* 297 */         task.state = 4;
/* 298 */         if (trace)
/* 299 */           log.trace("End beginLoadTask, loadClassFromClassLoader");
/* 300 */         return true;
/*     */       }
/*     */ 
/* 304 */       if (trace)
/* 305 */         log.trace("End beginLoadTask, ClassNotFoundException");
/* 306 */       String msg = "No ClassLoaders found for: " + task.classname;
/* 307 */       throw new ClassNotFoundException(msg);
/*     */     }
/*     */ 
/* 310 */     if (theUCL == null)
/*     */     {
/* 312 */       if (trace)
/* 313 */         log.trace("End beginLoadTask, ClassNotFoundException");
/* 314 */       String msg = "No ClassLoaders found for: " + task.classname;
/* 315 */       throw new ClassNotFoundException(msg);
/*     */     }
/*     */ 
/* 318 */     scheduleTask(task, theUCL, order, false, trace);
/* 319 */     task.state = 1;
/* 320 */     if (trace) {
/* 321 */       log.trace("End beginLoadTask, task=" + task);
/*     */     }
/* 323 */     return false;
/*     */   }
/*     */ 
/*     */   public static void nextTask(Thread t, ClassLoadingTaskDCL task, UnifiedLoaderRepositoryDCL repository)
/*     */     throws InterruptedException
/*     */   {
/* 337 */     boolean trace = log.isTraceEnabled();
/* 338 */     List taskList = (List)loadTasksByThread.get(t);
/* 339 */     synchronized (taskList)
/*     */     {
/* 342 */       while ((taskList.size() == 0) && (task.threadTaskCount != 0))
/*     */       {
/* 347 */         if (trace)
/* 348 */           log.trace("Begin nextTask(WAIT_ON_EVENT), task=" + task);
/*     */         try
/*     */         {
/* 351 */           task.state = 3;
/* 352 */           taskList.wait();
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 356 */           if (trace) {
/* 357 */             log.trace("nextTask(WAIT_ON_EVENT), interrupted, task=" + task, e);
/*     */           }
/* 359 */           throw e;
/*     */         }
/* 361 */         if (trace) {
/* 362 */           log.trace("nextTask(WAIT_ON_EVENT), notified, task=" + task);
/*     */         }
/*     */       }
/* 365 */       if (trace) {
/* 366 */         log.trace("Continue nextTask(" + taskList.size() + "), task=" + task);
/*     */       }
/*     */ 
/* 369 */       if (task.threadTaskCount == 0)
/*     */       {
/* 371 */         task.state = 4;
/* 372 */         log.trace("End nextTask(FINISHED), task=" + task);
/* 373 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 377 */     ClassLoadingTaskDCL.ThreadTask threadTask = (ClassLoadingTaskDCL.ThreadTask)taskList.remove(0);
/* 378 */     ClassLoadingTaskDCL loadTask = threadTask.getLoadTask();
/* 379 */     if (trace) {
/* 380 */       log.trace("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask);
/*     */     }
/* 382 */     DomainClassLoaderUCLImpl ucl3 = threadTask.ucl;
/*     */     try
/*     */     {
/* 385 */       if (threadTask.t == null)
/*     */       {
/* 391 */         if (trace)
/* 392 */           log.trace("Rescheduling threadTask=" + threadTask);
/* 393 */         scheduleTask(loadTask, ucl3, threadTask.order, true, trace);
/*     */       }
/*     */       else
/*     */       {
/* 397 */         if (trace) {
/* 398 */           log.trace("Running threadTask=" + threadTask);
/*     */         }
/* 400 */         threadTask.run();
/*     */       }
/*     */ 
/* 435 */       if (threadTask.releaseInNextTask == true)
/*     */       {
/* 437 */         if (trace)
/* 438 */           log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
/* 439 */         synchronized (registrationLock)
/*     */         {
/* 441 */           loadClassThreads.remove(threadTask.ucl);
/*     */         }
/* 443 */         synchronized (threadTask.ucl)
/*     */         {
/* 445 */           ucl3.release();
/* 446 */           ucl3.notifyAll();
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 405 */       if ((e instanceof ClassCircularityError))
/*     */       {
/*     */         try
/*     */         {
/* 412 */           if (trace) {
/* 413 */             log.trace("Run failed with exception", e);
/*     */           }
/* 415 */           scheduleTask(loadTask, ucl3, 2147483647, true, trace);
/*     */         }
/*     */         catch (ClassNotFoundException ex)
/*     */         {
/* 419 */           loadTask.setLoadError(ex);
/* 420 */           log.warn("Failed to reschedule task after CCE", ex);
/*     */         }
/* 422 */         if (trace)
/* 423 */           log.trace("Post CCE state, loadTask=" + loadTask);
/*     */       }
/*     */       else
/*     */       {
/* 427 */         loadTask.setLoadError(e);
/* 428 */         if (trace) {
/* 429 */           log.trace("Run failed with exception", e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 435 */       if (threadTask.releaseInNextTask == true)
/*     */       {
/* 437 */         if (trace)
/* 438 */           log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
/* 439 */         synchronized (registrationLock)
/*     */         {
/* 441 */           loadClassThreads.remove(threadTask.ucl);
/*     */         }
/* 443 */         synchronized (threadTask.ucl)
/*     */         {
/* 445 */           ucl3.release();
/* 446 */           ucl3.notifyAll();
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 435 */       if (threadTask.releaseInNextTask == true)
/*     */       {
/* 437 */         if (trace)
/* 438 */           log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
/* 439 */         synchronized (registrationLock)
/*     */         {
/* 441 */           loadClassThreads.remove(threadTask.ucl);
/*     */         }
/* 443 */         synchronized (threadTask.ucl)
/*     */         {
/* 445 */           ucl3.release();
/* 446 */           ucl3.notifyAll();
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 452 */     if (loadTask.threadTaskCount == 0)
/*     */     {
/* 454 */       Class loadedClass = threadTask.getLoadedClass();
/* 455 */       if (loadedClass != null)
/*     */       {
/* 457 */         ClassLoader loader = loadedClass.getClassLoader();
/* 458 */         ClassLoader wrapper = null;
/* 459 */         if (wrapper != null) {
/* 460 */           loader = wrapper;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 473 */       List loadTaskThreadTasks = (List)loadTasksByThread.get(loadTask.requestingThread);
/* 474 */       synchronized (loadTaskThreadTasks)
/*     */       {
/* 476 */         if (trace)
/* 477 */           log.trace("Notifying task of thread completion, loadTask:" + loadTask);
/* 478 */         loadTask.state = 4;
/* 479 */         loadTaskThreadTasks.notify();
/*     */       }
/*     */     }
/* 482 */     if (trace)
/* 483 */       log.trace("End nextTask(" + taskList.size() + "), loadTask=" + loadTask);
/*     */   }
/*     */ 
/*     */   public static void endLoadTask(ClassLoadingTaskDCL task)
/*     */   {
/* 491 */     boolean trace = log.isTraceEnabled();
/* 492 */     if (trace) {
/* 493 */       log.trace("Begin endLoadTask, task=" + task);
/*     */     }
/*     */ 
/* 496 */     synchronized (registrationLock)
/*     */     {
/* 498 */       loadClassThreads.remove(task.requestingClassLoader);
/* 499 */       registrationLock.notifyAll();
/*     */     }
/*     */ 
/* 503 */     List taskList = (List)loadTasksByThread.get(task.requestingThread);
/* 504 */     int size = taskList != null ? taskList.size() : 0;
/* 505 */     synchronized (taskList)
/*     */     {
/* 507 */       for (int i = 0; i < size; i++)
/*     */       {
/* 509 */         ClassLoadingTaskDCL.ThreadTask threadTask = (ClassLoadingTaskDCL.ThreadTask)taskList.remove(0);
/* 510 */         ClassLoadingTaskDCL loadTask = threadTask.getLoadTask();
/*     */ 
/* 527 */         if (trace)
/* 528 */           log.trace("Reassigning task: " + threadTask + ", to: " + loadTask.requestingThread);
/* 529 */         threadTask.t = null;
/*     */ 
/* 531 */         List toTaskList = (List)loadTasksByThread.get(loadTask.requestingThread);
/* 532 */         synchronized (toTaskList)
/*     */         {
/* 534 */           toTaskList.add(0, threadTask);
/* 535 */           loadTask.state = 2;
/* 536 */           toTaskList.notify();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void scheduleTask(ClassLoadingTaskDCL task, DomainClassLoaderUCLImpl ucl, int order, boolean reschedule, boolean trace)
/*     */     throws ClassNotFoundException
/*     */   {
/* 556 */     Thread t = null;
/* 557 */     boolean releaseInNextTask = false;
/* 558 */     ClassLoadingTaskDCL.ThreadTask subtask = null;
/* 559 */     List taskList = null;
/* 560 */     synchronized (registrationLock)
/*     */     {
/* 563 */       t = (Thread)loadClassThreads.get(ucl);
/* 564 */       if (t == null)
/*     */       {
/* 574 */         while ((t == null) && (!ucl.attempt(1L)))
/*     */         {
/* 576 */           if (trace)
/* 577 */             log.trace("Waiting for owner of UCL: " + ucl);
/*     */           try
/*     */           {
/* 580 */             registrationLock.wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 584 */             String msg = "Interrupted waiting for registration notify, classame: " + task.classname;
/*     */ 
/* 586 */             throw new ClassNotFoundException(msg);
/*     */           }
/*     */ 
/* 589 */           t = (Thread)loadClassThreads.get(ucl);
/* 590 */           if (trace) {
/* 591 */             log.trace("Notified that UCL owner is: " + t);
/*     */           }
/*     */         }
/*     */ 
/* 595 */         t = (Thread)loadClassThreads.get(ucl);
/* 596 */         if (t == null)
/*     */         {
/* 599 */           releaseInNextTask = true;
/* 600 */           t = task.requestingThread;
/* 601 */           Object prevThread = loadClassThreads.put(ucl, t);
/* 602 */           if (trace)
/*     */           {
/* 604 */             log.trace("scheduleTask, taking ownership of ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 611 */       subtask = task.newThreadTask(ucl, t, order, reschedule, releaseInNextTask);
/*     */ 
/* 614 */       taskList = (List)loadTasksByThread.get(t);
/* 615 */       synchronized (taskList)
/*     */       {
/* 617 */         taskList.add(subtask);
/*     */ 
/* 619 */         Collections.sort(taskList, ClassLoadingTaskDCL.taskComparator);
/* 620 */         taskList.notify();
/*     */       }
/*     */     }
/*     */ 
/* 624 */     if (trace)
/* 625 */       log.trace("scheduleTask(" + taskList.size() + "), created subtask: " + subtask);
/*     */   }
/*     */ 
/*     */   private static class ResourceAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     DomainClassLoader ucl;
/*     */     String classRsrcName;
/*     */ 
/*     */     ResourceAction(DomainClassLoader ucl, String classRsrcName)
/*     */     {
/* 105 */       this.ucl = ucl;
/* 106 */       this.classRsrcName = classRsrcName;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 110 */       URL url = this.ucl.loadResourceLocally(this.classRsrcName);
/* 111 */       this.ucl = null;
/* 112 */       this.classRsrcName = null;
/* 113 */       return url;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class PkgClassLoader
/*     */   {
/*     */     public final DomainClassLoaderUCLImpl ucl;
/*     */     public final int order;
/*     */ 
/*     */     public PkgClassLoader(DomainClassLoaderUCLImpl ucl)
/*     */     {
/*  78 */       this(ucl, 2147483647);
/*     */     }
/*     */ 
/*     */     public PkgClassLoader(DomainClassLoaderUCLImpl ucl, int order) {
/*  82 */       this.ucl = ucl;
/*  83 */       this.order = order;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/*  88 */       StringBuffer buffer = new StringBuffer(100);
/*  89 */       buffer.append(super.toString());
/*  90 */       buffer.append("{ucl=").append(this.ucl);
/*  91 */       buffer.append(" order=").append(this.order);
/*  92 */       buffer.append('}');
/*  93 */       return buffer.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.LoadMgrDCL
 * JD-Core Version:    0.6.0
 */