/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class LoadMgr3
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(LoadMgr3.class);
/*     */ 
/*  52 */   private static Object registrationLock = new Object();
/*     */ 
/*  57 */   private static HashMap loadClassThreads = new HashMap();
/*     */ 
/*  61 */   private static Map loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/*  63 */   private static SecurityManager sm = System.getSecurityManager();
/*     */ 
/*     */   public static void registerLoaderThread(RepositoryClassLoader ucl, Thread t)
/*     */   {
/* 122 */     synchronized (registrationLock)
/*     */     {
/* 124 */       Object prevThread = loadClassThreads.put(ucl, t);
/* 125 */       if (log.isTraceEnabled()) {
/* 126 */         log.trace("registerLoaderThread, ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
/*     */       }
/* 128 */       synchronized (loadTasksByThread)
/*     */       {
/* 130 */         List taskList = (List)loadTasksByThread.get(t);
/* 131 */         if (taskList == null)
/*     */         {
/* 133 */           taskList = Collections.synchronizedList(new LinkedList());
/* 134 */           loadTasksByThread.put(t, taskList);
/* 135 */           if (log.isTraceEnabled())
/* 136 */             log.trace("created new task list");
/*     */         }
/*     */       }
/* 139 */       registrationLock.notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean beginLoadTask(ClassLoadingTask task, UnifiedLoaderRepository3 repository)
/*     */     throws ClassNotFoundException
/*     */   {
/* 162 */     boolean trace = log.isTraceEnabled();
/* 163 */     if (trace) {
/* 164 */       log.trace("Begin beginLoadTask, task=" + task);
/*     */     }
/*     */ 
/* 167 */     Class cls = repository.loadClassFromCache(task.classname);
/* 168 */     if (cls != null)
/*     */     {
/* 170 */       task.loadedClass = cls;
/* 171 */       task.state = 4;
/* 172 */       if (trace)
/* 173 */         log.trace("End beginLoadTask, loadClassFromCache, classname: " + task.classname);
/* 174 */       return true;
/*     */     }
/*     */ 
/* 178 */     Set pkgSet = repository.getPackageClassLoaders(task.classname);
/* 179 */     if ((pkgSet == null) || (pkgSet.size() == 0))
/*     */     {
/* 181 */       if (task.stopOrder == 2147483647)
/*     */       {
/*     */         try
/*     */         {
/* 189 */           cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
/*     */         }
/*     */         catch (LinkageError e)
/*     */         {
/* 194 */           if (trace)
/* 195 */             log.trace("End beginLoadTask, LinkageError for task: " + task, e);
/* 196 */           throw e;
/*     */         }
/* 198 */         if (cls != null)
/*     */         {
/* 200 */           task.loadedClass = cls;
/* 201 */           task.state = 4;
/* 202 */           if (trace)
/* 203 */             log.trace("End beginLoadTask, loadClassFromClassLoader");
/* 204 */           return true;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 209 */       if (trace)
/* 210 */         log.trace("End beginLoadTask, ClassNotFoundException");
/* 211 */       String msg = "No ClassLoaders found for: " + task.classname;
/* 212 */       throw new ClassNotFoundException(msg);
/*     */     }
/*     */ 
/* 230 */     Iterator iter = pkgSet.iterator();
/* 231 */     RepositoryClassLoader theUCL = null;
/* 232 */     int order = 2147483647;
/* 233 */     while (iter.hasNext())
/*     */     {
/* 235 */       Object next = iter.next();
/*     */       int uclOrder;
/*     */       RepositoryClassLoader ucl;
/*     */       int uclOrder;
/* 239 */       if ((next instanceof RepositoryClassLoader))
/*     */       {
/* 241 */         RepositoryClassLoader ucl = (RepositoryClassLoader)next;
/* 242 */         uclOrder = ucl.getAddedOrder();
/*     */       }
/*     */       else
/*     */       {
/* 246 */         PkgClassLoader pkgUcl = (PkgClassLoader)next;
/* 247 */         ucl = pkgUcl.ucl;
/* 248 */         uclOrder = pkgUcl.order;
/*     */       }
/*     */ 
/* 252 */       if ((task.stopOrder != 2147483647) && (task.stopOrder <= uclOrder))
/*     */       {
/*     */         break;
/*     */       }
/* 256 */       String classRsrcName = task.classname.replace('.', '/') + ".class";
/* 257 */       URL url = null;
/* 258 */       if (sm != null)
/*     */       {
/* 260 */         ResourceAction action = new ResourceAction(ucl, classRsrcName);
/* 261 */         url = (URL)AccessController.doPrivileged(action);
/*     */       }
/*     */       else
/*     */       {
/* 265 */         url = ucl.getResourceLocally(classRsrcName);
/*     */       }
/*     */ 
/* 268 */       if ((url != null) && (uclOrder < order))
/*     */       {
/* 270 */         if ((trace) && (theUCL != null))
/* 271 */           log.trace("Replacing UCL: " + theUCL + " with UCL:" + ucl);
/* 272 */         theUCL = ucl;
/* 273 */         order = uclOrder;
/*     */       }
/*     */     }
/* 276 */     if ((theUCL == null) && (task.stopOrder == 2147483647))
/*     */     {
/*     */       try
/*     */       {
/* 284 */         cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
/*     */       }
/*     */       catch (LinkageError e)
/*     */       {
/* 289 */         if (trace)
/* 290 */           log.trace("End beginLoadTask, LinkageError for task: " + task, e);
/* 291 */         throw e;
/*     */       }
/* 293 */       if (cls != null)
/*     */       {
/* 295 */         task.loadedClass = cls;
/* 296 */         task.state = 4;
/* 297 */         if (trace)
/* 298 */           log.trace("End beginLoadTask, loadClassFromClassLoader");
/* 299 */         return true;
/*     */       }
/*     */ 
/* 303 */       if (trace)
/* 304 */         log.trace("End beginLoadTask, ClassNotFoundException");
/* 305 */       String msg = "No ClassLoaders found for: " + task.classname;
/* 306 */       throw new ClassNotFoundException(msg);
/*     */     }
/*     */ 
/* 309 */     if (theUCL == null)
/*     */     {
/* 311 */       if (trace)
/* 312 */         log.trace("End beginLoadTask, ClassNotFoundException");
/* 313 */       String msg = "No ClassLoaders found for: " + task.classname;
/* 314 */       throw new ClassNotFoundException(msg);
/*     */     }
/*     */ 
/* 317 */     scheduleTask(task, theUCL, order, false, trace);
/* 318 */     task.state = 1;
/* 319 */     if (trace) {
/* 320 */       log.trace("End beginLoadTask, task=" + task);
/*     */     }
/* 322 */     return false;
/*     */   }
/*     */ 
/*     */   public static void nextTask(Thread t, ClassLoadingTask task, UnifiedLoaderRepository3 repository)
/*     */     throws InterruptedException
/*     */   {
/* 336 */     boolean trace = log.isTraceEnabled();
/* 337 */     List taskList = (List)loadTasksByThread.get(t);
/* 338 */     synchronized (taskList)
/*     */     {
/* 341 */       while ((taskList.size() == 0) && (task.threadTaskCount != 0))
/*     */       {
/* 346 */         if (trace)
/* 347 */           log.trace("Begin nextTask(WAIT_ON_EVENT), task=" + task);
/*     */         try
/*     */         {
/* 350 */           task.state = 3;
/* 351 */           taskList.wait();
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 355 */           if (trace) {
/* 356 */             log.trace("nextTask(WAIT_ON_EVENT), interrupted, task=" + task, e);
/*     */           }
/* 358 */           throw e;
/*     */         }
/* 360 */         if (trace) {
/* 361 */           log.trace("nextTask(WAIT_ON_EVENT), notified, task=" + task);
/*     */         }
/*     */       }
/* 364 */       if (trace) {
/* 365 */         log.trace("Continue nextTask(" + taskList.size() + "), task=" + task);
/*     */       }
/*     */ 
/* 368 */       if (task.threadTaskCount == 0)
/*     */       {
/* 370 */         task.state = 4;
/* 371 */         log.trace("End nextTask(FINISHED), task=" + task);
/* 372 */         return;
/*     */       }
/*     */     }
/*     */ 
/* 376 */     ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
/* 377 */     ClassLoadingTask loadTask = threadTask.getLoadTask();
/* 378 */     if (trace) {
/* 379 */       log.trace("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask);
/*     */     }
/* 381 */     RepositoryClassLoader ucl3 = threadTask.ucl;
/*     */     try
/*     */     {
/* 384 */       if (threadTask.t == null)
/*     */       {
/* 390 */         if (trace)
/* 391 */           log.trace("Rescheduling threadTask=" + threadTask);
/* 392 */         scheduleTask(loadTask, ucl3, threadTask.order, true, trace);
/*     */       }
/*     */       else
/*     */       {
/* 396 */         if (trace) {
/* 397 */           log.trace("Running threadTask=" + threadTask);
/*     */         }
/* 399 */         threadTask.run();
/*     */       }
/*     */ 
/* 437 */       if (threadTask.releaseInNextTask == true)
/*     */       {
/* 439 */         if (trace)
/* 440 */           log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
/* 441 */         synchronized (registrationLock)
/*     */         {
/* 443 */           loadClassThreads.remove(threadTask.ucl);
/*     */         }
/* 445 */         synchronized (threadTask.ucl)
/*     */         {
/* 447 */           ucl3.release();
/* 448 */           ucl3.notifyAll();
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 404 */       boolean retry = ((e instanceof ClassCircularityError)) || (e.getClass().equals(LinkageError.class));
/*     */ 
/* 406 */       int numCCE = loadTask.incNumCCE();
/* 407 */       if ((retry) && (numCCE <= 10))
/*     */       {
/*     */         try
/*     */         {
/* 414 */           if (trace) {
/* 415 */             log.trace("Run failed with exception", e);
/*     */           }
/* 417 */           scheduleTask(loadTask, ucl3, 2147483647, true, trace);
/*     */         }
/*     */         catch (Throwable ex)
/*     */         {
/* 421 */           loadTask.setLoadError(ex);
/* 422 */           log.warn("Failed to reschedule task after LinkageError", ex);
/*     */         }
/* 424 */         if (trace)
/* 425 */           log.trace("Post LinkageError state, loadTask=" + loadTask);
/*     */       }
/*     */       else
/*     */       {
/* 429 */         loadTask.setLoadError(e);
/* 430 */         if (trace) {
/* 431 */           log.trace("Run failed with exception, loadTask=" + loadTask, e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 437 */       if (threadTask.releaseInNextTask == true)
/*     */       {
/* 439 */         if (trace)
/* 440 */           log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
/* 441 */         synchronized (registrationLock)
/*     */         {
/* 443 */           loadClassThreads.remove(threadTask.ucl);
/*     */         }
/* 445 */         synchronized (threadTask.ucl)
/*     */         {
/* 447 */           ucl3.release();
/* 448 */           ucl3.notifyAll();
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 437 */       if (threadTask.releaseInNextTask == true)
/*     */       {
/* 439 */         if (trace)
/* 440 */           log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
/* 441 */         synchronized (registrationLock)
/*     */         {
/* 443 */           loadClassThreads.remove(threadTask.ucl);
/*     */         }
/* 445 */         synchronized (threadTask.ucl)
/*     */         {
/* 447 */           ucl3.release();
/* 448 */           ucl3.notifyAll();
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 454 */     if (loadTask.threadTaskCount == 0)
/*     */     {
/* 456 */       Class loadedClass = threadTask.getLoadedClass();
/* 457 */       if (loadedClass != null)
/*     */       {
/* 459 */         ClassLoader loader = loadedClass.getClassLoader();
/* 460 */         Object wrapper = repository.getWrappingClassLoader(loader);
/* 461 */         if (wrapper != null) {
/* 462 */           loader = (ClassLoader)wrapper;
/*     */         }
/* 464 */         repository.cacheLoadedClass(threadTask.getClassname(), loadedClass, loader);
/*     */       }
/*     */ 
/* 476 */       List loadTaskThreadTasks = (List)loadTasksByThread.get(loadTask.requestingThread);
/* 477 */       synchronized (loadTaskThreadTasks)
/*     */       {
/* 479 */         if (trace)
/* 480 */           log.trace("Notifying task of thread completion, loadTask:" + loadTask);
/* 481 */         loadTask.state = 4;
/* 482 */         loadTaskThreadTasks.notify();
/*     */       }
/*     */     }
/* 485 */     if (trace)
/* 486 */       log.trace("End nextTask(" + taskList.size() + "), loadTask=" + loadTask);
/*     */   }
/*     */ 
/*     */   public static void endLoadTask(ClassLoadingTask task)
/*     */   {
/* 494 */     boolean trace = log.isTraceEnabled();
/* 495 */     if (trace) {
/* 496 */       log.trace("Begin endLoadTask, task=" + task);
/*     */     }
/*     */ 
/* 499 */     synchronized (registrationLock)
/*     */     {
/* 501 */       loadClassThreads.remove(task.requestingClassLoader);
/* 502 */       registrationLock.notifyAll();
/*     */     }
/*     */ 
/* 506 */     List taskList = (List)loadTasksByThread.get(task.requestingThread);
/* 507 */     int size = taskList != null ? taskList.size() : 0;
/* 508 */     synchronized (taskList)
/*     */     {
/* 510 */       for (int i = 0; i < size; i++)
/*     */       {
/* 512 */         ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
/* 513 */         ClassLoadingTask loadTask = threadTask.getLoadTask();
/*     */ 
/* 530 */         if (trace)
/* 531 */           log.trace("Reassigning task: " + threadTask + ", to: " + loadTask.requestingThread);
/* 532 */         threadTask.t = null;
/*     */ 
/* 534 */         List toTaskList = (List)loadTasksByThread.get(loadTask.requestingThread);
/* 535 */         synchronized (toTaskList)
/*     */         {
/* 537 */           toTaskList.add(0, threadTask);
/* 538 */           loadTask.state = 2;
/* 539 */           toTaskList.notify();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void scheduleTask(ClassLoadingTask task, RepositoryClassLoader ucl, int order, boolean reschedule, boolean trace)
/*     */     throws ClassNotFoundException
/*     */   {
/* 559 */     Thread t = null;
/* 560 */     boolean releaseInNextTask = false;
/* 561 */     ClassLoadingTask.ThreadTask subtask = null;
/* 562 */     List taskList = null;
/* 563 */     synchronized (registrationLock)
/*     */     {
/* 566 */       t = (Thread)loadClassThreads.get(ucl);
/* 567 */       if (t == null)
/*     */       {
/* 577 */         while ((t == null) && (!ucl.attempt(1L)))
/*     */         {
/* 579 */           if (trace)
/* 580 */             log.trace("Waiting for owner of UCL: " + ucl);
/*     */           try
/*     */           {
/* 583 */             registrationLock.wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 587 */             String msg = "Interrupted waiting for registration notify, classame: " + task.classname;
/*     */ 
/* 589 */             throw new ClassNotFoundException(msg);
/*     */           }
/*     */ 
/* 592 */           t = (Thread)loadClassThreads.get(ucl);
/* 593 */           if (trace) {
/* 594 */             log.trace("Notified that UCL owner is: " + t);
/*     */           }
/*     */         }
/*     */ 
/* 598 */         t = (Thread)loadClassThreads.get(ucl);
/* 599 */         if (t == null)
/*     */         {
/* 602 */           releaseInNextTask = true;
/* 603 */           t = task.requestingThread;
/* 604 */           Object prevThread = loadClassThreads.put(ucl, t);
/* 605 */           if (trace)
/*     */           {
/* 607 */             log.trace("scheduleTask, taking ownership of ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 614 */       subtask = task.newThreadTask(ucl, t, order, reschedule, releaseInNextTask);
/*     */ 
/* 617 */       taskList = (List)loadTasksByThread.get(t);
/* 618 */       synchronized (taskList)
/*     */       {
/* 620 */         taskList.add(subtask);
/*     */ 
/* 622 */         Collections.sort(taskList, ClassLoadingTask.taskComparator);
/* 623 */         taskList.notify();
/*     */       }
/*     */     }
/*     */ 
/* 627 */     if (trace)
/* 628 */       log.trace("scheduleTask(" + taskList.size() + "), created subtask: " + subtask);
/*     */   }
/*     */ 
/*     */   private static class ResourceAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     RepositoryClassLoader ucl;
/*     */     String classRsrcName;
/*     */ 
/*     */     ResourceAction(RepositoryClassLoader ucl, String classRsrcName)
/*     */     {
/* 104 */       this.ucl = ucl;
/* 105 */       this.classRsrcName = classRsrcName;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 109 */       URL url = this.ucl.getResourceLocally(this.classRsrcName);
/* 110 */       this.ucl = null;
/* 111 */       this.classRsrcName = null;
/* 112 */       return url;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class PkgClassLoader
/*     */   {
/*     */     public final RepositoryClassLoader ucl;
/*     */     public final int order;
/*     */ 
/*     */     public PkgClassLoader(RepositoryClassLoader ucl)
/*     */     {
/*  77 */       this(ucl, 2147483647);
/*     */     }
/*     */ 
/*     */     public PkgClassLoader(RepositoryClassLoader ucl, int order) {
/*  81 */       this.ucl = ucl;
/*  82 */       this.order = order;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/*  87 */       StringBuffer buffer = new StringBuffer(100);
/*  88 */       buffer.append(super.toString());
/*  89 */       buffer.append("{ucl=").append(this.ucl);
/*  90 */       buffer.append(" order=").append(this.order);
/*  91 */       buffer.append('}');
/*  92 */       return buffer.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.LoadMgr3
 * JD-Core Version:    0.6.0
 */