/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Policy;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.cert.Certificate;
/*     */ import java.util.Collections;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import java.util.Vector;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloading.spi.ClassLoadingDomain;
/*     */ import org.jboss.classloading.spi.DomainClassLoader;
/*     */ import org.jboss.classloading.spi.Translator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.collection.SoftSet;
/*     */ 
/*     */ public abstract class LegacyDomainClassLoader extends URLClassLoader
/*     */   implements DomainClassLoader
/*     */ {
/*  69 */   private static final Logger log = Logger.getLogger(LegacyDomainClassLoader.class);
/*     */ 
/*  72 */   private static final URL[] EMPTY_URL_ARRAY = new URL[0];
/*     */ 
/*  77 */   protected LoaderRepositoryDomain domain = null;
/*     */   protected Exception unregisterTrace;
/*     */   private int addedOrder;
/*  85 */   protected ClassLoader parent = null;
/*     */ 
/*  88 */   private Set classBlackList = Collections.synchronizedSet(new SoftSet());
/*     */ 
/*  90 */   private Set resourceBlackList = Collections.synchronizedSet(new HashSet());
/*     */ 
/*  92 */   private ConcurrentReaderHashMap resourceCache = new ConcurrentReaderHashMap();
/*     */ 
/*  95 */   protected ReentrantLock loadLock = new ReentrantLock();
/*     */   protected int loadClassDepth;
/*     */ 
/*     */   protected LegacyDomainClassLoader(URL[] urls, ClassLoader parent)
/*     */   {
/* 112 */     super(urls, parent);
/* 113 */     this.parent = parent;
/*     */ 
/* 115 */     String mode = ClassToStringAction.getProperty("org.jboss.mx.loading.blacklistMode", null);
/* 116 */     if ((mode == null) || (mode.equalsIgnoreCase("HashSet")))
/*     */     {
/* 118 */       this.classBlackList = Collections.synchronizedSet(new HashSet());
/* 119 */       this.resourceBlackList = Collections.synchronizedSet(new HashSet());
/*     */     }
/* 121 */     else if (mode.equalsIgnoreCase("SoftSet"))
/*     */     {
/* 123 */       this.classBlackList = Collections.synchronizedSet(new SoftSet());
/* 124 */       this.resourceBlackList = Collections.synchronizedSet(new SoftSet());
/*     */     }
/*     */   }
/*     */ 
/*     */   public abstract ObjectName getObjectName()
/*     */     throws MalformedObjectNameException;
/*     */ 
/*     */   public ClassLoadingDomain getDomain()
/*     */   {
/* 139 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public void setDomain(ClassLoadingDomain domain) {
/* 143 */     log.debug("setDomain, domain=" + domain + ", cl=" + this);
/* 144 */     this.domain = ((LoaderRepositoryDomain)domain);
/*     */   }
/*     */ 
/*     */   public int getAddedOrder()
/*     */   {
/* 154 */     return this.addedOrder;
/*     */   }
/*     */ 
/*     */   public void setAddedOrder(int addedOrder)
/*     */   {
/* 164 */     this.addedOrder = addedOrder;
/*     */   }
/*     */ 
/*     */   public Class loadClassLocally(String name, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/* 173 */     boolean trace = log.isTraceEnabled();
/* 174 */     if (trace)
/* 175 */       log.trace("loadClassLocally, " + this + " name=" + name);
/* 176 */     Class result = null;
/*     */     try
/*     */     {
/* 179 */       if (isClassBlackListed(name))
/*     */       {
/* 181 */         if (trace)
/* 182 */           log.trace("Class in blacklist, name=" + name);
/* 183 */         throw new ClassNotFoundException("Class Not Found(blacklist): " + name);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 188 */         result = super.loadClass(name, resolve);
/* 189 */         Class localClass1 = result;
/*     */ 
/* 208 */         if (trace)
/*     */         {
/* 210 */           if (result != null)
/* 211 */             log.trace("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader());
/*     */           else
/* 213 */             log.trace("loadClassLocally, " + this + " name=" + name + " not found"); 
/* 213 */         }return localClass1;
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/* 193 */         addToClassBlackList(name);
/*     */ 
/* 195 */         if (name.charAt(0) == '[')
/*     */         {
/* 197 */           result = Class.forName(name, true, this);
/* 198 */           removeFromClassBlackList(name);
/* 199 */           Class localClass2 = result;
/*     */ 
/* 208 */           if (trace)
/*     */           {
/* 210 */             if (result != null)
/* 211 */               log.trace("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader());
/*     */             else
/* 213 */               log.trace("loadClassLocally, " + this + " name=" + name + " not found"); 
/* 213 */           }return localClass2;
/*     */         }
/* 201 */         if (trace)
/* 202 */           log.trace("CFNE: Adding to blacklist: " + name);
/* 203 */         throw cnfe;
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 208 */       if (trace)
/*     */       {
/* 210 */         if (result != null)
/* 211 */           log.trace("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader());
/*     */         else
/* 213 */           log.trace("loadClassLocally, " + this + " name=" + name + " not found"); 
/*     */       }
/* 213 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public URL getResourceLocally(String name)
/*     */   {
/* 223 */     URL resURL = (URL)this.resourceCache.get(name);
/* 224 */     if (resURL != null)
/* 225 */       return resURL;
/* 226 */     if (isResourceBlackListed(name))
/* 227 */       return null;
/* 228 */     resURL = super.getResource(name);
/* 229 */     if (log.isTraceEnabled() == true)
/* 230 */       log.trace("getResourceLocally(" + this + "), name=" + name + ", resURL:" + resURL);
/* 231 */     if (resURL == null)
/* 232 */       addToResourceBlackList(name);
/*     */     else
/* 234 */       this.resourceCache.put(name, resURL);
/* 235 */     return resURL;
/*     */   }
/*     */ 
/*     */   public URL loadResourceLocally(String name) {
/* 239 */     return getResourceLocally(name);
/*     */   }
/*     */ 
/*     */   public URL getURL()
/*     */   {
/* 249 */     URL[] urls = super.getURLs();
/* 250 */     if (urls.length > 0) {
/* 251 */       return urls[0];
/*     */     }
/* 253 */     return null;
/*     */   }
/*     */ 
/*     */   public void unregister()
/*     */   {
/* 258 */     log.debug("Unregistering cl=" + this);
/* 259 */     if (this.domain != null)
/* 260 */       this.domain.removeClassLoader(this);
/* 261 */     clearBlacklists();
/* 262 */     this.resourceCache.clear();
/* 263 */     this.domain = null;
/* 264 */     this.unregisterTrace = new Exception();
/*     */   }
/*     */ 
/*     */   public URL[] getClasspath()
/*     */   {
/* 275 */     return super.getURLs();
/*     */   }
/*     */ 
/*     */   public void addToClassBlackList(String name)
/*     */   {
/* 285 */     this.classBlackList.add(name);
/*     */   }
/*     */ 
/*     */   public void removeFromClassBlackList(String name)
/*     */   {
/* 295 */     this.classBlackList.remove(name);
/*     */   }
/*     */ 
/*     */   public boolean isClassBlackListed(String name)
/*     */   {
/* 306 */     return this.classBlackList.contains(name);
/*     */   }
/*     */ 
/*     */   public void clearClassBlackList()
/*     */   {
/* 314 */     this.classBlackList.clear();
/*     */   }
/*     */ 
/*     */   public void addToResourceBlackList(String name)
/*     */   {
/* 324 */     this.resourceBlackList.add(name);
/*     */   }
/*     */ 
/*     */   public void removeFromResourceBlackList(String name)
/*     */   {
/* 334 */     this.resourceBlackList.remove(name);
/*     */   }
/*     */ 
/*     */   public boolean isResourceBlackListed(String name)
/*     */   {
/* 345 */     return this.resourceBlackList.contains(name);
/*     */   }
/*     */ 
/*     */   public void clearResourceBlackList()
/*     */   {
/* 353 */     this.resourceBlackList.clear();
/*     */   }
/*     */ 
/*     */   public void clearBlacklists()
/*     */   {
/* 361 */     clearClassBlackList();
/* 362 */     clearResourceBlackList();
/*     */   }
/*     */ 
/*     */   public Class loadClass(String name, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/* 378 */     boolean trace = log.isTraceEnabled();
/* 379 */     if (trace)
/* 380 */       log.trace("loadClass " + this + " name=" + name + ", loadClassDepth=" + this.loadClassDepth);
/* 381 */     Class clazz = null;
/*     */     try
/*     */     {
/* 384 */       if (this.domain != null)
/*     */       {
/* 386 */         clazz = this.domain.getCachedClass(name);
/* 387 */         if (clazz != null)
/*     */         {
/* 389 */           if (log.isTraceEnabled())
/*     */           {
/* 391 */             buffer = new StringBuffer("Loaded class from cache, ");
/* 392 */             ClassToStringAction.toString(clazz, buffer);
/* 393 */             log.trace(buffer.toString());
/*     */           }
/* 395 */           buffer = clazz;
/*     */           return buffer;
/*     */         }
/*     */       }
/* 398 */       clazz = loadClassImpl(name, resolve, 2147483647);
/* 399 */       StringBuffer buffer = clazz;
/*     */       return buffer;
/*     */     }
/*     */     finally
/*     */     {
/* 403 */       if (trace)
/*     */       {
/* 405 */         if (clazz != null)
/* 406 */           log.trace("loadClass " + this + " name=" + name + " class=" + clazz + " cl=" + clazz.getClassLoader());
/*     */         else
/* 408 */           log.trace("loadClass " + this + " name=" + name + " not found"); 
/*     */       }
/* 408 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Class loadClassBefore(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 423 */     boolean trace = log.isTraceEnabled();
/* 424 */     if (trace)
/* 425 */       log.trace("loadClassBefore " + this + " name=" + name);
/* 426 */     Class clazz = null;
/*     */     try
/*     */     {
/* 429 */       clazz = loadClassImpl(name, false, this.addedOrder);
/* 430 */       Class localClass1 = clazz;
/*     */       return localClass1;
/*     */     }
/*     */     finally
/*     */     {
/* 434 */       if (trace)
/*     */       {
/* 436 */         if (clazz != null)
/* 437 */           log.trace("loadClassBefore " + this + " name=" + name + " class=" + clazz + " cl=" + clazz.getClassLoader());
/*     */         else
/* 439 */           log.trace("loadClassBefore " + this + " name=" + name + " not found"); 
/*     */       }
/* 439 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public abstract Class loadClassImpl(String paramString, boolean paramBoolean, int paramInt)
/*     */     throws ClassNotFoundException;
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/* 453 */     if (this.domain != null)
/* 454 */       return this.domain.getResource(name, this);
/* 455 */     return null;
/*     */   }
/*     */ 
/*     */   public Enumeration<URL> findResources(String name)
/*     */     throws IOException
/*     */   {
/* 467 */     Vector resURLs = new Vector();
/* 468 */     if (this.domain == null)
/*     */     {
/* 470 */       String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
/* 471 */       IOException e = new IOException(msg);
/* 472 */       e.initCause(this.unregisterTrace);
/* 473 */       throw e;
/*     */     }
/* 475 */     this.domain.getResources(name, this, resURLs);
/* 476 */     return resURLs.elements();
/*     */   }
/*     */ 
/*     */   public Enumeration findResourcesLocally(String name)
/*     */     throws IOException
/*     */   {
/* 484 */     return super.findResources(name);
/*     */   }
/*     */ 
/*     */   protected Class findClass(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 496 */     boolean trace = log.isTraceEnabled();
/* 497 */     if (trace)
/* 498 */       log.trace("findClass, name=" + name);
/* 499 */     if (isClassBlackListed(name))
/*     */     {
/* 501 */       if (trace)
/* 502 */         log.trace("Class in blacklist, name=" + name);
/* 503 */       throw new ClassNotFoundException("Class Not Found(blacklist): " + name);
/*     */     }
/*     */ 
/* 506 */     Translator translator = this.domain.getTranslator();
/* 507 */     if (translator != null)
/*     */     {
/*     */       try
/*     */       {
/* 513 */         URL classUrl = getClassURL(name);
/* 514 */         byte[] rawcode = loadByteCode(classUrl);
/* 515 */         URL codeSourceUrl = getCodeSourceURL(name, classUrl);
/* 516 */         ProtectionDomain pd = getProtectionDomain(codeSourceUrl);
/* 517 */         byte[] bytecode = translator.transform(this, name, null, pd, rawcode);
/*     */ 
/* 519 */         if (bytecode == null) {
/* 520 */           bytecode = rawcode;
/*     */         }
/* 522 */         definePackage(name);
/* 523 */         return defineClass(name, bytecode, 0, bytecode.length, pd);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 527 */         throw e;
/*     */       }
/*     */       catch (Throwable ex)
/*     */       {
/* 531 */         throw new ClassNotFoundException(name, ex);
/*     */       }
/*     */     }
/*     */ 
/* 535 */     Class clazz = null;
/*     */     try
/*     */     {
/* 538 */       clazz = findClassLocally(name);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 542 */       if (trace)
/* 543 */         log.trace("CFNE: Adding to blacklist: " + name);
/* 544 */       addToClassBlackList(name);
/* 545 */       throw e;
/*     */     }
/* 547 */     return clazz;
/*     */   }
/*     */ 
/*     */   protected Class findClassLocally(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 558 */     return super.findClass(name);
/*     */   }
/*     */ 
/*     */   protected void definePackage(String className)
/*     */   {
/* 569 */     int i = className.lastIndexOf('.');
/* 570 */     if (i == -1) {
/* 571 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 575 */       definePackage(className.substring(0, i), null, null, null, null, null, null, null);
/*     */     }
/*     */     catch (IllegalArgumentException alreadyDone)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addURL(URL url)
/*     */   {
/* 587 */     if (url == null) {
/* 588 */       throw new IllegalArgumentException("url cannot be null");
/*     */     }
/* 590 */     if (this.domain.addClassLoaderURL(this, url) == true)
/*     */     {
/* 592 */       log.debug("Added url: " + url + ", to ucl: " + this);
/*     */ 
/* 594 */       String query = url.getQuery();
/* 595 */       if (query != null)
/*     */       {
/* 597 */         String ext = url.toExternalForm();
/* 598 */         String ext2 = ext.substring(0, ext.length() - query.length() - 1);
/*     */         try
/*     */         {
/* 601 */           url = new URL(ext2);
/*     */         }
/*     */         catch (MalformedURLException e)
/*     */         {
/* 605 */           log.warn("Failed to strip query from: " + url, e);
/*     */         }
/*     */       }
/* 608 */       super.addURL(url);
/* 609 */       clearBlacklists();
/*     */     }
/* 611 */     else if (log.isTraceEnabled())
/*     */     {
/* 613 */       log.trace("Ignoring duplicate url: " + url + ", for ucl: " + this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Package getPackage(String name)
/*     */   {
/* 619 */     return super.getPackage(name);
/*     */   }
/*     */ 
/*     */   public Package[] getPackages()
/*     */   {
/* 624 */     return super.getPackages();
/*     */   }
/*     */ 
/*     */   public final boolean equals(Object other)
/*     */   {
/* 637 */     return super.equals(other);
/*     */   }
/*     */ 
/*     */   public final int hashCode()
/*     */   {
/* 648 */     return super.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 656 */     return super.toString() + "{ url=" + getURL() + " }";
/*     */   }
/*     */ 
/*     */   protected boolean attempt(long waitMS)
/*     */   {
/* 668 */     boolean acquired = false;
/* 669 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 671 */     boolean threadWasInterrupted = Thread.interrupted();
/*     */     try
/*     */     {
/* 674 */       acquired = this.loadLock.attempt(waitMS);
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/*     */     }
/*     */     finally
/*     */     {
/* 682 */       if (threadWasInterrupted)
/* 683 */         Thread.currentThread().interrupt();
/*     */     }
/* 685 */     if (trace)
/* 686 */       log.trace("attempt(" + this.loadLock.holds() + ") was: " + acquired + " for :" + this);
/* 687 */     return acquired;
/*     */   }
/*     */ 
/*     */   protected void acquire()
/*     */   {
/* 697 */     boolean threadWasInterrupted = Thread.interrupted();
/*     */     try
/*     */     {
/* 700 */       this.loadLock.acquire();
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/*     */     }
/*     */     finally
/*     */     {
/* 708 */       if (threadWasInterrupted)
/* 709 */         Thread.currentThread().interrupt();
/*     */     }
/* 711 */     if (log.isTraceEnabled())
/* 712 */       log.trace("acquired(" + this.loadLock.holds() + ") for :" + this);
/*     */   }
/*     */ 
/*     */   protected void release()
/*     */   {
/* 719 */     if (log.isTraceEnabled())
/* 720 */       log.trace("release(" + this.loadLock.holds() + ") for :" + this);
/* 721 */     this.loadLock.release();
/* 722 */     if (log.isTraceEnabled())
/* 723 */       log.trace("released, holds: " + this.loadLock.holds());
/*     */   }
/*     */ 
/*     */   protected byte[] loadByteCode(String classname)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 737 */     byte[] bytecode = null;
/* 738 */     URL classURL = getClassURL(classname);
/*     */ 
/* 741 */     InputStream is = null;
/*     */     try
/*     */     {
/* 744 */       is = classURL.openStream();
/* 745 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 746 */       byte[] tmp = new byte[1024];
/* 747 */       int read = 0;
/* 748 */       while ((read = is.read(tmp)) > 0)
/*     */       {
/* 750 */         baos.write(tmp, 0, read);
/*     */       }
/* 752 */       bytecode = baos.toByteArray();
/*     */     }
/*     */     finally
/*     */     {
/* 756 */       if (is != null) {
/* 757 */         is.close();
/*     */       }
/*     */     }
/* 760 */     return bytecode;
/*     */   }
/*     */ 
/*     */   protected byte[] loadByteCode(URL classURL)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 774 */     byte[] bytecode = null;
/*     */ 
/* 776 */     InputStream is = null;
/*     */     try
/*     */     {
/* 779 */       is = classURL.openStream();
/* 780 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 781 */       byte[] tmp = new byte[1024];
/* 782 */       int read = 0;
/* 783 */       while ((read = is.read(tmp)) > 0)
/*     */       {
/* 785 */         baos.write(tmp, 0, read);
/*     */       }
/* 787 */       bytecode = baos.toByteArray();
/*     */     }
/*     */     finally
/*     */     {
/* 791 */       if (is != null) {
/* 792 */         is.close();
/*     */       }
/*     */     }
/* 795 */     return bytecode;
/*     */   }
/*     */ 
/*     */   protected ProtectionDomain getProtectionDomain(URL codesourceUrl)
/*     */   {
/* 806 */     Certificate[] certs = null;
/* 807 */     CodeSource cs = new CodeSource(codesourceUrl, certs);
/* 808 */     PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
/* 809 */     if (log.isTraceEnabled()) {
/* 810 */       log.trace("getProtectionDomain, url=" + codesourceUrl + " codeSource=" + cs + " permissions=" + permissions);
/*     */     }
/* 812 */     return new ProtectionDomain(cs, permissions);
/*     */   }
/*     */ 
/*     */   private URL getCodeSourceURL(String classname, URL classURL)
/*     */     throws MalformedURLException
/*     */   {
/* 821 */     String classRsrcName = classname.replace('.', '/') + ".class";
/* 822 */     String urlAsString = classURL.toString();
/* 823 */     int idx = urlAsString.indexOf(classRsrcName);
/* 824 */     if (idx == -1) return classURL;
/* 825 */     urlAsString = urlAsString.substring(0, idx);
/* 826 */     return new URL(urlAsString);
/*     */   }
/*     */ 
/*     */   private URL getClassURL(String classname) throws ClassNotFoundException
/*     */   {
/* 831 */     String classRsrcName = classname.replace('.', '/') + ".class";
/* 832 */     URL classURL = getResourceLocally(classRsrcName);
/* 833 */     if (classURL == null)
/*     */     {
/* 835 */       String msg = "Failed to find: " + classname + " as resource: " + classRsrcName;
/* 836 */       throw new ClassNotFoundException(msg);
/*     */     }
/* 838 */     return classURL;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.LegacyDomainClassLoader
 * JD-Core Version:    0.6.0
 */