/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import java.util.zip.ZipEntry;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassPreloadService
/*     */ {
/*  79 */   static Logger log = Logger.getLogger(ClassPreloadService.class);
/*     */ 
/*  81 */   private String[] includePattern = new String[0];
/*     */ 
/*  83 */   private String[] excludePattern = new String[0];
/*     */   private boolean simpleMatch;
/*     */   boolean trace;
/*     */ 
/*     */   public String[] getIncludePatterns()
/*     */   {
/*  90 */     return this.includePattern;
/*     */   }
/*     */ 
/*     */   public void setIncludePatterns(String[] includePattern) {
/*  94 */     this.includePattern = includePattern;
/*     */   }
/*     */ 
/*     */   public String[] getExcludePatterns()
/*     */   {
/*  99 */     return this.excludePattern;
/*     */   }
/*     */ 
/*     */   public void setExcludePatterns(String[] excludePattern) {
/* 103 */     this.excludePattern = excludePattern;
/*     */   }
/*     */ 
/*     */   public boolean isSimpleMatch()
/*     */   {
/* 108 */     return this.simpleMatch;
/*     */   }
/*     */ 
/*     */   public void setSimpleMatch(boolean simpleMatch) {
/* 112 */     this.simpleMatch = simpleMatch;
/*     */   }
/*     */ 
/*     */   public URL[] getRawClassPath()
/*     */   {
/* 117 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 118 */     URL[] fullCP = ClassLoaderUtils.getClassLoaderURLs(loader);
/* 119 */     return fullCP;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 128 */     this.trace = log.isTraceEnabled();
/* 129 */     log.debug("Starting, includes=" + Arrays.asList(this.includePattern) + ", excludes=" + this.excludePattern);
/*     */ 
/* 132 */     Pattern[] includes = compileIncludes();
/* 133 */     Pattern[] excludes = compileExcludes();
/*     */ 
/* 135 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 136 */     URL[] rawCP = ClassLoaderUtils.getClassLoaderURLs(loader);
/* 137 */     URL[] cp = filterCP(rawCP, includes, excludes);
/*     */ 
/* 139 */     int loadedClasses = 0;
/* 140 */     int loadErrors = 0;
/* 141 */     for (int n = 0; n < cp.length; n++)
/*     */     {
/* 143 */       URL u = cp[n];
/*     */       try
/*     */       {
/* 146 */         InputStream is = u.openStream();
/* 147 */         ZipInputStream zis = new ZipInputStream(is);
/* 148 */         ZipEntry ze = zis.getNextEntry();
/* 149 */         while (ze != null)
/*     */         {
/* 151 */           String name = ze.getName();
/* 152 */           if (name.endsWith(".class"))
/*     */           {
/* 154 */             int length = name.length();
/* 155 */             String cname = name.replace('/', '.').substring(0, length - 6);
/*     */             try
/*     */             {
/* 158 */               Class c = loader.loadClass(cname);
/* 159 */               loadedClasses++;
/* 160 */               if (this.trace)
/* 161 */                 log.trace("loaded class: " + cname);
/*     */             }
/*     */             catch (Throwable e)
/*     */             {
/* 165 */               loadErrors++;
/* 166 */               if (this.trace)
/* 167 */                 log.trace("Failed to load class, " + e.getMessage());
/*     */             }
/*     */           }
/* 170 */           ze = zis.getNextEntry();
/*     */         }
/* 172 */         zis.close();
/*     */       }
/*     */       catch (IOException ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 179 */     log.info("Loaded " + loadedClasses + " classes, " + loadErrors + " CNFEs");
/*     */   }
/*     */ 
/*     */   public Pattern[] compileIncludes()
/*     */   {
/* 184 */     ArrayList tmp = new ArrayList();
/* 185 */     int count = this.includePattern != null ? this.includePattern.length : 0;
/* 186 */     for (int n = 0; n < count; n++)
/*     */     {
/* 188 */       String p = this.includePattern[n];
/* 189 */       Pattern pat = Pattern.compile(p);
/* 190 */       tmp.add(pat);
/*     */     }
/* 192 */     Pattern[] includes = new Pattern[tmp.size()];
/* 193 */     tmp.toArray(includes);
/* 194 */     return includes;
/*     */   }
/*     */ 
/*     */   public Pattern[] compileExcludes() {
/* 198 */     ArrayList tmp = new ArrayList();
/* 199 */     int count = this.excludePattern != null ? this.excludePattern.length : 0;
/* 200 */     for (int n = 0; n < count; n++)
/*     */     {
/* 202 */       String p = this.excludePattern[n];
/* 203 */       Pattern pat = Pattern.compile(p);
/* 204 */       tmp.add(pat);
/*     */     }
/* 206 */     Pattern[] includes = new Pattern[tmp.size()];
/* 207 */     tmp.toArray(includes);
/* 208 */     return includes;
/*     */   }
/*     */ 
/*     */   public URL[] filterCP(URL[] rawCP, Pattern[] includes, Pattern[] excludes)
/*     */   {
/* 213 */     if (this.trace)
/* 214 */       log.trace("filterCP, rawCP=" + Arrays.asList(rawCP));
/* 215 */     ArrayList tmp = new ArrayList();
/* 216 */     int count = rawCP != null ? rawCP.length : 0;
/* 217 */     for (int m = 0; m < count; m++)
/*     */     {
/* 219 */       URL pathURL = rawCP[m];
/* 220 */       String path = pathURL.toString();
/* 221 */       boolean excluded = false;
/*     */ 
/* 224 */       for (int n = 0; n < excludes.length; n++)
/*     */       {
/* 226 */         Pattern p = excludes[n];
/* 227 */         Matcher matcher = p.matcher(path);
/* 228 */         if ((this.simpleMatch) && (path.endsWith(p.pattern())))
/*     */         {
/* 230 */           excluded = true;
/* 231 */           break;
/*     */         }
/* 233 */         if (!matcher.matches())
/*     */           continue;
/* 235 */         excluded = true;
/* 236 */         break;
/*     */       }
/*     */ 
/* 239 */       if (excluded)
/*     */       {
/* 241 */         log.debug("Excluded: " + pathURL);
/*     */       }
/*     */       else
/*     */       {
/* 246 */         boolean included = includes.length == 0;
/* 247 */         for (int n = 0; n < includes.length; n++)
/*     */         {
/* 249 */           Pattern p = includes[n];
/* 250 */           Matcher matcher = p.matcher(path);
/* 251 */           if ((this.simpleMatch) && (path.endsWith(p.pattern())))
/* 252 */             tmp.add(pathURL);
/* 253 */           else if (matcher.matches())
/* 254 */             tmp.add(pathURL);
/*     */         }
/* 256 */         if (!included)
/*     */           continue;
/* 258 */         log.debug("Included: " + pathURL);
/* 259 */         tmp.add(pathURL);
/*     */       }
/*     */     }
/* 262 */     URL[] cp = new URL[tmp.size()];
/* 263 */     tmp.toArray(cp);
/* 264 */     return cp;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.ClassPreloadService
 * JD-Core Version:    0.6.0
 */