/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.security.CodeSource;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassLoadingTaskDCL
/*     */ {
/*  38 */   protected static Logger log = Logger.getLogger(ClassLoadingTaskDCL.class);
/*  39 */   protected static Comparator taskComparator = new ThreadTaskComparator();
/*     */   public static final int FOUND_CLASS_LOADER = 1;
/*     */   public static final int NEXT_EVENT = 2;
/*     */   public static final int WAIT_ON_EVENT = 3;
/*     */   public static final int FINISHED = 4;
/*     */   protected String classname;
/*     */   protected Thread requestingThread;
/*     */   protected DomainClassLoaderUCLImpl requestingClassLoader;
/*     */   protected Class loadedClass;
/*  50 */   protected int loadOrder = 2147483647;
/*  51 */   protected int stopOrder = 2147483647;
/*     */   protected Throwable loadException;
/*     */   protected int threadTaskCount;
/*     */   protected int state;
/*     */   protected boolean trace;
/*     */   protected int numCCE;
/*     */ 
/*     */   protected ClassLoadingTaskDCL(String classname, DomainClassLoaderUCLImpl requestingClassLoader, Thread requestingThread)
/*     */   {
/* 152 */     this(classname, requestingClassLoader, requestingThread, 2147483647);
/*     */   }
/*     */ 
/*     */   protected ClassLoadingTaskDCL(String classname, DomainClassLoaderUCLImpl requestingClassLoader, Thread requestingThread, int stopAt)
/*     */   {
/* 158 */     this.requestingThread = requestingThread;
/* 159 */     this.requestingClassLoader = requestingClassLoader;
/* 160 */     this.classname = classname;
/* 161 */     this.stopOrder = stopAt;
/* 162 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 167 */     StringBuffer buffer = new StringBuffer(super.toString());
/* 168 */     buffer.append('{');
/* 169 */     buffer.append("classname: " + this.classname);
/* 170 */     buffer.append(", requestingThread: " + this.requestingThread);
/* 171 */     buffer.append(", requestingClassLoader: " + this.requestingClassLoader);
/* 172 */     buffer.append(", loadedClass: " + this.loadedClass);
/* 173 */     ClassToStringAction.toString(this.loadedClass, buffer);
/* 174 */     buffer.append(", loadOrder: " + this.loadOrder);
/* 175 */     buffer.append(", loadException: " + this.loadException);
/* 176 */     buffer.append(", threadTaskCount: " + this.threadTaskCount);
/* 177 */     buffer.append(", state: " + this.state);
/* 178 */     buffer.append(", #CCE: " + this.numCCE);
/* 179 */     buffer.append('}');
/* 180 */     if ((this.trace) && (this.loadException != null))
/*     */     {
/* 182 */       StringWriter sw = new StringWriter();
/* 183 */       PrintWriter pw = new PrintWriter(sw);
/* 184 */       this.loadException.printStackTrace(pw);
/* 185 */       buffer.append("loadException details:\n");
/* 186 */       buffer.append(sw.toString());
/*     */     }
/* 188 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   ThreadTask newThreadTask(DomainClassLoaderUCLImpl ucl, Thread t, int order, boolean reschedule, boolean releaseInNextTask)
/*     */   {
/* 195 */     if (!reschedule)
/* 196 */       this.threadTaskCount += 1;
/* 197 */     return new ThreadTask(ucl, t, order, releaseInNextTask);
/*     */   }
/*     */ 
/*     */   synchronized void setLoadError(Throwable t)
/*     */   {
/* 202 */     this.threadTaskCount -= 1;
/* 203 */     if (this.trace)
/* 204 */       log.trace("setLoadedError, error=" + t);
/* 205 */     this.loadException = t;
/*     */   }
/*     */ 
/*     */   private synchronized void setLoadedClass(Class theClass, int order)
/*     */   {
/* 215 */     this.threadTaskCount -= 1;
/* 216 */     if (this.trace) {
/* 217 */       log.trace("setLoadedClass, theClass=" + theClass + ", order=" + order);
/*     */     }
/*     */ 
/* 220 */     if ((this.loadedClass != null) && (order == this.loadOrder) && (theClass != null))
/*     */     {
/* 222 */       StringBuffer tmp = new StringBuffer("Duplicate class found: " + this.classname);
/* 223 */       tmp.append('\n');
/* 224 */       ProtectionDomain pd = this.loadedClass.getProtectionDomain();
/* 225 */       CodeSource cs = pd != null ? pd.getCodeSource() : null;
/* 226 */       tmp.append("Current CS: " + cs);
/* 227 */       tmp.append('\n');
/* 228 */       pd = theClass.getProtectionDomain();
/* 229 */       cs = pd != null ? pd.getCodeSource() : null;
/* 230 */       tmp.append("Duplicate CS: " + cs);
/* 231 */       log.warn(tmp.toString());
/*     */     }
/*     */ 
/* 235 */     if (theClass != null)
/*     */     {
/* 237 */       if ((this.loadedClass == null) || (order <= this.loadOrder))
/*     */       {
/* 239 */         this.loadedClass = theClass;
/* 240 */         this.loadOrder = order;
/*     */       }
/*     */       else
/*     */       {
/* 244 */         ProtectionDomain pd = this.loadedClass.getProtectionDomain();
/* 245 */         CodeSource cs = pd != null ? pd.getCodeSource() : null;
/* 246 */         ProtectionDomain pd2 = theClass.getProtectionDomain();
/* 247 */         CodeSource cs2 = pd != null ? pd2.getCodeSource() : null;
/* 248 */         log.debug("Ignoring source of: " + this.classname + " from CodeSource: " + cs2 + ", due to order(" + order + ">=" + this.loadOrder + "), " + "accepted CodeSource: " + cs);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class ThreadTask
/*     */   {
/*     */     DomainClassLoaderUCLImpl ucl;
/*     */     Thread t;
/*     */     int order;
/*     */     boolean releaseInNextTask;
/*     */ 
/*     */     ThreadTask(DomainClassLoaderUCLImpl ucl, Thread t, int order, boolean releaseInNextTask)
/*     */     {
/* 100 */       this.ucl = ucl;
/* 101 */       this.t = t;
/* 102 */       this.order = order;
/* 103 */       this.releaseInNextTask = releaseInNextTask;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 108 */       return "{t=" + this.t + ", ucl=" + this.ucl + ", name=" + ClassLoadingTaskDCL.this.classname + ", requestingThread=" + ClassLoadingTaskDCL.this.requestingThread + ", order=" + this.order + ", releaseInNextTask=" + this.releaseInNextTask + "}";
/*     */     }
/*     */ 
/*     */     String getClassname()
/*     */     {
/* 116 */       return ClassLoadingTaskDCL.this.classname;
/*     */     }
/*     */ 
/*     */     Class getLoadedClass() {
/* 120 */       return ClassLoadingTaskDCL.this.loadedClass;
/*     */     }
/*     */ 
/*     */     ClassLoadingTaskDCL getLoadTask() {
/* 124 */       return ClassLoadingTaskDCL.this;
/*     */     }
/*     */ 
/*     */     void run() throws ClassNotFoundException
/*     */     {
/* 129 */       Class theClass = null;
/*     */       try
/*     */       {
/* 132 */         if (ClassLoadingTaskDCL.this.loadedClass == null)
/*     */         {
/* 134 */           theClass = this.ucl.loadClassLocally(ClassLoadingTaskDCL.this.classname, false);
/* 135 */           ClassLoadingTaskDCL.this.setLoadedClass(theClass, this.order);
/*     */         }
/* 137 */         else if (ClassLoadingTaskDCL.this.trace)
/*     */         {
/* 139 */           ClassLoadingTaskDCL.log.trace("Already found class(" + ClassLoadingTaskDCL.this.loadedClass + "), skipping loadClassLocally");
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ThreadTaskComparator
/*     */     implements Comparator
/*     */   {
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/*  69 */       ClassLoadingTaskDCL.ThreadTask t1 = (ClassLoadingTaskDCL.ThreadTask)o1;
/*  70 */       ClassLoadingTaskDCL.ThreadTask t2 = (ClassLoadingTaskDCL.ThreadTask)o2;
/*  71 */       int compare = t1.order - t2.order;
/*     */ 
/*  78 */       return compare;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.ClassLoadingTaskDCL
 * JD-Core Version:    0.6.0
 */