/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import javax.management.modelmbean.InvalidTargetObjectTypeException;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ 
/*     */ public class ReflectedDispatcher extends AbstractInterceptor
/*     */ {
/*  52 */   protected Method method = null;
/*     */   protected boolean dynamic;
/*     */ 
/*     */   public ReflectedDispatcher()
/*     */   {
/*  60 */     super("Reflected Dispatcher");
/*     */   }
/*     */ 
/*     */   public ReflectedDispatcher(boolean dynamic)
/*     */   {
/*  65 */     this();
/*  66 */     this.dynamic = dynamic;
/*     */   }
/*     */ 
/*     */   public ReflectedDispatcher(Method m, boolean dynamic)
/*     */   {
/*  71 */     this(dynamic);
/*  72 */     this.method = m;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  79 */     Method invokeMethod = this.method;
/*  80 */     Object target = invocation.getTarget();
/*  81 */     String operationName = invocation.getName();
/*  82 */     if (this.dynamic)
/*     */     {
/*  85 */       String opName = operationName;
/*  86 */       String opClass = null;
/*  87 */       int dot = opName.lastIndexOf('.');
/*  88 */       if (dot != -1)
/*     */       {
/*  90 */         opClass = operationName.substring(0, dot);
/*  91 */         opName = operationName.substring(dot + 1);
/*     */       }
/*     */ 
/*  95 */       Descriptor descriptor = invocation.getDescriptor();
/*  96 */       if (descriptor != null)
/*     */       {
/*  98 */         Object descriptorTarget = descriptor.getFieldValue("targetObject");
/*  99 */         if (descriptorTarget != null)
/*     */         {
/* 101 */           String targetType = (String)descriptor.getFieldValue("targetType");
/* 102 */           if (!"ObjectReference".equalsIgnoreCase(targetType))
/* 103 */             throw new InvalidTargetObjectTypeException("Target type is " + targetType);
/* 104 */           target = descriptorTarget;
/*     */ 
/* 107 */           Class clazz = null;
/* 108 */           String className = (String)descriptor.getFieldValue("class");
/* 109 */           if (className == null)
/* 110 */             className = opClass;
/* 111 */           if (className == null) {
/* 112 */             clazz = target.getClass();
/*     */           }
/*     */           else
/*     */             try
/*     */             {
/* 117 */               if (clazz == null)
/* 118 */                 clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 122 */               throw new ReflectionException(e, "Error loading class for operation " + opName);
/*     */             }
/*     */           Class[] sig;
/*     */           try
/*     */           {
/* 128 */             sig = invocation.getSignatureClasses();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 132 */             throw new ReflectionException(e, "Error loading signature classes for operation " + opName);
/*     */           }
/*     */           try
/*     */           {
/* 136 */             invokeMethod = clazz.getDeclaredMethod(opName, sig);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 140 */             throw new ReflectionException(e, "Error getting method for operation " + opName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 146 */     if (target == null)
/*     */     {
/* 148 */       String msg = "Failed to find method for operation: " + invocation + " on resource: " + invocation.getInvoker().getResource() + " objectName: " + invocation.getInvoker().getObjectName();
/*     */ 
/* 151 */       throw new ReflectionException(new NullPointerException(msg));
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 156 */       Object[] args = invocation.getArgs();
/* 157 */       return invokeMethod.invoke(target, args);
/*     */     }
/*     */     catch (NullPointerException e)
/*     */     {
/* 161 */       throw new NullPointerException("Error in operation=" + operationName + " method=" + this.method + " target=" + target);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 165 */       handleInvocationExceptions(t);
/* 166 */     }return null;
/*     */   }
/*     */ 
/*     */   protected void handleInvocationExceptions(Throwable t)
/*     */     throws Throwable
/*     */   {
/* 174 */     if ((t instanceof InvocationTargetException))
/*     */     {
/* 176 */       t = ((InvocationTargetException)t).getTargetException();
/* 177 */       if ((t instanceof RuntimeOperationsException))
/* 178 */         throw ((RuntimeOperationsException)t);
/* 179 */       if ((t instanceof RuntimeException))
/* 180 */         throw new RuntimeMBeanException((RuntimeException)t);
/* 181 */       if ((t instanceof Error))
/* 182 */         throw new RuntimeErrorException((Error)t);
/* 183 */       if ((t instanceof Exception)) {
/* 184 */         throw new MBeanException((Exception)t);
/*     */       }
/* 186 */       throw t;
/*     */     }
/* 188 */     if ((t instanceof Exception))
/* 189 */       throw new ReflectionException((Exception)t);
/* 190 */     if ((t instanceof Error)) {
/* 191 */       throw new RuntimeErrorException((Error)t);
/*     */     }
/* 193 */     throw t;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.ReflectedDispatcher
 * JD-Core Version:    0.6.0
 */