/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import javax.management.Attribute;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanConstants;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanInvoker;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class ModelMBeanAttributeInterceptor extends AbstractInterceptor
/*     */   implements ModelMBeanConstants
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ModelMBeanAttributeInterceptor.class);
/*     */ 
/*  54 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public ModelMBeanAttributeInterceptor()
/*     */   {
/*  60 */     super("ModelMBean Attribute Interceptor");
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  69 */     Descriptor d = invocation.getDescriptor();
/*  70 */     Class clazz = invocation.getAttributeTypeClass();
/*     */ 
/*  72 */     String name = null;
/*  73 */     ObjectName objectName = null;
/*  74 */     if (this.trace)
/*     */     {
/*  76 */       name = (String)d.getFieldValue("name");
/*  77 */       objectName = invocation.getInvoker().getObjectName();
/*     */     }
/*     */ 
/*  81 */     if (invocation.getType().equals("setAttribute"))
/*     */     {
/*  84 */       Object value = invocation.getArgs()[0];
/*  85 */       if (this.trace) {
/*  86 */         log.trace("Setting objectName=" + objectName + " attr=" + name + " value=" + value);
/*     */       }
/*  88 */       checkAssignable("Set attribute ", clazz, value);
/*     */ 
/*  91 */       Object oldValue = d.getFieldValue("attributeValue");
/*  92 */       if (this.trace) {
/*  93 */         log.trace("Setting objectName=" + objectName + " attr=" + name + " oldValue=" + value);
/*     */       }
/*     */ 
/*  96 */       String setMethod = (String)d.getFieldValue("setMethod");
/*  97 */       if (this.trace) {
/*  98 */         log.trace("Setting objectName=" + objectName + " attr=" + name + " setMethod=" + setMethod);
/*     */       }
/* 100 */       if (setMethod != null)
/*     */       {
/* 103 */         invocation.invoke();
/*     */       }
/*     */ 
/* 107 */       String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
/* 108 */       long limit = timeLimit == null ? -1L : Long.parseLong(timeLimit);
/* 109 */       String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
/*     */ 
/* 111 */       if (limit != -1L)
/*     */       {
/* 113 */         if (this.trace)
/* 114 */           log.trace("Setting objectName=" + objectName + " attr=" + name + " value=" + value + " timestamp=" + timestamp);
/* 115 */         d.setField("value", value);
/* 116 */         d.setField("lastUpdatedTimeStamp", timestamp);
/*     */       }
/*     */ 
/* 124 */       d.setField("attributeValue", value);
/* 125 */       d.setField("lastUpdatedTimeStamp2", timestamp);
/*     */ 
/* 128 */       ModelMBeanInvoker invoker = (ModelMBeanInvoker)invocation.getInvoker();
/* 129 */       invoker.sendAttributeChangeNotification(new Attribute(invocation.getName(), oldValue), new Attribute(invocation.getName(), value));
/*     */ 
/* 133 */       return null;
/*     */     }
/* 135 */     if (invocation.getType().equals("getAttribute"))
/*     */     {
/* 137 */       if (this.trace) {
/* 138 */         log.trace("Getting objectName=" + objectName + " attr=" + name);
/*     */       }
/* 140 */       String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
/* 141 */       long limit = timeLimit == null ? -1L : Long.parseLong(timeLimit);
/*     */ 
/* 144 */       if (limit == 0L)
/*     */       {
/* 146 */         String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
/* 147 */         if (timeStamp != null)
/*     */         {
/* 149 */           Object value = d.getFieldValue("value");
/* 150 */           if (this.trace)
/* 151 */             log.trace("Always cache objectName=" + objectName + " attr=" + name + " value=" + value);
/* 152 */           checkAssignable("Cached value in descriptor ", clazz, value);
/* 153 */           return value;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 158 */       if (limit != -1L)
/*     */       {
/* 160 */         String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
/* 161 */         long lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
/*     */ 
/* 164 */         long now = System.currentTimeMillis();
/* 165 */         long expires = lastUpdate * 1000L + limit * 1000L;
/* 166 */         if (now < expires)
/*     */         {
/* 168 */           Object value = d.getFieldValue("value");
/* 169 */           if (this.trace)
/* 170 */             log.trace("Using cache objectName=" + objectName + " attr=" + name + " value=" + value + " now=" + now + " expires=" + expires);
/* 171 */           checkAssignable("Cached value in descriptor ", clazz, value);
/* 172 */           return value;
/*     */         }
/*     */ 
/* 176 */         if (this.trace)
/* 177 */           log.trace("Cache expired objectName=" + objectName + " attr=" + name + " now=" + now + " expires=" + expires);
/* 178 */         d.removeField("value");
/*     */       }
/*     */       else
/*     */       {
/* 184 */         if (this.trace)
/* 185 */           log.trace("Removing any cached value objectName=" + objectName + " attr=" + name + " descriptor=" + d);
/* 186 */         d.removeField("value");
/*     */       }
/*     */ 
/* 190 */       String getMethod = (String)d.getFieldValue("getMethod");
/* 191 */       if (this.trace) {
/* 192 */         log.trace("Get attribute objectName=" + objectName + " attr=" + name + " getMethod=" + getMethod);
/*     */       }
/* 194 */       if (getMethod != null)
/*     */       {
/* 197 */         Object value = invocation.invoke();
/* 198 */         if (this.trace) {
/* 199 */           log.trace("Got attribute objectName=" + objectName + " attr=" + name + " value=" + value);
/*     */         }
/*     */ 
/* 202 */         if (limit != -1L)
/*     */         {
/* 204 */           String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
/* 205 */           if (this.trace)
/* 206 */             log.trace("Cache attribute objectName=" + objectName + " attr=" + name + " value=" + value + " timestamp=" + timestamp);
/* 207 */           d.setField("value", value);
/* 208 */           d.setField("lastUpdatedTimeStamp", timestamp);
/*     */         }
/* 210 */         return value;
/*     */       }
/*     */ 
/* 215 */       Object value = d.getFieldValue("default");
/* 216 */       if (this.trace)
/* 217 */         log.trace("Get attribute use default objectName=" + objectName + " attr=" + name + " default=" + value);
/* 218 */       checkAssignable("Default value ", clazz, value);
/* 219 */       return value;
/*     */     }
/*     */ 
/* 223 */     throw new UnreachableStatementException(invocation.getType());
/*     */   }
/*     */ 
/*     */   protected void checkAssignable(String context, Class clazz, Object value) throws InvalidAttributeValueException, ClassNotFoundException
/*     */   {
/* 228 */     if ((value != null) && (!clazz.isAssignableFrom(value.getClass())))
/* 229 */       throw new InvalidAttributeValueException(context + " has class " + value.getClass() + " loaded from " + value.getClass().getClassLoader() + " that is not assignable to attribute class " + clazz + " loaded from " + clazz.getClassLoader());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.ModelMBeanAttributeInterceptor
 * JD-Core Version:    0.6.0
 */