/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ 
/*     */ public class DynamicInterceptor extends AbstractInterceptor
/*     */ {
/*     */   public static final String ADD_INTERCEPTOR = "addOperationInterceptor";
/*     */   public static final String REMOVE_INTERCEPTOR = "removeOperationInterceptor";
/*     */   MBeanInvoker invoker;
/*     */ 
/*     */   public DynamicInterceptor(MBeanInvoker invoker)
/*     */   {
/*  50 */     setName("DynamicInterceptor");
/*     */ 
/*  52 */     this.invoker = invoker;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  61 */     String type = invocation.getType();
/*     */ 
/*  64 */     if (type.equals("invoke"))
/*     */     {
/*  66 */       String name = invocation.getName();
/*     */ 
/*  68 */       if (name.equals("addOperationInterceptor"))
/*     */       {
/*  70 */         Object[] args = invocation.getArgs();
/*  71 */         Object retn = invocation.getReturnTypeClass();
/*     */ 
/*  73 */         if ((args.length == 1) && ((args[0] instanceof Interceptor)) && (retn == null))
/*     */         {
/*  75 */           this.invoker.addOperationInterceptor((Interceptor)args[0]);
/*  76 */           return null;
/*     */         }
/*     */       }
/*  79 */       else if (name.equals("removeOperationInterceptor"))
/*     */       {
/*  81 */         Object[] args = invocation.getArgs();
/*  82 */         Object retn = invocation.getReturnTypeClass();
/*     */ 
/*  84 */         if ((args.length == 1) && ((args[0] instanceof Interceptor)) && (retn == null))
/*     */         {
/*  86 */           this.invoker.removeOperationInterceptor((Interceptor)args[0]);
/*  87 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  94 */     Interceptor next = invocation.nextInterceptor();
/*  95 */     if (next != null)
/*     */     {
/*  97 */       return next.invoke(invocation);
/*     */     }
/*     */ 
/* 101 */     return invocation.dispatch();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.DynamicInterceptor
 * JD-Core Version:    0.6.0
 */