/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.ServiceNotFoundException;
/*     */ import javax.management.modelmbean.InvalidTargetObjectTypeException;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ 
/*     */ public class AttributeDispatcher extends ReflectedDispatcher
/*     */ {
/*     */   private Method getter;
/*     */   private Method setter;
/*     */ 
/*     */   public AttributeDispatcher(Method getter, Method setter, boolean dynamic)
/*     */   {
/*  50 */     super(dynamic);
/*  51 */     setName("Attribute Dispatcher");
/*  52 */     this.getter = getter;
/*  53 */     this.setter = setter;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  64 */     Object target = invocation.getTarget();
/*     */ 
/*  66 */     Object value = null;
/*  67 */     Object[] args = invocation.getArgs();
/*     */ 
/*  69 */     if (args == null)
/*     */     {
/*  71 */       Method getMethod = this.getter;
/*  72 */       if (this.dynamic)
/*     */       {
/*  74 */         Descriptor d = invocation.getDescriptor();
/*  75 */         if (d != null)
/*     */         {
/*  77 */           Object descriptorTarget = d.getFieldValue("targetObject");
/*  78 */           if (descriptorTarget != null)
/*     */           {
/*  80 */             String targetType = (String)d.getFieldValue("targetType");
/*  81 */             if (!"ObjectReference".equalsIgnoreCase(targetType))
/*  82 */               throw new InvalidTargetObjectTypeException("Target type is " + targetType);
/*  83 */             target = descriptorTarget;
/*     */           }
/*  85 */           String getMethodString = (String)d.getFieldValue("getMethod");
/*  86 */           if ((getMethodString != null) && ((getMethod == null) || (!getMethodString.equals(getMethod.getName()))))
/*     */           {
/*  88 */             MBeanInvoker invoker = invocation.getInvoker();
/*  89 */             Object object = invoker.invoke(getMethodString, new Object[0], new String[0]);
/*  90 */             checkAssignable(getMethodString, invocation.getAttributeTypeClass(), object);
/*  91 */             return object;
/*     */           }
/*     */         }
/*     */       }
/*  95 */       if (target == null)
/*  96 */         throw new MBeanException(new ServiceNotFoundException("No Target"));
/*     */       try
/*     */       {
/*  99 */         value = getMethod.invoke(target, args);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 103 */         handleInvocationExceptions(t);
/* 104 */         return null;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 110 */       Method setMethod = this.setter;
/* 111 */       if (this.dynamic)
/*     */       {
/* 113 */         Descriptor d = invocation.getDescriptor();
/* 114 */         if (d != null)
/*     */         {
/* 116 */           Object descriptorTarget = d.getFieldValue("targetObject");
/* 117 */           if (descriptorTarget != null)
/*     */           {
/* 119 */             String targetType = (String)d.getFieldValue("targetType");
/* 120 */             if (!"ObjectReference".equalsIgnoreCase(targetType))
/* 121 */               throw new InvalidTargetObjectTypeException("Target type is " + targetType);
/* 122 */             target = descriptorTarget;
/*     */           }
/* 124 */           String setMethodString = (String)d.getFieldValue("setMethod");
/* 125 */           if ((setMethodString != null) && ((setMethod == null) || (!setMethodString.equals(setMethod.getName()))))
/*     */           {
/* 127 */             MBeanInvoker invoker = invocation.getInvoker();
/* 128 */             return invoker.invoke(setMethodString, new Object[] { args[0] }, new String[] { invocation.getAttributeType() });
/*     */           }
/*     */         }
/*     */       }
/* 132 */       if (target == null)
/* 133 */         throw new MBeanException(new ServiceNotFoundException("No Target"));
/*     */       try
/*     */       {
/* 136 */         value = setMethod.invoke(target, args);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 140 */         handleInvocationExceptions(t);
/* 141 */         return null;
/*     */       }
/*     */     }
/* 144 */     return value;
/*     */   }
/*     */ 
/*     */   protected void checkAssignable(String context, Class clazz, Object value) throws InvalidAttributeValueException, ClassNotFoundException
/*     */   {
/* 149 */     if ((value != null) && (!clazz.isAssignableFrom(value.getClass())))
/* 150 */       throw new InvalidAttributeValueException(context + " has class " + value.getClass() + " loaded from " + value.getClass().getClassLoader() + " that is not assignable to attribute class " + clazz + " loaded from " + clazz.getClassLoader());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.AttributeDispatcher
 * JD-Core Version:    0.6.0
 */