/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ 
/*     */ public abstract class AbstractInterceptor
/*     */   implements Interceptor
/*     */ {
/*  49 */   protected String name = "<no name>";
/*     */ 
/*  54 */   protected boolean isShared = false;
/*     */   protected Logger log;
/*     */ 
/*     */   public AbstractInterceptor()
/*     */   {
/*  72 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   public AbstractInterceptor(String name)
/*     */   {
/*  85 */     if ((name == null) || (name.equals(""))) {
/*  86 */       throw new IllegalArgumentException("null name");
/*     */     }
/*  88 */     this.name = name;
/*     */ 
/*  90 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 103 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 132 */     Interceptor ic = invocation.nextInterceptor();
/*     */ 
/* 137 */     if (ic == null) {
/* 138 */       return invocation.dispatch();
/*     */     }
/*     */ 
/* 141 */     if (ic.isShared())
/*     */     {
/* 144 */       SharedInterceptor shared = (SharedInterceptor)ic;
/*     */ 
/* 148 */       MBeanServer server = shared.getMBeanServer();
/*     */ 
/* 151 */       ObjectName name = shared.getObjectName();
/*     */ 
/* 153 */       return server.invoke(name, "invoke", new Object[] { invocation }, new String[] { Invocation.class.getName() });
/*     */     }
/*     */ 
/* 163 */     return ic.invoke(invocation);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 169 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean isShared()
/*     */   {
/* 174 */     return this.isShared;
/*     */   }
/*     */ 
/*     */   public void setLogger(Logger log)
/*     */   {
/* 179 */     this.log = log;
/*     */   }
/*     */ 
/*     */   public void init() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 200 */     String className = getClass().getName();
/* 201 */     int index = className.lastIndexOf('.');
/*     */ 
/* 203 */     return className.substring(index < 0 ? 0 : index) + "[name=" + this.name + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.AbstractInterceptor
 * JD-Core Version:    0.6.0
 */